/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class DirectAudioRenderer
extends AudioRenderer {
    static String NAME = "DirectAudioRenderer";
    static boolean loaded = false;

    public DirectAudioRenderer() {
        this.supportedFormats = new Format[]{new AudioFormat("LINEAR", 44100.0, -1, 2, 0, -1), new AudioFormat("LINEAR", 44100.0, -1, 1, 0, -1), new AudioFormat("LINEAR", 22050.0, -1, -1, 0, -1), new AudioFormat("LINEAR", 11025.0, -1, -1, 0, -1), new AudioFormat("LINEAR", 8000.0, -1, -1, 0, -1)};
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null && !this.initDevice(this.inputFormat)) {
            throw new ResourceUnavailableException("Cannot intialize audio device for playback");
        }
    }

    protected boolean initDevice(AudioFormat audioFormat) {
        this.devFormat = audioFormat;
        return super.initDevice(audioFormat);
    }

    public void close() {
        super.close();
    }

    public void flush() {
        this.device.flush();
    }

    protected AudioOutput createDevice(AudioFormat audioFormat) {
        return new DirectAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        return true;
    }

    public float setRate(float f2) {
        return super.setRate(1.0f);
    }

    private native long nOpen(int var1, int var2, int var3, int var4);

    private native void nClose(long var1);

    private native void nPause(long var1);

    private native void nResume(long var1);

    private native void nDrain(long var1);

    private native void nFlush(long var1);

    private native void nSetGain(long var1, float var3);

    private native void nSetMute(long var1, boolean var3);

    private native long nGetSamplesPlayed(long var1);

    private native int nBufferAvailable(long var1);

    private native int nWrite(long var1, byte[] var3, int var4, int var5);

    static {
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmdaud");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                loaded = false;
            }
        }
    }

    class DirectAudioOutput
    implements AudioOutput {
        private long peer = 0L;
        private int chunkSize;
        private int prefetchSize;
        private AudioFormat format;
        private boolean muted;
        private byte[] prefetchData;
        private int bufOffset;
        private int bufLen;
        private int prefetchDataLen = 0;
        private boolean paused = true;

        public boolean initialize(AudioFormat audioFormat, int n2) {
            if (!loaded) {
                return false;
            }
            this.format = audioFormat;
            this.prefetchSize = (int)(audioFormat.getSampleRate() * (double)audioFormat.getSampleSizeInBits() * (double)audioFormat.getChannels()) / 8;
            this.chunkSize = this.prefetchSize / 40 * 4;
            this.prefetchData = new byte[this.prefetchSize];
            this.peer = DirectAudioRenderer.this.nOpen((int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), this.chunkSize);
            if (this.peer != 0L) {
                this.setGain(DirectAudioRenderer.this.gainControl.getDB());
            }
            this.paused = true;
            return this.peer != 0L;
        }

        public synchronized void dispose() {
            DirectAudioRenderer.this.nClose(this.peer);
            this.peer = 0L;
        }

        public void pause() {
            DirectAudioRenderer.this.nPause(this.peer);
            this.paused = true;
        }

        public void resume() {
            DirectAudioRenderer.this.nResume(this.peer);
            if (this.prefetchDataLen > 0) {
                DirectAudioRenderer.this.nWrite(this.peer, this.prefetchData, 0, this.prefetchDataLen);
            }
            this.paused = false;
            this.prefetchDataLen = 0;
        }

        public void drain() {
            DirectAudioRenderer.this.nDrain(this.peer);
        }

        public void flush() {
            this.prefetchDataLen = 0;
            DirectAudioRenderer.this.nFlush(this.peer);
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public long getMediaNanoseconds() {
            long l2 = DirectAudioRenderer.this.nGetSamplesPlayed(this.peer);
            long l3 = (long)((double)(1000000L * l2) / this.format.getSampleRate()) * 1000L;
            return l3;
        }

        public double getGain() {
            return DirectAudioRenderer.this.gainControl.getDB();
        }

        public void setGain(double d2) {
            DirectAudioRenderer.this.nSetGain(this.peer, DirectAudioRenderer.this.gainControl.getLevel() * 0.5f);
        }

        public void setMute(boolean bl) {
            DirectAudioRenderer.this.nSetMute(this.peer, bl);
            this.muted = bl;
        }

        public boolean getMute() {
            return this.muted;
        }

        public float setRate(float f2) {
            return 1.0f;
        }

        public float getRate() {
            return 1.0f;
        }

        public int bufferAvailable() {
            return this.prefetchSize - this.prefetchDataLen;
        }

        public int write(byte[] byArray, int n2, int n3) {
            if (this.paused) {
                if (this.prefetchDataLen <= this.prefetchSize - 4) {
                    int n4 = this.prefetchSize - this.prefetchDataLen;
                    if (n4 > n3) {
                        n4 = n3;
                    }
                    System.arraycopy(byArray, n2, this.prefetchData, this.prefetchDataLen, n4);
                    this.prefetchDataLen += n4;
                    return n4;
                }
                return 0;
            }
            return DirectAudioRenderer.this.nWrite(this.peer, byArray, n2, n3);
        }
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer audioRenderer) {
            super(1.0f);
            this.renderer = audioRenderer;
            this.setLevel(0.3f);
        }

        public void setMute(boolean bl) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(bl);
            }
            super.setMute(bl);
        }

        public float setLevel(float f2) {
            float f3 = super.setLevel(f2);
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(this.getDB());
            }
            return f3;
        }
    }
}

