/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPBYEPacket
extends RTCPPacket {
    int[] ssrc;
    byte[] reason;

    public RTCPBYEPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 203;
    }

    public RTCPBYEPacket(int[] nArray, byte[] byArray) {
        this.ssrc = nArray;
        this.reason = byArray != null ? byArray : new byte[0];
        if (nArray.length > 31) {
            throw new IllegalArgumentException("Too many SSRCs");
        }
    }

    public String toString() {
        return "\tRTCP BYE packet for sync source(s) " + this.toString(this.ssrc) + " for " + (this.reason.length > 0 ? "reason " + new String(this.reason) : "no reason") + "\n";
    }

    public String toString(int[] nArray) {
        if (nArray.length == 0) {
            return "(none)";
        }
        String string = "" + nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            string = string + ", " + nArray[n2];
            ++n2;
        }
        return string;
    }

    public int calcLength() {
        return 4 + (this.ssrc.length << 2) + (this.reason.length > 0 ? this.reason.length + 4 & 0xFFFFFFFC : 0);
    }

    void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.ssrc.length);
        dataOutputStream.writeByte(203);
        dataOutputStream.writeShort(this.ssrc.length + (this.reason.length > 0 ? this.reason.length + 4 >> 2 : 0));
        int n2 = 0;
        while (n2 < this.ssrc.length) {
            dataOutputStream.writeInt(this.ssrc[n2]);
            ++n2;
        }
        if (this.reason.length > 0) {
            dataOutputStream.writeByte(this.reason.length);
            dataOutputStream.write(this.reason);
            int n3 = (this.reason.length + 4 & 0xFFFFFFFC) - this.reason.length - 1;
            while (n3 > 0) {
                dataOutputStream.writeByte(0);
                --n3;
            }
        }
    }
}

