/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SourceRTPPacket;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import javax.media.Buffer;
import javax.media.format.AudioFormat;

public class RTPDemultiplexer {
    private SSRCCache cache;
    private RTPRawReceiver rtpr;
    private Buffer buffer;
    private StreamSynch streamSynch;

    public RTPDemultiplexer(SSRCCache sSRCCache, RTPRawReceiver rTPRawReceiver, StreamSynch streamSynch) {
        this.cache = sSRCCache;
        this.rtpr = rTPRawReceiver;
        this.streamSynch = streamSynch;
        this.buffer = new Buffer();
    }

    public String consumerString() {
        return "RTP DeMultiplexer";
    }

    public void demuxpayload(Packet packet) {
        this.demuxpayload((RTPPacket)packet);
    }

    public void demuxpayload(SourceRTPPacket sourceRTPPacket) {
        SSRCInfo sSRCInfo = sourceRTPPacket.ssrcinfo;
        RTPPacket rTPPacket = sourceRTPPacket.p;
        sSRCInfo.payloadType = rTPPacket.payloadType;
        if (sSRCInfo.dstream != null) {
            this.buffer.setData(rTPPacket.base.data);
            this.buffer.setFlags(0);
            if (rTPPacket.marker == 1) {
                this.buffer.setFlags(this.buffer.getFlags() | 0x800);
            }
            this.buffer.setLength(rTPPacket.payloadlength);
            this.buffer.setOffset(rTPPacket.payloadoffset);
            if (sSRCInfo.dstream.getFormat() instanceof AudioFormat) {
                long l2 = this.streamSynch.calcTimestamp(sSRCInfo.ssrc, rTPPacket.payloadType, rTPPacket.timestamp);
                this.buffer.setTimeStamp(l2);
            } else {
                long l3 = this.streamSynch.calcTimestamp(sSRCInfo.ssrc, rTPPacket.payloadType, rTPPacket.timestamp);
                this.buffer.setTimeStamp(l3);
            }
            this.buffer.setFlags(this.buffer.getFlags() | 0x1000);
            this.buffer.setSequenceNumber(rTPPacket.seqnum);
            this.buffer.setFormat(sSRCInfo.dstream.getFormat());
            sSRCInfo.dstream.add(this.buffer, sSRCInfo.wrapped, this.rtpr);
        }
    }
}

