/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.media.Buffer;

public class RTPTransmitter {
    RTPRawSender sender;
    SSRCCache cache;

    public RTPTransmitter(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
    }

    public RTPTransmitter(SSRCCache sSRCCache, RTPRawSender rTPRawSender) {
        this(sSRCCache);
        this.setSender(rTPRawSender);
    }

    public RTPTransmitter(SSRCCache sSRCCache, int n2, String string) throws UnknownHostException, IOException {
        this(sSRCCache, new RTPRawSender(n2, string));
    }

    public RTPTransmitter(SSRCCache sSRCCache, int n2, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(sSRCCache, new RTPRawSender(n2, string, uDPPacketSender));
    }

    public void setSender(RTPRawSender rTPRawSender) {
        this.sender = rTPRawSender;
    }

    public RTPRawSender getSender() {
        return this.sender;
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    protected void transmit(RTPPacket rTPPacket) {
        try {
            this.sender.sendTo(rTPPacket);
        }
        catch (IOException iOException) {
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    public void TransmitPacket(Buffer buffer, SendSSRCInfo sendSSRCInfo) {
        sendSSRCInfo.rtptime = sendSSRCInfo.getTimeStamp(buffer);
        sendSSRCInfo.systime = buffer.getHeader() instanceof Long ? (Long)buffer.getHeader() : System.currentTimeMillis();
        RTPPacket rTPPacket = this.MakeRTPPacket(buffer, sendSSRCInfo);
        if (rTPPacket == null) {
            return;
        }
        this.transmit(rTPPacket);
        ++sendSSRCInfo.stats.total_pdu;
        sendSSRCInfo.stats.total_bytes += buffer.getLength();
        ++this.cache.sm.transstats.rtp_sent;
        this.cache.sm.transstats.bytes_sent += buffer.getLength();
    }

    protected RTPPacket MakeRTPPacket(Buffer buffer, SendSSRCInfo sendSSRCInfo) {
        byte[] byArray = (byte[])buffer.getData();
        if (byArray == null) {
            return null;
        }
        Packet packet = new Packet();
        packet.data = byArray;
        packet.offset = 0;
        packet.length = buffer.getLength();
        packet.received = false;
        RTPPacket rTPPacket = new RTPPacket(packet);
        rTPPacket.marker = (buffer.getFlags() & 0x800) != 0 ? 1 : 0;
        sendSSRCInfo.packetsize += buffer.getLength();
        rTPPacket.payloadType = sendSSRCInfo.payloadType;
        rTPPacket.seqnum = (int)sendSSRCInfo.getSequenceNumber(buffer);
        rTPPacket.timestamp = sendSSRCInfo.rtptime;
        rTPPacket.ssrc = sendSSRCInfo.ssrc;
        rTPPacket.payloadoffset = buffer.getOffset();
        rTPPacket.payloadlength = buffer.getLength();
        sendSSRCInfo.bytesreceived += buffer.getLength();
        ++sendSSRCInfo.maxseq;
        sendSSRCInfo.lasttimestamp = rTPPacket.timestamp;
        return rTPPacket;
    }
}

