/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTPSinkStream;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.RTPStats;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.util.SSRCTable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.media.Format;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;

public abstract class SSRCInfo
implements Report {
    private SSRCCache cache;
    boolean alive = false;
    boolean payloadchange = false;
    boolean byeReceived = false;
    long byeTime = 0L;
    String byereason = null;
    RTPSourceInfo sourceInfo = null;
    SourceDescription name = null;
    SourceDescription email = null;
    SourceDescription phone = null;
    SourceDescription loc = null;
    SourceDescription tool = null;
    SourceDescription note = null;
    SourceDescription priv = null;
    long lastSRntptimestamp = 0L;
    long lastSRrtptimestamp = 0L;
    long lastSRoctetcount = 0L;
    long lastSRpacketcount = 0L;
    long lastRTCPreceiptTime = 0L;
    long lastSRreceiptTime = 0L;
    long lastHeardFrom = 0L;
    boolean quiet = false;
    boolean inactivesent = false;
    boolean aging;
    boolean sender = false;
    boolean ours = false;
    int ssrc;
    boolean streamconnect = false;
    SSRCTable reports = new SSRCTable();
    boolean active = false;
    boolean newrecvstream = false;
    boolean recvstrmap = false;
    boolean newpartsent = false;
    boolean lastsr = false;
    boolean wrapped = false;
    static final int INITIALPROBATION = 2;
    int probation = 2;
    static final int PAYLOAD_UNASSIGNED = -1;
    boolean wassender = false;
    int prevmaxseq;
    int prevlost;
    long starttime;
    long rtptime;
    long systime;
    InetAddress address;
    int port;
    RTCPReporter reporter;
    Format currentformat = null;
    int payloadType = -1;
    com.sun.media.protocol.rtp.DataSource dsource = null;
    DataSource pds = null;
    RTPSourceStream dstream = null;
    RTPSinkStream sinkstream = null;
    long lastRTPReceiptTime;
    int maxseq = 0;
    int cycles = 0;
    int baseseq;
    int lastbadseq;
    int received;
    long lasttimestamp = 0L;
    int lastPayloadType = -1;
    double jitter = 0.0;
    int bytesreceived;
    RTPStats stats = null;
    int clockrate = 0;

    SSRCInfo(SSRCCache sSRCCache, int n2) {
        this.cache = sSRCCache;
        this.ssrc = n2;
        this.stats = new RTPStats();
    }

    SSRCInfo(SSRCInfo sSRCInfo) {
        this.cache = sSRCInfo.cache;
        this.alive = sSRCInfo.alive;
        this.sourceInfo = sSRCInfo.sourceInfo;
        if (this.sourceInfo != null) {
            this.sourceInfo.addSSRC(this);
        }
        this.cache.remove(sSRCInfo.ssrc);
        this.name = sSRCInfo.name;
        this.email = sSRCInfo.email;
        this.phone = sSRCInfo.phone;
        this.loc = sSRCInfo.loc;
        this.tool = sSRCInfo.tool;
        this.note = sSRCInfo.note;
        this.priv = sSRCInfo.priv;
        this.lastSRntptimestamp = sSRCInfo.lastSRntptimestamp;
        this.lastSRrtptimestamp = sSRCInfo.lastSRrtptimestamp;
        this.lastSRoctetcount = sSRCInfo.lastSRoctetcount;
        this.lastSRpacketcount = sSRCInfo.lastSRpacketcount;
        this.lastRTCPreceiptTime = sSRCInfo.lastRTCPreceiptTime;
        this.lastSRreceiptTime = sSRCInfo.lastSRreceiptTime;
        this.lastHeardFrom = sSRCInfo.lastHeardFrom;
        this.quiet = sSRCInfo.quiet;
        this.inactivesent = sSRCInfo.inactivesent;
        this.aging = sSRCInfo.aging;
        this.reports = sSRCInfo.reports;
        this.ours = sSRCInfo.ours;
        this.ssrc = sSRCInfo.ssrc;
        this.streamconnect = sSRCInfo.streamconnect;
        this.newrecvstream = sSRCInfo.newrecvstream;
        this.recvstrmap = sSRCInfo.recvstrmap;
        this.newpartsent = sSRCInfo.newpartsent;
        this.lastsr = sSRCInfo.lastsr;
        this.probation = sSRCInfo.probation;
        this.wassender = sSRCInfo.wassender;
        this.prevmaxseq = sSRCInfo.prevmaxseq;
        this.prevlost = sSRCInfo.prevlost;
        this.starttime = sSRCInfo.starttime;
        this.reporter = sSRCInfo.reporter;
        if (sSRCInfo.reporter != null) {
            this.reporter.transmit.setSSRCInfo(this);
        }
        this.payloadType = sSRCInfo.payloadType;
        this.dsource = sSRCInfo.dsource;
        this.pds = sSRCInfo.pds;
        this.dstream = sSRCInfo.dstream;
        this.lastRTPReceiptTime = sSRCInfo.lastRTPReceiptTime;
        this.maxseq = sSRCInfo.maxseq;
        this.cycles = sSRCInfo.cycles;
        this.baseseq = sSRCInfo.baseseq;
        this.lastbadseq = sSRCInfo.lastbadseq;
        this.received = sSRCInfo.received;
        this.lasttimestamp = sSRCInfo.lasttimestamp;
        this.lastPayloadType = sSRCInfo.lastPayloadType;
        this.jitter = sSRCInfo.jitter;
        this.bytesreceived = sSRCInfo.bytesreceived;
        this.address = sSRCInfo.address;
        this.port = sSRCInfo.port;
        this.stats = sSRCInfo.stats;
        this.clockrate = sSRCInfo.clockrate;
        this.byeTime = sSRCInfo.byeTime;
        this.byeReceived = sSRCInfo.byeReceived;
    }

    private void InitSDES() {
        this.name = new SourceDescription(2, null, 0, false);
        this.email = new SourceDescription(3, null, 0, false);
        this.phone = new SourceDescription(4, null, 0, false);
        this.loc = new SourceDescription(5, null, 0, false);
        this.tool = new SourceDescription(6, null, 0, false);
        this.note = new SourceDescription(7, null, 0, false);
        this.priv = new SourceDescription(8, null, 0, false);
    }

    RTPSourceInfo getRTPSourceInfo() {
        return this.sourceInfo;
    }

    boolean isActive() {
        return this.active;
    }

    int getPayloadType() {
        return this.payloadType;
    }

    void setSourceDescription(SourceDescription[] sourceDescriptionArray) {
        Object object;
        if (sourceDescriptionArray == null) {
            return;
        }
        String string = null;
        int n2 = 0;
        while (n2 < sourceDescriptionArray.length) {
            object = sourceDescriptionArray[n2];
            if (object != null && ((SourceDescription)object).getType() == 1) {
                string = sourceDescriptionArray[n2].getDescription();
                break;
            }
            ++n2;
        }
        object = null;
        if (this.sourceInfo != null) {
            object = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && string != null && !string.equals(object)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(string, true);
            this.sourceInfo.addSSRC(this);
        }
        int n3 = 0;
        while (n3 < sourceDescriptionArray.length) {
            SourceDescription sourceDescription = sourceDescriptionArray[n3];
            if (sourceDescription != null) {
                switch (sourceDescription.getType()) {
                    case 2: {
                        if (this.name == null) {
                            this.name = new SourceDescription(2, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.name.setDescription(sourceDescription.getDescription());
                        break;
                    }
                    case 3: {
                        if (this.email == null) {
                            this.email = new SourceDescription(3, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.email.setDescription(sourceDescription.getDescription());
                        break;
                    }
                    case 4: {
                        if (this.phone == null) {
                            this.phone = new SourceDescription(4, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.phone.setDescription(sourceDescription.getDescription());
                        break;
                    }
                    case 5: {
                        if (this.loc == null) {
                            this.loc = new SourceDescription(5, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.loc.setDescription(sourceDescription.getDescription());
                        break;
                    }
                    case 6: {
                        if (this.tool == null) {
                            this.tool = new SourceDescription(6, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.tool.setDescription(sourceDescription.getDescription());
                        break;
                    }
                    case 7: {
                        if (this.note == null) {
                            this.note = new SourceDescription(7, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.note.setDescription(sourceDescription.getDescription());
                        break;
                    }
                    case 8: {
                        if (this.priv == null) {
                            this.priv = new SourceDescription(8, sourceDescription.getDescription(), 0, false);
                            break;
                        }
                        this.priv.setDescription(sourceDescription.getDescription());
                        break;
                    }
                }
            }
            ++n3;
        }
    }

    void delete() {
        if (this.sourceInfo != null) {
            this.sourceInfo.removeSSRC(this);
        }
    }

    void addSDESInfo(RTCPSDES rTCPSDES) {
        int n2 = 0;
        while (n2 < rTCPSDES.items.length) {
            if (rTCPSDES.items[n2].type == 1) break;
            ++n2;
        }
        String string = new String(rTCPSDES.items[n2].data);
        String string2 = null;
        if (this.sourceInfo != null) {
            string2 = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && !string.equals(string2)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(string, this.ours);
            this.sourceInfo.addSSRC(this);
        }
        if (rTCPSDES.items.length > 1) {
            int n3 = 0;
            while (n3 < rTCPSDES.items.length) {
                string = new String(rTCPSDES.items[n3].data);
                switch (rTCPSDES.items[n3].type) {
                    case 2: {
                        if (this.name == null) {
                            this.name = new SourceDescription(2, string, 0, false);
                            break;
                        }
                        this.name.setDescription(string);
                        break;
                    }
                    case 3: {
                        if (this.email == null) {
                            this.email = new SourceDescription(3, string, 0, false);
                            break;
                        }
                        this.email.setDescription(string);
                        break;
                    }
                    case 4: {
                        if (this.phone == null) {
                            this.phone = new SourceDescription(4, string, 0, false);
                            break;
                        }
                        this.phone.setDescription(string);
                        break;
                    }
                    case 5: {
                        if (this.loc == null) {
                            this.loc = new SourceDescription(5, string, 0, false);
                            break;
                        }
                        this.loc.setDescription(string);
                        break;
                    }
                    case 6: {
                        if (this.tool == null) {
                            this.tool = new SourceDescription(6, string, 0, false);
                            break;
                        }
                        this.tool.setDescription(string);
                        break;
                    }
                    case 7: {
                        if (this.note == null) {
                            this.note = new SourceDescription(7, string, 0, false);
                            break;
                        }
                        this.note.setDescription(string);
                        break;
                    }
                    case 8: {
                        if (this.priv == null) {
                            this.priv = new SourceDescription(8, string, 0, false);
                            break;
                        }
                        this.priv.setDescription(string);
                    }
                }
                ++n3;
            }
        }
    }

    void initsource(int n2) {
        if (this.probation <= 0) {
            this.active = true;
            this.setSender(true);
        }
        this.baseseq = n2;
        this.maxseq = n2 - 1;
        this.lastbadseq = -2;
        this.cycles = 0;
        this.received = 0;
        this.bytesreceived = 0;
        this.lastRTPReceiptTime = 0L;
        this.lasttimestamp = 0L;
        this.jitter = 0.0;
        this.prevmaxseq = this.maxseq;
        this.prevlost = 0;
    }

    void setAlive(boolean bl) {
        this.setAging(false);
        if (this.alive == bl) {
            return;
        }
        if (bl) {
            this.reports.removeAll();
        } else {
            this.setSender(false);
        }
        this.alive = bl;
    }

    void setSender(boolean bl) {
        if (this.sender == bl) {
            return;
        }
        if (bl) {
            ++this.cache.sendercount;
            this.setAlive(true);
        } else {
            --this.cache.sendercount;
        }
        this.sender = bl;
    }

    void setOurs(boolean bl) {
        if (this.ours == bl) {
            return;
        }
        if (bl) {
            this.setAlive(true);
        } else {
            this.setAlive(false);
        }
        this.ours = bl;
    }

    void setAging(boolean bl) {
        if (this.aging == bl) {
            return;
        }
        this.aging = bl;
    }

    public String getCNAME() {
        return this.sourceInfo == null ? null : this.sourceInfo.getCNAME();
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public Vector getFeedbackReports() {
        RTCPReportBlock[] rTCPReportBlockArray = null;
        if (this.reports.size() == 0) {
            Vector vector = new Vector(0);
            return vector;
        }
        Vector<RTCPReportBlock> vector = new Vector<RTCPReportBlock>(this.reports.size());
        Enumeration enumeration = this.reports.elements();
        try {
            while (enumeration.hasMoreElements()) {
                rTCPReportBlockArray = (RTCPReportBlock[])enumeration.nextElement();
                RTCPReportBlock rTCPReportBlock = new RTCPReportBlock();
                rTCPReportBlock = rTCPReportBlockArray[0];
                vector.addElement(rTCPReportBlock);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("No more elements");
        }
        vector.trimToSize();
        return vector;
    }

    public Participant getParticipant() {
        if (this.sourceInfo instanceof LocalParticipant && this.cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public SSRCCache getSSRCCache() {
        return this.cache;
    }

    public Vector getSourceDescription() {
        Vector<SourceDescription> vector = new Vector<SourceDescription>();
        vector.addElement(this.sourceInfo.getCNAMESDES());
        if (this.name != null) {
            vector.addElement(this.name);
        }
        if (this.email != null) {
            vector.addElement(this.email);
        }
        if (this.phone != null) {
            vector.addElement(this.phone);
        }
        if (this.loc != null) {
            vector.addElement(this.loc);
        }
        if (this.tool != null) {
            vector.addElement(this.tool);
        }
        if (this.note != null) {
            vector.addElement(this.note);
        }
        if (this.priv != null) {
            vector.addElement(this.priv);
        }
        vector.trimToSize();
        return vector;
    }
}

