/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.ui.AudioButton;
import com.sun.media.ui.BasicComp;
import com.sun.media.ui.BufferedPanel;
import com.sun.media.ui.BufferedPanelLight;
import com.sun.media.ui.ButtonComp;
import com.sun.media.ui.GainControlComponent;
import com.sun.media.ui.ProgressSlider;
import com.sun.media.ui.PropertySheet;
import com.sun.media.ui.TransparentPanel;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.Format;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.RateChangeEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.media.control.FramePositioningControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class DefaultControlPanel
extends BufferedPanelLight
implements ActionListener,
ItemListener,
ControllerListener,
GainChangeListener,
ComponentListener {
    static final Color colorBackground = new Color(192, 192, 192);
    private static final String MENU_PROPERTIES = JMFI18N.getResource("mediaplayer.properties");
    private static final String MENU_RATE_1_4 = JMFI18N.getResource("mediaplayer.rate.1:4");
    private static final String MENU_RATE_1_2 = JMFI18N.getResource("mediaplayer.rate.1:2");
    private static final String MENU_RATE_1_1 = JMFI18N.getResource("mediaplayer.rate.1:1");
    private static final String MENU_RATE_2_1 = JMFI18N.getResource("mediaplayer.rate.2:1");
    private static final String MENU_RATE_4_1 = JMFI18N.getResource("mediaplayer.rate.4:1");
    private static final String MENU_RATE_8_1 = JMFI18N.getResource("mediaplayer.rate.8:1");
    private static final String MENU_MEDIA = JMFI18N.getResource("mediaplayer.menu.media");
    private static final String MENU_AUDIO = JMFI18N.getResource("mediaplayer.menu.audio");
    private static final String MENU_VIDEO = JMFI18N.getResource("mediaplayer.menu.video");
    Player player;
    Frame parentFrame = null;
    Container container = null;
    TransparentPanel panelLeft;
    TransparentPanel panelRight;
    TransparentPanel panelProgress;
    boolean boolAdded = false;
    ButtonComp buttonPlay = null;
    ButtonComp buttonStepBack = null;
    ButtonComp buttonStepFwd = null;
    AudioButton buttonAudio = null;
    ButtonComp buttonMedia = null;
    ProgressSlider progressSlider = null;
    CheckboxMenuItem menuItemCheck = null;
    PopupMenu menuPopup = null;
    WindowListener wl = null;
    private boolean firstTime = true;
    private boolean started = false;
    private Integer localLock = new Integer(0);
    GainControlComponent audioControls = null;
    PropertySheet propsSheet = null;
    FramePositioningControl controlFrame = null;
    ProgressControl progressControl = null;
    GainControl gainControl = null;
    SliderRegionControl regionControl = null;
    String urlName = null;
    long lFrameStep = 0L;
    private CheckboxMenuItem menuRate_1_4 = null;
    private CheckboxMenuItem menuRate_1_2 = null;
    private CheckboxMenuItem menuRate_1_1 = null;
    private CheckboxMenuItem menuRate_2_1 = null;
    private CheckboxMenuItem menuRate_4_1 = null;
    private CheckboxMenuItem menuRate_8_1 = null;
    private Vector vectorTracksAudio = new Vector();
    private Vector vectorTracksVideo = new Vector();
    private int pausecnt = -1;
    private boolean resetMediaTimeinPause = false;

    public DefaultControlPanel(Player player) {
        this.player = player;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNotify() {
        boolean bl = true;
        if (!this.boolAdded) {
            Container container = this.getParent();
            while (container != null && bl) {
                ComponentPeer componentPeer = container.getPeer();
                if ((container = container.getParent()) == null) break;
                if (componentPeer == null || componentPeer instanceof LightweightPeer) continue;
                bl = false;
            }
            if (this.container != null) {
                this.container.remove(this.panelLeft);
                this.container.remove(this.panelRight);
                this.container.remove(this.panelProgress);
                if (this.container != this) {
                    this.remove(this.container);
                }
            }
            if (bl) {
                this.container = this;
            } else {
                this.container = new BufferedPanel(new BorderLayout());
                this.container.setBackground(colorBackground);
                ((BufferedPanel)this.container).setBackgroundTile(BasicComp.fetchImage("texture3.gif"));
                this.add((Component)this.container, "Center");
            }
            this.container.add((Component)this.panelLeft, "West");
            this.container.add((Component)this.panelRight, "East");
            this.container.add((Component)this.panelProgress, "Center");
            this.boolAdded = true;
        }
        this.setVisible(true);
        super.addNotify();
        this.validate();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.boolAdded) {
            this.boolAdded = false;
        }
    }

    protected void removePlayButton() {
        this.panelLeft.remove(this.buttonPlay);
    }

    private void init() throws Exception {
        TrackControl trackControl;
        this.getPlayerControls();
        if (this.gainControl != null) {
            this.gainControl.addGainChangeListener(this);
        }
        this.setBackground(colorBackground);
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.container = this;
        this.panelLeft = new TransparentPanel(new GridLayout(1, 0));
        this.container.add((Component)this.panelLeft, "West");
        this.panelRight = new TransparentPanel(new GridLayout(1, 0));
        this.container.add((Component)this.panelRight, "East");
        this.panelProgress = new TransparentPanel(new BorderLayout());
        this.container.add((Component)this.panelProgress, "Center");
        this.buttonPlay = new ButtonComp("Play", "play.gif", "play-active.gif", "play-pressed.gif", "play-disabled.gif", "pause.gif", "pause-active.gif", "pause-pressed.gif", "pause-disabled.gif");
        this.buttonPlay.setActionListener(this);
        this.panelLeft.add(this.buttonPlay);
        if (this.controlFrame != null) {
            this.buttonStepBack = new ButtonComp("StepBack", "step-back.gif", "step-back-active.gif", "step-back-pressed.gif", "step-back-disabled.gif", "step-back.gif", "step-back-active.gif", "step-back-pressed.gif", "step-back-disabled.gif");
            this.buttonStepBack.setActionListener(this);
            this.buttonStepBack.setContMousePress(true);
            this.panelLeft.add(this.buttonStepBack);
            this.buttonStepFwd = new ButtonComp("StepForward", "step-fwd.gif", "step-fwd-active.gif", "step-fwd-pressed.gif", "step-fwd-disabled.gif", "step-fwd.gif", "step-fwd-active.gif", "step-fwd-pressed.gif", "step-fwd-disabled.gif");
            this.buttonStepFwd.setActionListener(this);
            this.buttonStepFwd.setContMousePress(true);
            this.panelLeft.add(this.buttonStepFwd);
        }
        if (this.gainControl != null) {
            this.buttonAudio = new AudioButton(this.gainControl);
            this.buttonAudio.setActionListener(this);
            this.panelRight.add(this.buttonAudio);
        }
        this.buttonMedia = new ButtonComp("Media", "media.gif", "media-active.gif", "media-pressed.gif", "media-disabled.gif", "media.gif", "media-active.gif", "media-pressed.gif", "media-disabled.gif");
        this.buttonMedia.setActionListener(this);
        this.panelRight.add(this.buttonMedia);
        this.progressSlider = new ProgressSlider("mediatime", this, this.player);
        this.progressSlider.setActionListener(this);
        this.panelProgress.add((Component)this.progressSlider, "Center");
        Time time = this.player.getDuration();
        if (time == Duration.DURATION_UNBOUNDED || time == Duration.DURATION_UNKNOWN) {
            this.progressSlider.setEnabled(false);
        }
        this.updateButtonState();
        this.validate();
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension);
        this.setVisible(true);
        this.setBackgroundTile(BasicComp.fetchImage("texture3.gif"));
        this.player.addControllerListener(this);
        Control[] controlArray = this.player.getControls();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (controlArray[n3] instanceof TrackControl) {
                trackControl = (TrackControl)controlArray[n3];
                Format format = trackControl.getFormat();
                if (format instanceof AudioFormat) {
                    this.vectorTracksAudio.addElement(trackControl);
                } else if (format instanceof VideoFormat) {
                    this.vectorTracksVideo.addElement(trackControl);
                    VideoFormat videoFormat = (VideoFormat)format;
                    float f2 = videoFormat.getFrameRate();
                    this.lFrameStep = (long)(1.0E9f / f2);
                }
            }
            ++n3;
        }
        this.menuPopup = new PopupMenu(MENU_MEDIA);
        this.buttonMedia.setPopupMenu(this.menuPopup);
        n2 = this.vectorTracksAudio.size();
        boolean bl = false;
        if (n2 > 1) {
            n3 = 0;
            while (n3 < n2) {
                trackControl = (TrackControl)this.vectorTracksAudio.elementAt(n3);
                boolean bl2 = false;
                if (!bl && trackControl.isEnabled()) {
                    bl = true;
                    bl2 = true;
                }
                this.menuItemCheck = new CheckboxMenuItem(MENU_AUDIO + " " + n3, bl2);
                this.muteAudioTrack(trackControl, !bl2);
                this.menuItemCheck.addItemListener(this);
                this.menuPopup.add(this.menuItemCheck);
                ++n3;
            }
            this.menuPopup.addSeparator();
        }
        this.menuRate_1_4 = new CheckboxMenuItem(MENU_RATE_1_4, false);
        this.menuRate_1_4.addItemListener(this);
        this.menuPopup.add(this.menuRate_1_4);
        this.menuRate_1_2 = new CheckboxMenuItem(MENU_RATE_1_2, false);
        this.menuRate_1_2.addItemListener(this);
        this.menuPopup.add(this.menuRate_1_2);
        this.menuRate_1_1 = new CheckboxMenuItem(MENU_RATE_1_1, true);
        this.menuRate_1_1.addItemListener(this);
        this.menuPopup.add(this.menuRate_1_1);
        this.menuRate_2_1 = new CheckboxMenuItem(MENU_RATE_2_1, false);
        this.menuRate_2_1.addItemListener(this);
        this.menuPopup.add(this.menuRate_2_1);
        this.menuRate_4_1 = new CheckboxMenuItem(MENU_RATE_4_1, false);
        this.menuRate_4_1.addItemListener(this);
        this.menuPopup.add(this.menuRate_4_1);
        this.menuRate_8_1 = new CheckboxMenuItem(MENU_RATE_8_1, false);
        this.menuRate_8_1.addItemListener(this);
        this.menuPopup.add(this.menuRate_8_1);
    }

    private void updateButtonState() {
        if (this.player == null) {
            this.buttonPlay.setEnabled(false);
        } else {
            this.buttonPlay.setEnabled(true);
            if (this.player.getState() == 600) {
                this.buttonPlay.setValue(true);
            } else {
                this.buttonPlay.setValue(false);
            }
        }
    }

    public void minicleanUp() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            this.firstTime = true;
        }
    }

    public void dispose() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.player == null) {
                return;
            }
            if (this.propsSheet != null) {
                this.propsSheet.dispose();
                this.propsSheet = null;
            }
            if (this.progressSlider != null) {
                this.progressSlider.dispose();
                this.progressSlider = null;
            }
            if (this.audioControls != null) {
                this.remove(this.audioControls);
                this.audioControls = null;
            }
            if (this.buttonAudio != null) {
                this.buttonAudio.dispose();
                this.buttonAudio = null;
            }
            this.player = null;
            this.gainControl = null;
            this.controlFrame = null;
            if (this.parentFrame != null && this.wl != null) {
                this.parentFrame.removeWindowListener(this.wl);
                this.parentFrame = null;
                this.wl = null;
            }
            this.vectorTracksAudio.removeAllElements();
            this.vectorTracksVideo.removeAllElements();
            if (this.menuItemCheck != null) {
                this.menuItemCheck.removeItemListener(this);
            }
            this.menuRate_1_4.removeItemListener(this);
            this.menuRate_1_2.removeItemListener(this);
            this.menuRate_8_1.removeItemListener(this);
            this.menuRate_4_1.removeItemListener(this);
            this.menuRate_2_1.removeItemListener(this);
            this.menuRate_1_1.removeItemListener(this);
            this.buttonMedia.setPopupMenu(null);
        }
    }

    private void getPlayerControls() {
        if (this.player == null) {
            return;
        }
        this.gainControl = this.player.getGainControl();
        Control control = this.player.getControl("javax.media.control.FramePositioningControl");
        if (control != null && control instanceof FramePositioningControl) {
            this.controlFrame = (FramePositioningControl)control;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase(this.buttonPlay.getLabel())) {
            this.playStop();
        }
        if (this.buttonAudio != null && string.equalsIgnoreCase(this.buttonAudio.getLabel())) {
            this.audioMute();
        } else if (string.equalsIgnoreCase(this.buttonMedia.getLabel()) || string.equalsIgnoreCase(MENU_PROPERTIES)) {
            this.showPropsSheet();
        } else if (this.buttonStepBack != null && string.equalsIgnoreCase(this.buttonStepBack.getLabel())) {
            this.playStep(false);
        } else if (this.buttonStepFwd != null && string.equalsIgnoreCase(this.buttonStepFwd.getLabel())) {
            this.playStep(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        int n2 = itemEvent.getStateChange();
        Object object = itemEvent.getItem();
        if (itemSelectable == this.menuRate_1_4 && n2 == 1) {
            this.menuRate_1_4.setState(false);
            this.player.setRate(0.25f);
        } else if (itemSelectable == this.menuRate_1_2 && n2 == 1) {
            this.menuRate_1_2.setState(false);
            this.player.setRate(0.5f);
        } else if (itemSelectable == this.menuRate_1_1 && n2 == 1) {
            this.menuRate_1_1.setState(false);
            this.player.setRate(1.0f);
        } else if (itemSelectable == this.menuRate_2_1 && n2 == 1) {
            this.menuRate_2_1.setState(false);
            this.player.setRate(2.0f);
        } else if (itemSelectable == this.menuRate_4_1 && n2 == 1) {
            this.menuRate_4_1.setState(false);
            this.player.setRate(4.0f);
        } else if (itemSelectable == this.menuRate_8_1 && n2 == 1) {
            this.menuRate_8_1.setState(false);
            this.player.setRate(8.0f);
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.substring(0, 5).equalsIgnoreCase(MENU_AUDIO)) {
                int n3 = Integer.valueOf(string.substring(6));
                TrackControl trackControl = (TrackControl)this.vectorTracksAudio.elementAt(n3);
                boolean bl = itemEvent.getStateChange() == 1;
                this.muteAudioTrack(trackControl, !bl);
            } else if (string.substring(0, 5).equalsIgnoreCase(MENU_VIDEO)) {
                // empty if block
            }
        }
    }

    void update() {
        if (this.propsSheet == null || this.player == null) {
            return;
        }
        if (this.player.getState() == 600) {
            this.pausecnt = -1;
            this.propsSheet.update();
        } else if (this.pausecnt < 5) {
            ++this.pausecnt;
            this.propsSheet.update();
        } else if (this.pausecnt == 5) {
            ++this.pausecnt;
            this.propsSheet.clearBRFR();
        } else if (this.resetMediaTimeinPause) {
            this.resetMediaTimeinPause = false;
            this.propsSheet.updateMediaTime();
        }
    }

    void resetPauseCount() {
        this.pausecnt = -1;
    }

    private void playStop() {
        boolean bl = this.buttonPlay.getValue();
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.player == null || this.buttonPlay == null) {
                return;
            }
            if (bl) {
                if (this.player.getTargetState() != 600) {
                    this.buttonPlay.setEnabled(false);
                    long l2 = this.player.getDuration().getNanoseconds();
                    long l3 = this.player.getMediaNanoseconds();
                    if (l3 >= l2) {
                        this.player.setMediaTime(new Time(0L));
                    }
                    this.player.start();
                }
            } else if (this.player.getTargetState() == 600) {
                this.buttonPlay.setEnabled(false);
                this.player.stop();
            }
        }
    }

    private void audioMute() {
        if (this.gainControl == null) {
            return;
        }
        boolean bl = this.buttonAudio.getValue();
        this.gainControl.setMute(bl);
    }

    private void playStep(boolean bl) {
        if (this.controlFrame == null) {
            return;
        }
        if (this.player.getTargetState() == 600) {
            this.buttonPlay.setEnabled(false);
            this.player.stop();
        }
        this.controlFrame.skip(bl ? 1 : -1);
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.player == null) {
                return;
            }
            if (controllerEvent instanceof StartEvent) {
                this.buttonPlay.setValue(true);
                this.buttonPlay.setEnabled(true);
                if (this.buttonStepFwd != null) {
                    this.buttonStepFwd.setEnabled(true);
                }
                if (this.buttonStepBack != null) {
                    this.buttonStepBack.setEnabled(true);
                }
            } else if (controllerEvent instanceof StopEvent || controllerEvent instanceof ResourceUnavailableEvent) {
                this.buttonPlay.setValue(false);
                this.buttonPlay.setEnabled(true);
                Thread.yield();
                long l2 = this.player.getDuration().getNanoseconds();
                long l3 = this.player.getMediaNanoseconds();
                if (this.buttonStepFwd != null) {
                    if (l3 < l2 - 1L) {
                        this.buttonStepFwd.setEnabled(true);
                    } else {
                        this.buttonStepFwd.setEnabled(false);
                    }
                }
                if (this.buttonStepBack != null) {
                    if (l3 > 0L) {
                        this.buttonStepBack.setEnabled(true);
                    } else {
                        this.buttonStepBack.setEnabled(false);
                    }
                }
            } else if (controllerEvent instanceof DurationUpdateEvent) {
                Time time = this.player.getDuration();
                if (time == Duration.DURATION_UNKNOWN || time == Duration.DURATION_UNBOUNDED) {
                    this.progressSlider.setEnabled(false);
                } else {
                    this.progressSlider.setEnabled(true);
                }
                if (this.propsSheet != null) {
                    this.propsSheet.updateDuration();
                }
            } else if (controllerEvent instanceof MediaTimeSetEvent) {
                Thread.yield();
                long l4 = this.player.getDuration().getNanoseconds();
                long l5 = this.player.getMediaNanoseconds();
                if (this.buttonStepFwd != null) {
                    if (l5 < l4 - 1L) {
                        this.buttonStepFwd.setEnabled(true);
                    } else {
                        this.buttonStepFwd.setEnabled(false);
                    }
                }
                if (this.buttonStepBack != null) {
                    if (l5 > 0L) {
                        this.buttonStepBack.setEnabled(true);
                    } else {
                        this.buttonStepBack.setEnabled(false);
                    }
                }
                this.resetMediaTimeinPause = true;
            } else if (controllerEvent instanceof RateChangeEvent) {
                this.menuRate_1_4.setState(false);
                this.menuRate_1_2.setState(false);
                this.menuRate_1_1.setState(false);
                this.menuRate_2_1.setState(false);
                this.menuRate_4_1.setState(false);
                this.menuRate_8_1.setState(false);
                float f2 = this.player.getRate();
                if ((double)f2 < 0.5) {
                    this.menuRate_1_4.removeItemListener(this);
                    this.menuRate_1_4.setState(true);
                    this.menuRate_1_4.addItemListener(this);
                } else if ((double)f2 < 1.0) {
                    this.menuRate_1_2.removeItemListener(this);
                    this.menuRate_1_2.setState(true);
                    this.menuRate_1_2.addItemListener(this);
                } else if ((double)f2 > 4.0) {
                    this.menuRate_8_1.removeItemListener(this);
                    this.menuRate_8_1.setState(true);
                    this.menuRate_8_1.addItemListener(this);
                } else if ((double)f2 > 2.0) {
                    this.menuRate_4_1.removeItemListener(this);
                    this.menuRate_4_1.setState(true);
                    this.menuRate_4_1.addItemListener(this);
                } else if ((double)f2 > 1.0) {
                    this.menuRate_2_1.removeItemListener(this);
                    this.menuRate_2_1.setState(true);
                    this.menuRate_2_1.addItemListener(this);
                } else {
                    this.menuRate_1_1.removeItemListener(this);
                    this.menuRate_1_1.setState(true);
                    this.menuRate_1_1.addItemListener(this);
                }
            }
        }
    }

    public void gainChange(GainChangeEvent gainChangeEvent) {
        boolean bl = this.gainControl.getMute();
        this.buttonAudio.setValue(bl);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.validate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.firstTime) {
            this.findFrame();
        }
        super.paint(graphics);
    }

    protected void findFrame() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.firstTime) {
                this.firstTime = false;
                Container container = this.getParent();
                while (!(container instanceof Frame) && container != null) {
                    container = container.getParent();
                }
                if (container instanceof Frame) {
                    this.parentFrame = (Frame)container;
                    this.wl = new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            DefaultControlPanel.this.minicleanUp();
                        }
                    };
                    ((Frame)container).addWindowListener(this.wl);
                }
            }
        }
    }

    public Insets getInsets() {
        Insets insets = new Insets(1, 0, 0, 0);
        return insets;
    }

    private void showPropsSheet() {
        if (this.propsSheet == null) {
            try {
                this.propsSheet = new PropertySheet(this.parentFrame, this.player);
                if (this.isShowing()) {
                    Point point = this.getLocationOnScreen();
                    Dimension dimension = this.getSize();
                    point.y += dimension.height;
                    ((Component)this.propsSheet).setLocation(point);
                }
            }
            catch (Exception exception) {
                this.propsSheet = null;
            }
        }
        if (this.propsSheet != null) {
            ((Component)this.propsSheet).setVisible(true);
        }
    }

    private void muteAudioTrack(TrackControl trackControl, boolean bl) {
        Object[] objectArray = trackControl.getControls();
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] instanceof GainControl) {
                ((GainControl)objectArray[n3]).setMute(bl);
            }
            ++n3;
        }
    }
}

