/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.vfw;

import com.sun.media.format.AviVideoFormat;
import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class BitMapInfo {
    public int biWidth = 0;
    public int biHeight = 0;
    public int biPlanes = 1;
    public int biBitCount = 24;
    public String fourcc = "";
    public int biSizeImage = 0;
    public int biXPelsPerMeter = 0;
    public int biYPelsPerMeter = 0;
    public int biClrUsed = 0;
    public int biClrImportant = 0;
    public int extraSize = 0;
    public byte[] extraBytes = null;
    static /* synthetic */ Class array$B;

    public BitMapInfo() {
    }

    public BitMapInfo(String string, int n2, int n3) {
        this.biWidth = n2;
        this.biHeight = n3;
        this.fourcc = string;
        if (string.equals("RGB")) {
            this.biSizeImage = n2 * n3 * 3;
        }
        if (string.equals("MSVC")) {
            this.fourcc = "CRAM";
        }
    }

    public BitMapInfo(String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(string, n2, n3);
        this.biPlanes = n4;
        this.biBitCount = n5;
        this.biSizeImage = n6;
        this.biClrUsed = n7;
        this.biClrImportant = n8;
    }

    public BitMapInfo(VideoFormat videoFormat) {
        Class clazz;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            dimension = new Dimension(320, 240);
        }
        int n2 = (clazz = videoFormat.getDataType()) == Format.byteArray ? 1 : (clazz == Format.intArray ? 4 : 2);
        this.biWidth = dimension.width;
        this.biHeight = dimension.height;
        this.biPlanes = 1;
        this.biSizeImage = videoFormat.getMaxDataLength() * n2;
        this.fourcc = videoFormat.getEncoding();
        if (this.fourcc.equalsIgnoreCase("msvc")) {
            this.fourcc = "CRAM";
        }
        if (videoFormat instanceof AviVideoFormat) {
            AviVideoFormat aviVideoFormat = (AviVideoFormat)videoFormat;
            this.biPlanes = aviVideoFormat.getPlanes();
            this.biBitCount = aviVideoFormat.getBitsPerPixel();
            this.biXPelsPerMeter = aviVideoFormat.getXPelsPerMeter();
            this.biYPelsPerMeter = aviVideoFormat.getYPelsPerMeter();
            this.biClrUsed = aviVideoFormat.getClrUsed();
            this.biClrImportant = aviVideoFormat.getClrImportant();
            this.extraBytes = aviVideoFormat.getCodecSpecificHeader();
            if (this.extraBytes != null) {
                this.extraSize = this.extraBytes.length;
            }
        } else if (videoFormat instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)videoFormat;
            this.fourcc = "RGB";
            this.biBitCount = rGBFormat.getBitsPerPixel();
            if (rGBFormat.getFlipped() == 0) {
                this.biHeight = -this.biHeight;
            }
        } else if (videoFormat instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)videoFormat;
            switch (yUVFormat.getYuvType()) {
                case 2: {
                    this.fourcc = yUVFormat.getOffsetU() < yUVFormat.getOffsetV() ? "I420" : "YV12";
                }
                case 32: {
                    if (yUVFormat.getOffsetY() == 0 && yUVFormat.getOffsetU() == 1) {
                        this.fourcc = "YUY2";
                        break;
                    }
                    if (yUVFormat.getOffsetY() == 0 && yUVFormat.getOffsetU() == 3) {
                        this.fourcc = "YVYU";
                        break;
                    }
                    if (yUVFormat.getOffsetU() != 0) break;
                    this.fourcc = "UYVY";
                }
            }
            if (this.fourcc.equalsIgnoreCase("yv12") || this.fourcc.equalsIgnoreCase("i420") || this.fourcc.equalsIgnoreCase("y411")) {
                this.biBitCount = 12;
            } else if (this.fourcc.equalsIgnoreCase("yuy2")) {
                this.biBitCount = 16;
            }
        }
    }

    public VideoFormat createVideoFormat(Class clazz) {
        return this.createVideoFormat(clazz, -1.0f);
    }

    public VideoFormat createVideoFormat(Class clazz, float f2) {
        VideoFormat videoFormat;
        if (this.fourcc.equalsIgnoreCase("rgb")) {
            int n2 = clazz == Format.byteArray ? 1 : (clazz == Format.intArray ? 4 : 2);
            int n3 = this.biSizeImage / n2;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            if (this.biBitCount == 16) {
                n4 = 31744;
                n5 = 992;
                n6 = 31;
            } else if (this.biBitCount == 32) {
                if (n2 == 4) {
                    n4 = 0xFF0000;
                    n5 = 65280;
                    n6 = 255;
                } else {
                    n4 = 3;
                    n5 = 2;
                    n6 = 1;
                }
            } else if (this.biBitCount == 24) {
                n4 = 3;
                n5 = 2;
                n6 = 1;
            }
            int n7 = this.biWidth * this.biBitCount / 8;
            int n8 = n7 / n2;
            int n9 = n8 / this.biWidth;
            int n10 = this.biHeight;
            int n11 = 1;
            if (this.biHeight < 0) {
                n10 = -n10;
                n11 = 0;
            }
            videoFormat = new RGBFormat(new Dimension(this.biWidth, n10), n3, clazz, f2, this.biBitCount, n4, n5, n6, n9, n8, n11, 1);
        } else if (this.fourcc.equalsIgnoreCase("yuy2")) {
            int n12 = this.biWidth * this.biHeight;
            videoFormat = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, f2, 32, this.biWidth * 2, this.biWidth * 2, 0, 1, 3);
        } else if (this.fourcc.equalsIgnoreCase("i420")) {
            int n13 = this.biWidth * this.biHeight;
            videoFormat = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, f2, 2, this.biWidth, this.biWidth / 2, 0, n13, n13 + n13 / 4);
        } else if (this.fourcc.equalsIgnoreCase("yv12")) {
            int n14 = this.biWidth * this.biHeight;
            videoFormat = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, f2, 2, this.biWidth, this.biWidth / 2, 0, n14 + n14 / 4, n14);
        } else {
            videoFormat = new AviVideoFormat(this.fourcc, new Dimension(this.biWidth, this.biHeight), this.biSizeImage, clazz, f2, this.biPlanes, this.biBitCount, this.biSizeImage, this.biXPelsPerMeter, this.biYPelsPerMeter, this.biClrUsed, this.biClrImportant, this.extraBytes);
        }
        return videoFormat;
    }

    public String toString() {
        String string = "Size = " + this.biWidth + " x " + this.biHeight + "\t" + "Planes = " + this.biPlanes + "\t" + "BitCount = " + this.biBitCount + "\t" + "FourCC = " + this.fourcc + "\t" + "SizeImage = " + this.biSizeImage + "\n" + "ClrUsed = " + this.biClrUsed + "\n" + "ClrImportant = " + this.biClrImportant + "\n" + "ExtraSize = " + this.extraSize + "\n";
        if (this.extraSize > 0) {
            int n2 = 0;
            while (n2 < this.extraSize) {
                string = string + "\t" + n2 + " = " + this.extraBytes[n2] + "\n";
                ++n2;
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

