/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import com.sun.media.Log;
import com.sun.media.util.Registry;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.CannotRealizeException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.DataSink;
import javax.media.DataSinkProxy;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MCA;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSinkException;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceCloneable;

public final class Manager {
    private static String VERSION = "2.1.1";
    public static final int MAX_SECURITY = 1;
    public static final int CACHING = 2;
    public static final int LIGHTWEIGHT_RENDERER = 3;
    public static final int PLUGIN_PLAYER = 4;
    private static int numberOfHints = 4;
    private static SystemTimeBase sysTimeBase = null;
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    private static String fileSeparator;
    private static Hashtable hintTable;
    static final int DONE = 0;
    static final int SUCCESS = 1;
    static /* synthetic */ Class class$javax$media$protocol$PullDataSource;
    static /* synthetic */ Class class$javax$media$protocol$PushDataSource;
    static /* synthetic */ Class class$javax$media$protocol$PullBufferDataSource;
    static /* synthetic */ Class class$javax$media$protocol$PushBufferDataSource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Thread;

    private Manager() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static Player createPlayer(URL uRL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(uRL));
    }

    public static Player createPlayer(MediaLocator mediaLocator) throws IOException, NoPlayerException {
        Player player = null;
        Hashtable hashtable = new Hashtable(10);
        boolean bl = (Boolean)Manager.getHint(4);
        String string = mediaLocator.getProtocol();
        if (string != null && (string.equalsIgnoreCase("rtp") || string.equalsIgnoreCase("rtsp"))) {
            bl = false;
        }
        try {
            player = Manager.createPlayerForContent(mediaLocator, bl, hashtable);
        }
        catch (NoPlayerException noPlayerException) {
            if (bl) {
                throw noPlayerException;
            }
            player = Manager.createPlayerForContent(mediaLocator, true, hashtable);
        }
        if (hashtable.size() != 0) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                DataSource dataSource = (DataSource)enumeration.nextElement();
                dataSource.disconnect();
            }
        }
        return player;
    }

    public static Player createPlayer(DataSource dataSource) throws IOException, NoPlayerException {
        Player player;
        boolean bl = (Boolean)Manager.getHint(4);
        String string = dataSource.getContentType();
        if (string != null && (string.equalsIgnoreCase("rtp") || string.equalsIgnoreCase("rtsp"))) {
            bl = false;
        }
        try {
            if (bl) {
                string = UNKNOWN_CONTENT_NAME;
            }
            player = Manager.createPlayerForSource(dataSource, string, null);
        }
        catch (NoPlayerException noPlayerException) {
            if (bl) {
                throw noPlayerException;
            }
            player = Manager.createPlayerForSource(dataSource, UNKNOWN_CONTENT_NAME, null);
        }
        return player;
    }

    public static Player createRealizedPlayer(URL uRL) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(uRL);
        Manager.blockingCall(player, 300);
        return player;
    }

    public static Player createRealizedPlayer(MediaLocator mediaLocator) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(mediaLocator);
        Manager.blockingCall(player, 300);
        return player;
    }

    public static Player createRealizedPlayer(DataSource dataSource) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(dataSource);
        Manager.blockingCall(player, 300);
        return player;
    }

    public static Processor createProcessor(URL uRL) throws IOException, NoProcessorException {
        return Manager.createProcessor(new MediaLocator(uRL));
    }

    public static Processor createProcessor(MediaLocator mediaLocator) throws IOException, NoProcessorException {
        Processor processor = null;
        Hashtable hashtable = new Hashtable(10);
        try {
            processor = Manager.createProcessorForContent(mediaLocator, false, hashtable);
        }
        catch (NoProcessorException noProcessorException) {
            processor = Manager.createProcessorForContent(mediaLocator, true, hashtable);
        }
        if (hashtable.size() != 0) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                DataSource dataSource = (DataSource)enumeration.nextElement();
                dataSource.disconnect();
            }
        }
        return processor;
    }

    public static Processor createProcessor(DataSource dataSource) throws IOException, NoProcessorException {
        Processor processor;
        try {
            processor = Manager.createProcessorForSource(dataSource, dataSource.getContentType(), null);
        }
        catch (NoProcessorException noProcessorException) {
            processor = Manager.createProcessorForSource(dataSource, UNKNOWN_CONTENT_NAME, null);
        }
        return processor;
    }

    public static Processor createRealizedProcessor(ProcessorModel processorModel) throws IOException, NoProcessorException, CannotRealizeException {
        int n2;
        Object object;
        int n3;
        int n4;
        DataSource dataSource = null;
        MediaLocator mediaLocator = null;
        Processor processor = null;
        boolean bl = false;
        Format[] formatArray = null;
        int n5 = -1;
        int n6 = 0;
        if (processorModel == null) {
            throw new NoProcessorException("null ProcessorModel");
        }
        dataSource = processorModel.getInputDataSource();
        if (dataSource != null) {
            processor = Manager.createProcessor(dataSource);
        } else {
            mediaLocator = processorModel.getInputLocator();
            if (mediaLocator != null) {
                processor = Manager.createProcessor(mediaLocator);
            } else {
                n4 = Manager.getNTypesOfCaptureDevices();
                Vector<DataSource> vector = new Vector<DataSource>(1);
                n5 = processorModel.getTrackCount(n4);
                formatArray = new Format[n5];
                n3 = 0;
                while (n3 < n5) {
                    CaptureDeviceInfo captureDeviceInfo;
                    formatArray[n3] = processorModel.getOutputTrackFormat(n3);
                    object = CaptureDeviceManager.getDeviceList(formatArray[n3]);
                    if (object == null || ((Vector)object).size() == 0) {
                        if (formatArray[n3] instanceof AudioFormat) {
                            object = CaptureDeviceManager.getDeviceList(new AudioFormat(null));
                        } else if (formatArray[n3] instanceof VideoFormat) {
                            object = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
                        }
                    }
                    if (((Vector)object).size() != 0 && (captureDeviceInfo = (CaptureDeviceInfo)((Vector)object).elementAt(0)) != null && captureDeviceInfo.getLocator() != null) {
                        try {
                            Format[] formatArray2;
                            FormatControl[] formatControlArray;
                            DataSource dataSource2 = Manager.createDataSource(captureDeviceInfo.getLocator());
                            if (dataSource2 instanceof CaptureDevice && (formatControlArray = ((CaptureDevice)((Object)dataSource2)).getFormatControls()).length > 0 && (formatArray2 = formatControlArray[0].getSupportedFormats()).length > 0) {
                                int n7 = 0;
                                while (n7 < formatArray2.length) {
                                    Format format;
                                    if (formatArray2[n7].matches(formatArray[n3]) && (format = formatArray2[n7].intersects(formatArray[n3])) != null && formatControlArray[0].setFormat(format) != null) break;
                                    ++n7;
                                }
                            }
                            vector.addElement(dataSource2);
                        }
                        catch (IOException iOException) {
                        }
                        catch (NoDataSourceException noDataSourceException) {
                            // empty catch block
                        }
                    }
                    ++n3;
                }
                if (vector.size() == 0) {
                    throw new NoProcessorException("No suitable capture devices found!");
                }
                if (vector.size() > 1) {
                    object = new DataSource[vector.size()];
                    n2 = 0;
                    while (n2 < vector.size()) {
                        object[n2] = (DataSource)vector.elementAt(n2);
                        ++n2;
                    }
                    try {
                        dataSource = Manager.createMergingDataSource((DataSource[])object);
                    }
                    catch (IncompatibleSourceException incompatibleSourceException) {
                        throw new NoProcessorException("Couldn't merge capture devices");
                    }
                } else {
                    dataSource = (DataSource)vector.elementAt(0);
                }
                processor = Manager.createProcessor(dataSource);
            }
        }
        if (processor == null) {
            throw new NoProcessorException("Couldn't create Processor for source");
        }
        Manager.blockingCall(processor, 180);
        ContentDescriptor contentDescriptor = processorModel.getContentDescriptor();
        if (contentDescriptor == null) {
            processor.setContentDescriptor(null);
        } else {
            ContentDescriptor[] contentDescriptorArray = processor.getSupportedContentDescriptors();
            if (contentDescriptorArray == null || contentDescriptorArray.length == 0) {
                throw new NoProcessorException("Processor doesn't support output");
            }
            n3 = 0;
            while (n3 < contentDescriptorArray.length) {
                if (contentDescriptor.matches(contentDescriptorArray[n3]) && processor.setContentDescriptor(contentDescriptorArray[n3]) != null) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new NoProcessorException("Processor doesn't support requested output ContentDescriptor");
            }
        }
        TrackControl[] trackControlArray = processor.getTrackControls();
        if (trackControlArray != null && trackControlArray.length > 0) {
            n4 = 0;
            n3 = 0;
            while (n3 < trackControlArray.length) {
                if (trackControlArray[n3].isEnabled()) {
                    ++n4;
                }
                ++n3;
            }
            if (n5 == -1) {
                n5 = processorModel.getTrackCount(n4);
            }
            if (n5 > 0) {
                int n8;
                Object object2;
                if (formatArray == null) {
                    formatArray = new Format[n5];
                }
                int[] nArray = new int[n5];
                n3 = 0;
                while (n3 < n5) {
                    if (formatArray[n3] == null) {
                        formatArray[n3] = processorModel.getOutputTrackFormat(n3);
                    }
                    nArray[n3] = -1;
                    ++n3;
                }
                boolean[] blArray = new boolean[trackControlArray.length];
                n3 = 0;
                while (n3 < trackControlArray.length) {
                    blArray[n3] = false;
                    if (trackControlArray[n3].isEnabled()) {
                        object2 = trackControlArray[n3].getFormat();
                        n8 = 0;
                        while (n8 < n5) {
                            if (nArray[n8] == -1 && (formatArray[n8] == null || ((Format)object2).matches(formatArray[n8])) && processorModel.isFormatAcceptable(n8, (Format)object2)) {
                                nArray[n8] = n3;
                                blArray[n3] = true;
                                ++n6;
                                break;
                            }
                            ++n8;
                        }
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < trackControlArray.length && n6 < n5) {
                    boolean bl2 = false;
                    if (trackControlArray[n3].isEnabled()) {
                        n8 = 0;
                        while (n8 < n5) {
                            if (nArray[n8] == n3) {
                                bl2 = true;
                            }
                            ++n8;
                        }
                        if (!bl2 && (object = trackControlArray[n3].getSupportedFormats()) != null && ((Object)object).length != 0) {
                            bl = false;
                            n2 = 0;
                            while (n2 < ((Object)object).length && !bl) {
                                object2 = object[n2];
                                n8 = 0;
                                while (n8 < n5 && !bl) {
                                    if (nArray[n8] == -1 && (formatArray[n8] == null || ((Format)object2).matches(formatArray[n8])) && processorModel.isFormatAcceptable(n8, (Format)object2) && trackControlArray[n3].setFormat((Format)object2) != null) {
                                        nArray[n8] = n3;
                                        blArray[n3] = true;
                                        ++n6;
                                        bl = true;
                                        break;
                                    }
                                    ++n8;
                                }
                                ++n2;
                            }
                        }
                    }
                    ++n3;
                }
                if (n6 < n5) {
                    throw new CannotRealizeException("Unable to provide all requested tracks");
                }
            }
        }
        Manager.blockingCall(processor, 300);
        return processor;
    }

    public static DataSource createDataSource(URL uRL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(uRL));
    }

    public static DataSource createDataSource(MediaLocator mediaLocator) throws IOException, NoDataSourceException {
        DataSource dataSource = null;
        Enumeration enumeration = Manager.getDataSourceList(mediaLocator.getProtocol()).elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                Class clazz = Manager.getClassForName(string);
                dataSource = (DataSource)clazz.newInstance();
                dataSource.setLocator(mediaLocator);
                dataSource.connect();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataSource = null;
            }
            catch (InstantiationException instantiationException) {
                dataSource = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                dataSource = null;
            }
            catch (Exception exception) {
                dataSource = null;
                String string2 = "Error instantiating class: " + string + " : " + exception;
                Log.error(exception);
                throw new NoDataSourceException(string2);
            }
            catch (Error error) {
                dataSource = null;
                String string3 = "Error instantiating class: " + string + " : " + error;
                Log.error(error);
                throw new NoDataSourceException(string3);
            }
        }
        if (dataSource == null) {
            throw new NoDataSourceException("Cannot find a DataSource for: " + mediaLocator);
        }
        Log.comment("DataSource created: " + dataSource + "\n");
        return dataSource;
    }

    public static DataSource createMergingDataSource(DataSource[] dataSourceArray) throws IncompatibleSourceException {
        if (dataSourceArray.length == 0) {
            throw new IncompatibleSourceException("No sources");
        }
        if (dataSourceArray[0] instanceof PullDataSource) {
            int n2 = 1;
            while (n2 < dataSourceArray.length) {
                if (!(dataSourceArray[n2] instanceof PullDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++n2;
            }
            PullDataSource[] pullDataSourceArray = new PullDataSource[dataSourceArray.length];
            int n3 = 0;
            while (n3 < pullDataSourceArray.length) {
                pullDataSourceArray[n3] = (PullDataSource)dataSourceArray[n3];
                ++n3;
            }
            return Manager.reflectMDS("com.ibm.media.protocol.MergingPullDataSource", pullDataSourceArray);
        }
        if (dataSourceArray[0] instanceof PushDataSource) {
            int n4 = 1;
            while (n4 < dataSourceArray.length) {
                if (!(dataSourceArray[n4] instanceof PushDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++n4;
            }
            PushDataSource[] pushDataSourceArray = new PushDataSource[dataSourceArray.length];
            int n5 = 0;
            while (n5 < pushDataSourceArray.length) {
                pushDataSourceArray[n5] = (PushDataSource)dataSourceArray[n5];
                ++n5;
            }
            return Manager.reflectMDS("com.ibm.media.protocol.MergingPushDataSource", pushDataSourceArray);
        }
        if (dataSourceArray[0] instanceof PullBufferDataSource) {
            int n6 = 1;
            while (n6 < dataSourceArray.length) {
                if (!(dataSourceArray[n6] instanceof PullBufferDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++n6;
            }
            PullBufferDataSource[] pullBufferDataSourceArray = new PullBufferDataSource[dataSourceArray.length];
            int n7 = 0;
            while (n7 < pullBufferDataSourceArray.length) {
                pullBufferDataSourceArray[n7] = (PullBufferDataSource)dataSourceArray[n7];
                ++n7;
            }
            return Manager.reflectMDS("com.ibm.media.protocol.MergingPullBufferDataSource", pullBufferDataSourceArray);
        }
        if (dataSourceArray[0] instanceof PushBufferDataSource) {
            boolean bl = false;
            int n8 = 1;
            while (n8 < dataSourceArray.length) {
                if (!(dataSourceArray[n8] instanceof PushBufferDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                if (dataSourceArray[n8] instanceof CaptureDevice) {
                    bl = true;
                }
                ++n8;
            }
            PushBufferDataSource[] pushBufferDataSourceArray = new PushBufferDataSource[dataSourceArray.length];
            int n9 = 0;
            while (n9 < pushBufferDataSourceArray.length) {
                pushBufferDataSourceArray[n9] = (PushBufferDataSource)dataSourceArray[n9];
                ++n9;
            }
            if (bl) {
                return Manager.reflectMDS("com.ibm.media.protocol.MergingCDPushBDS", pushBufferDataSourceArray);
            }
            return Manager.reflectMDS("com.ibm.media.protocol.MergingPushBufferDataSource", pushBufferDataSourceArray);
        }
        return null;
    }

    private static DataSource reflectMDS(String string, Object object) {
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        try {
            Class<?> clazz = Class.forName(string);
            classArray[0] = object.getClass();
            Constructor<?> constructor = clazz.getConstructor(classArray);
            if (string.indexOf("PullDataSource") >= 0) {
                objectArray[0] = (PullDataSource[])object;
            } else if (string.indexOf("PushDataSource") >= 0) {
                objectArray[0] = (PushDataSource[])object;
            } else if (string.indexOf("PullBufferDataSource") >= 0) {
                objectArray[0] = (PullBufferDataSource[])object;
            } else if (string.indexOf("PushBufferDataSource") >= 0) {
                objectArray[0] = (PushBufferDataSource[])object;
            } else if (string.indexOf("CDPushBDS") >= 0) {
                objectArray[0] = (PushBufferDataSource[])object;
            }
            return (DataSource)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataSource reflectDS(String string, DataSource dataSource) {
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        try {
            Class<?> clazz = Class.forName(string);
            if (string.indexOf("PullDataSource") >= 0) {
                classArray[0] = class$javax$media$protocol$PullDataSource == null ? (class$javax$media$protocol$PullDataSource = Manager.class$("javax.media.protocol.PullDataSource")) : class$javax$media$protocol$PullDataSource;
                objectArray[0] = (PullDataSource)dataSource;
            } else if (string.indexOf("PushDataSource") >= 0) {
                classArray[0] = class$javax$media$protocol$PushDataSource == null ? (class$javax$media$protocol$PushDataSource = Manager.class$("javax.media.protocol.PushDataSource")) : class$javax$media$protocol$PushDataSource;
                objectArray[0] = (PushDataSource)dataSource;
            } else if (string.indexOf("PullBufferDataSource") >= 0) {
                classArray[0] = class$javax$media$protocol$PullBufferDataSource == null ? (class$javax$media$protocol$PullBufferDataSource = Manager.class$("javax.media.protocol.PullBufferDataSource")) : class$javax$media$protocol$PullBufferDataSource;
                objectArray[0] = (PullBufferDataSource)dataSource;
            } else if (string.indexOf("PushBufferDataSource") >= 0) {
                classArray[0] = class$javax$media$protocol$PushBufferDataSource == null ? (class$javax$media$protocol$PushBufferDataSource = Manager.class$("javax.media.protocol.PushBufferDataSource")) : class$javax$media$protocol$PushBufferDataSource;
                objectArray[0] = (PushBufferDataSource)dataSource;
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (DataSource)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DataSource createCloneableDataSource(DataSource dataSource) {
        if (dataSource instanceof SourceCloneable) {
            return dataSource;
        }
        if (dataSource instanceof CaptureDevice) {
            if (dataSource instanceof PullDataSource) {
                return Manager.reflectDS("com.ibm.media.protocol.CloneableCapturePullDataSource", dataSource);
            }
            if (dataSource instanceof PushDataSource) {
                return Manager.reflectDS("com.ibm.media.protocol.CloneableCapturePushDataSource", dataSource);
            }
            if (dataSource instanceof PullBufferDataSource) {
                return Manager.reflectDS("com.ibm.media.protocol.CloneableCapturePullBufferDataSource", dataSource);
            }
            if (dataSource instanceof PushBufferDataSource) {
                return Manager.reflectDS("com.ibm.media.protocol.CloneableCapturePushBufferDataSource", dataSource);
            }
        }
        if (dataSource instanceof PullDataSource) {
            return Manager.reflectDS("com.ibm.media.protocol.CloneablePullDataSource", dataSource);
        }
        if (dataSource instanceof PushDataSource) {
            return Manager.reflectDS("com.ibm.media.protocol.CloneablePushDataSource", dataSource);
        }
        if (dataSource instanceof PullBufferDataSource) {
            return Manager.reflectDS("com.ibm.media.protocol.CloneablePullBufferDataSource", dataSource);
        }
        if (dataSource instanceof PushBufferDataSource) {
            return Manager.reflectDS("com.ibm.media.protocol.CloneablePushBufferDataSource", dataSource);
        }
        return null;
    }

    public static TimeBase getSystemTimeBase() {
        if (sysTimeBase == null) {
            sysTimeBase = new SystemTimeBase();
        }
        return sysTimeBase;
    }

    static Player createPlayerForContent(MediaLocator mediaLocator, boolean bl, Hashtable hashtable) throws IOException, NoPlayerException {
        Player player = null;
        boolean[] blArray = new boolean[]{false};
        Enumeration enumeration = Manager.getDataSourceList(mediaLocator.getProtocol()).elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DataSource dataSource = null;
            try {
                dataSource = (DataSource)hashtable.get(string);
                if (dataSource == null) {
                    Class clazz = Manager.getClassForName(string);
                    dataSource = (DataSource)clazz.newInstance();
                    dataSource.setLocator(mediaLocator);
                    dataSource.connect();
                } else {
                    hashtable.remove(string);
                }
                try {
                    if (bl) {
                        player = Manager.createPlayerForSource(dataSource, UNKNOWN_CONTENT_NAME, blArray);
                        break;
                    }
                    player = Manager.createPlayerForSource(dataSource, dataSource.getContentType(), blArray);
                    break;
                }
                catch (NoPlayerException noPlayerException) {
                    player = null;
                    if (blArray[0]) {
                        dataSource.disconnect();
                        continue;
                    }
                    hashtable.put(string, dataSource);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataSource = null;
            }
            catch (InstantiationException instantiationException) {
                dataSource = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                dataSource = null;
            }
            catch (Exception exception) {
                dataSource = null;
                String string2 = "Error instantiating class: " + string + " : " + exception;
                Log.error(exception);
                throw new NoPlayerException(string2);
            }
            catch (Error error) {
                dataSource = null;
                String string3 = "Error instantiating class: " + string + " : " + error;
                Log.error(error);
                throw new NoPlayerException(string3);
            }
        }
        if (player == null) {
            throw new NoPlayerException("Cannot find a Player for :" + mediaLocator);
        }
        return player;
    }

    static Player createPlayerForSource(DataSource dataSource, String string, boolean[] blArray) throws IOException, NoPlayerException {
        Player player = null;
        if (blArray != null) {
            blArray[0] = true;
        }
        Enumeration enumeration = Manager.getHandlerClassList(string).elements();
        DataSource dataSource2 = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            try {
                Class clazz = Manager.getClassForName(string2);
                MediaHandler mediaHandler = (MediaHandler)clazz.newInstance();
                mediaHandler.setSource(dataSource);
                if (mediaHandler instanceof Player) {
                    player = (Player)mediaHandler;
                    break;
                }
                MediaProxy mediaProxy = (MediaProxy)mediaHandler;
                dataSource2 = mediaProxy.getDataSource();
                String string3 = dataSource2.getContentType();
                try {
                    player = Manager.createPlayerForSource(dataSource2, string3, null);
                }
                catch (NoPlayerException noPlayerException) {
                    player = Manager.createPlayerForSource(dataSource2, UNKNOWN_CONTENT_NAME, null);
                    if (player == null) continue;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                player = null;
                if (blArray == null) continue;
                blArray[0] = false;
            }
            catch (InstantiationException instantiationException) {
                player = null;
                if (blArray == null) continue;
                blArray[0] = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                player = null;
                if (blArray == null) continue;
                blArray[0] = false;
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                player = null;
            }
            catch (NoDataSourceException noDataSourceException) {
                player = null;
            }
            catch (Exception exception) {
                player = null;
                String string4 = "Error instantiating class: " + string2 + " : " + exception;
                throw new NoPlayerException(string4);
            }
            catch (Error error) {
                String string5 = "Error instantiating class: " + string2 + " : " + error;
                Log.error(error);
                throw new NoPlayerException(string5);
            }
        }
        if (player == null) {
            throw new NoPlayerException("Cannot find a Player for: " + dataSource);
        }
        Log.comment("Player created: " + player);
        Log.comment("  using DataSource: " + dataSource + "\n");
        return player;
    }

    static Processor createProcessorForContent(MediaLocator mediaLocator, boolean bl, Hashtable hashtable) throws IOException, NoProcessorException {
        Processor processor = null;
        boolean[] blArray = new boolean[]{false};
        Enumeration enumeration = Manager.getDataSourceList(mediaLocator.getProtocol()).elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DataSource dataSource = null;
            try {
                dataSource = (DataSource)hashtable.get(string);
                if (dataSource == null) {
                    Class clazz = Manager.getClassForName(string);
                    dataSource = (DataSource)clazz.newInstance();
                    dataSource.setLocator(mediaLocator);
                    dataSource.connect();
                } else {
                    hashtable.remove(string);
                }
                try {
                    if (bl) {
                        processor = Manager.createProcessorForSource(dataSource, UNKNOWN_CONTENT_NAME, blArray);
                        break;
                    }
                    processor = Manager.createProcessorForSource(dataSource, dataSource.getContentType(), blArray);
                    break;
                }
                catch (NoProcessorException noProcessorException) {
                    processor = null;
                    if (blArray[0]) {
                        dataSource.disconnect();
                        continue;
                    }
                    hashtable.put(string, dataSource);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataSource = null;
            }
            catch (InstantiationException instantiationException) {
                dataSource = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                dataSource = null;
            }
            catch (Exception exception) {
                String string2 = "Error instantiating class: " + string + " : " + exception;
                Log.error(exception);
                throw new NoProcessorException(string2);
            }
            catch (Error error) {
                String string3 = "Error instantiating class: " + string + " : " + error;
                Log.error(error);
                throw new NoProcessorException(string3);
            }
        }
        if (processor == null) {
            throw new NoProcessorException("Cannot find a Processor for: " + mediaLocator);
        }
        return processor;
    }

    static Processor createProcessorForSource(DataSource dataSource, String string, boolean[] blArray) throws IOException, NoProcessorException {
        Processor processor = null;
        if (blArray != null) {
            blArray[0] = true;
        }
        Enumeration enumeration = Manager.getProcessorClassList(string).elements();
        DataSource dataSource2 = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            try {
                Class clazz = Manager.getClassForName(string2);
                MediaHandler mediaHandler = (MediaHandler)clazz.newInstance();
                mediaHandler.setSource(dataSource);
                if (mediaHandler instanceof Processor) {
                    processor = (Processor)mediaHandler;
                    break;
                }
                MediaProxy mediaProxy = (MediaProxy)mediaHandler;
                dataSource2 = mediaProxy.getDataSource();
                String string3 = dataSource2.getContentType();
                try {
                    processor = Manager.createProcessorForSource(dataSource2, string3, null);
                }
                catch (NoProcessorException noProcessorException) {
                    processor = Manager.createProcessorForSource(dataSource2, UNKNOWN_CONTENT_NAME, null);
                    if (processor == null) continue;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                processor = null;
                if (blArray == null) continue;
                blArray[0] = false;
            }
            catch (InstantiationException instantiationException) {
                processor = null;
                if (blArray == null) continue;
                blArray[0] = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                processor = null;
                if (blArray == null) continue;
                blArray[0] = false;
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                processor = null;
            }
            catch (NoDataSourceException noDataSourceException) {
                processor = null;
            }
            catch (Exception exception) {
                processor = null;
                String string4 = "Error instantiating class: " + string2 + " : " + exception;
                Log.error(exception);
                throw new NoProcessorException(string4);
            }
            catch (Error error) {
                processor = null;
                String string5 = "Error instantiating class: " + string2 + " : " + error;
                Log.error(error);
                throw new NoProcessorException(string5);
            }
        }
        if (processor == null) {
            throw new NoProcessorException("Cannot find a Processor for: " + dataSource);
        }
        Log.comment("Processor created: " + processor);
        Log.comment("  using DataSource: " + dataSource + "\n");
        return processor;
    }

    public static DataSink createDataSink(DataSource dataSource, MediaLocator mediaLocator) throws NoDataSinkException {
        String string = "media.datasink." + mediaLocator.getProtocol() + ".Handler";
        Vector vector = Manager.buildClassList(Manager.getContentPrefixList(), string);
        Enumeration enumeration = vector.elements();
        DataSink dataSink = null;
        boolean bl = false;
        block5: while (!bl && enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            try {
                Class clazz = Manager.getClassForName(string2);
                Object t = clazz.newInstance();
                if (t instanceof DataSink) {
                    dataSink = (DataSink)t;
                    dataSink.setSource(dataSource);
                    dataSink.setOutputLocator(mediaLocator);
                    bl = true;
                    break;
                }
                DataSinkProxy dataSinkProxy = (DataSinkProxy)t;
                String string3 = dataSinkProxy.getContentType(mediaLocator);
                string = "media.datasink." + mediaLocator.getProtocol() + "." + string3 + ".Handler";
                Vector vector2 = Manager.buildClassList(Manager.getContentPrefixList(), string);
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    String string4 = (String)enumeration2.nextElement();
                    try {
                        dataSink = (DataSink)Manager.getClassForName(string4).newInstance();
                        dataSink.setSource(dataSource);
                        dataSink.setOutputLocator(mediaLocator);
                        bl = true;
                        continue block5;
                    }
                    catch (Exception exception) {
                        dataSink = null;
                    }
                }
            }
            catch (Exception exception) {
                dataSink = null;
            }
            catch (Error error) {
                dataSink = null;
            }
        }
        if (dataSink == null) {
            throw new NoDataSinkException("Cannot find a DataSink for: " + dataSource);
        }
        Log.comment("DataSink created: " + dataSink);
        Log.comment("  using DataSource: " + dataSource + "\n");
        return dataSink;
    }

    public static String getCacheDirectory() {
        Object object = Registry.get("secure.cacheDir");
        if (object != null && object instanceof String) {
            String string = (String)object;
            if (string.indexOf(fileSeparator) == -1) {
                string = fileSeparator.equals("/") ? "/tmp" : (fileSeparator.equals("\\") ? "C:" + fileSeparator + "temp" : null);
            }
            return string;
        }
        String string = fileSeparator.equals("/") ? "/tmp" : (fileSeparator.equals("\\") ? "C:" + fileSeparator + "temp" : null);
        return string;
    }

    public static void setHint(int n2, Object object) {
        if (object != null && n2 >= 1 && n2 <= numberOfHints) {
            hintTable.put(new Integer(n2), object);
        }
    }

    public static Object getHint(int n2) {
        if (n2 >= 1 && n2 <= numberOfHints) {
            return hintTable.get(new Integer(n2));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void blockingCall(Player player, int n2) throws CannotRealizeException {
        boolean[] blArray = new boolean[]{false, false};
        MCA mCA = new MCA(blArray, n2);
        player.addControllerListener(mCA);
        if (n2 == 300) {
            player.realize();
        } else if (n2 == 180) {
            ((Processor)player).configure();
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray2) {
            while (!blArray[0]) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        player.removeControllerListener(mCA);
        if (!blArray[1]) {
            throw new CannotRealizeException();
        }
    }

    public static Vector getDataSourceList(String string) {
        String string2 = "media.protocol." + string + ".DataSource";
        return Manager.buildClassList(Manager.getProtocolPrefixList(), string2);
    }

    public static Vector getHandlerClassList(String string) {
        String string2 = "media.content." + ContentDescriptor.mimeTypeToPackageName(string) + ".Handler";
        return Manager.buildClassList(Manager.getContentPrefixList(), string2);
    }

    public static Vector getProcessorClassList(String string) {
        String string2 = "media.processor." + ContentDescriptor.mimeTypeToPackageName(string) + ".Handler";
        return Manager.buildClassList(Manager.getContentPrefixList(), string2);
    }

    static Vector buildClassList(Vector vector, String string) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector2.addElement(string2 + "." + string);
        }
        return vector2;
    }

    static Vector getContentPrefixList() {
        return (Vector)PackageManager.getContentPrefixList().clone();
    }

    static Vector getProtocolPrefixList() {
        return (Vector)PackageManager.getProtocolPrefixList().clone();
    }

    private static int getNTypesOfCaptureDevices() {
        int n2 = 0;
        Vector vector = CaptureDeviceManager.getDeviceList(new AudioFormat(null));
        Vector vector2 = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
        if (vector != null && vector.size() > 0) {
            ++n2;
        }
        if (vector2 != null && vector2.size() > 0) {
            ++n2;
        }
        return n2;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = Manager.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = Manager.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Manager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Manager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Manager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = Manager.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static Class getClassForName(String string) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (!Manager.checkIfJDK12()) {
                    throw new ClassNotFoundException(exception.getMessage());
                }
            }
            catch (Error error) {
                if (Manager.checkIfJDK12()) break block9;
                throw error;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = Manager.class$("java.lang.Class")) : class$java$lang$Class), string, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = Manager.class$("java.lang.Class")) : class$java$lang$Class), string, new Boolean(true), classLoader);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.getMessage());
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fileSeparator = System.getProperty("file.separator");
        hintTable = new Hashtable();
        hintTable.put(new Integer(1), new Boolean(false));
        hintTable.put(new Integer(2), new Boolean(true));
        hintTable.put(new Integer(3), new Boolean(false));
        hintTable.put(new Integer(4), new Boolean(false));
    }
}

