/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.format.FormatChangeEvent;
import javax.media.protocol.DataSource;
import jmapps.ui.ImageArea;
import jmapps.ui.JMFrame;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.VideoPanel;
import jmapps.util.JMFUtils;

public class PlayerFrame
extends JMFrame
implements ActionListener,
ContainerListener,
ControllerListener {
    protected MediaPlayer mediaPlayerCurrent = null;
    protected JMPanel panelContent;
    protected Component compControl = null;
    protected VideoPanel panelVideo = null;
    protected ImageArea areaImagePlaceholder = null;
    protected Component progressBarCache = null;
    protected Cursor cursorNormal = new Cursor(0);
    protected Cursor cursorWait = new Cursor(3);
    protected boolean boolErrorClose = false;
    protected boolean boolMediaClosed = true;

    public PlayerFrame(Frame frame, String string) {
        super(frame, string);
    }

    protected void initFrame() {
        super.initFrame();
        this.setLayout(new BorderLayout());
        this.panelContent = new JMPanel(new BorderLayout());
        this.add((Component)this.panelContent, "Center");
        this.panelContent.addContainerListener(this);
        this.setPlaceholder();
    }

    public void open(String string) {
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(string, this, null, null);
        boolean bl = this.open(mediaPlayer);
    }

    public void open(DataSource dataSource) {
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(dataSource, (Frame)this);
        boolean bl = this.open(mediaPlayer);
    }

    public boolean open(MediaPlayer mediaPlayer) {
        if (mediaPlayer == null) {
            return false;
        }
        this.killCurrentPlayer();
        this.setCursor(this.cursorWait);
        this.mediaPlayerCurrent = mediaPlayer;
        mediaPlayer.setPopupActive(false);
        mediaPlayer.setControlPanelVisible(false);
        mediaPlayer.addControllerListener(this);
        mediaPlayer.realize();
        return true;
    }

    public void setPlaceholder() {
        Image image;
        if (this.areaImagePlaceholder == null && (image = ImageArea.loadImage("playerPlaceholder.gif", this, true)) != null) {
            this.areaImagePlaceholder = new ImageArea(image);
            this.areaImagePlaceholder.setInsets(0, 0, 0, 0);
        }
        if (this.areaImagePlaceholder != null) {
            this.panelContent.removeAll();
            this.panelContent.add((Component)this.areaImagePlaceholder, "Center");
        }
    }

    protected void killCurrentView() {
        this.panelVideo = null;
        this.compControl = null;
        int n2 = this.panelContent.getComponentCount();
        while (n2 > 0) {
            Component component;
            if ((component = this.panelContent.getComponent(--n2)) == this.areaImagePlaceholder) continue;
            this.panelContent.remove(component);
        }
    }

    protected void killCurrentPlayer() {
        this.killCurrentView();
        if (this.mediaPlayerCurrent != null) {
            this.boolMediaClosed = false;
            this.mediaPlayerCurrent.close();
            if (!this.boolErrorClose) {
                while (!this.boolMediaClosed) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.mediaPlayerCurrent.removeControllerListener(this);
            this.mediaPlayerCurrent = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string == null && object instanceof MenuItem) {
            string = ((MenuItem)object).getActionCommand();
        }
        if (string == null) {
            return;
        }
        if (string.equals(VideoPanel.MENU_ZOOM_1_2)) {
            this.pack();
        } else if (string.equals(VideoPanel.MENU_ZOOM_1_1)) {
            this.pack();
        } else if (string.equals(VideoPanel.MENU_ZOOM_2_1)) {
            this.pack();
        } else if (string.equals(VideoPanel.MENU_ZOOM_4_1)) {
            this.pack();
        }
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            this.processRealizeComplete((RealizeCompleteEvent)controllerEvent);
        } else if (controllerEvent instanceof PrefetchCompleteEvent) {
            this.processPrefetchComplete((PrefetchCompleteEvent)controllerEvent);
        } else if (controllerEvent instanceof ControllerErrorEvent) {
            this.processControllerError((ControllerErrorEvent)controllerEvent);
        } else if (controllerEvent instanceof ControllerClosedEvent) {
            this.processControllerClosed((ControllerClosedEvent)controllerEvent);
        } else if (controllerEvent instanceof DurationUpdateEvent) {
            Time time = ((DurationUpdateEvent)controllerEvent).getDuration();
        } else if (controllerEvent instanceof CachingControlEvent) {
            this.processCachingControl((CachingControlEvent)controllerEvent);
        } else if (!(controllerEvent instanceof StartEvent || controllerEvent instanceof MediaTimeSetEvent || controllerEvent instanceof TransitionEvent || controllerEvent instanceof RateChangeEvent || controllerEvent instanceof StopTimeChangeEvent)) {
            if (controllerEvent instanceof FormatChangeEvent) {
                this.processFormatChange((FormatChangeEvent)controllerEvent);
            } else if (!(controllerEvent instanceof SizeChangeEvent) && controllerEvent.getClass().getName().endsWith("ReplaceURLEvent")) {
                this.processReplaceURL(controllerEvent);
            }
        }
    }

    protected void processRealizeComplete(RealizeCompleteEvent realizeCompleteEvent) {
        this.killCurrentView();
        this.setCursor(this.cursorNormal);
        this.panelVideo = new VideoPanel(this.mediaPlayerCurrent);
        this.panelVideo.setZoom(1.0);
        this.panelVideo.addMenuZoomActionListener(this);
        this.panelContent.add((Component)this.panelVideo, "Center");
        this.compControl = this.mediaPlayerCurrent.getControlPanelComponent();
        if (this.compControl != null) {
            this.panelContent.add(this.compControl, "South");
        }
        this.mediaPlayerCurrent.prefetch();
    }

    protected void processPrefetchComplete(PrefetchCompleteEvent prefetchCompleteEvent) {
        this.mediaPlayerCurrent.start();
    }

    protected void processControllerError(ControllerErrorEvent controllerErrorEvent) {
        this.setCursor(this.cursorNormal);
        String string = JMFI18N.getResource("jmstudio.error.controller") + "\n" + controllerErrorEvent.getMessage();
        MessageDialog.createErrorDialogModeless(this, string);
        if (this.boolMediaClosed) {
            this.boolErrorClose = true;
            this.killCurrentPlayer();
            this.boolErrorClose = false;
        }
        this.boolMediaClosed = true;
    }

    protected void processControllerClosed(ControllerClosedEvent controllerClosedEvent) {
        this.boolMediaClosed = true;
        this.setCursor(this.cursorNormal);
    }

    protected void processCachingControl(CachingControlEvent cachingControlEvent) {
        Component component = null;
        CachingControl cachingControl = cachingControlEvent.getCachingControl();
        if (cachingControl == null) {
            return;
        }
        if (component == null) {
            component = cachingControl.getControlComponent();
        }
        if (component == null) {
            component = cachingControl.getProgressBarComponent();
        }
        if (component == null) {
            return;
        }
        if (component == this.progressBarCache) {
            return;
        }
        if (this.mediaPlayerCurrent != null && this.mediaPlayerCurrent.getState() >= 300) {
            return;
        }
        this.killCurrentView();
        this.progressBarCache = component;
        this.panelContent.add(this.progressBarCache, "Center");
        this.setCursor(this.cursorNormal);
    }

    protected void processFormatChange(FormatChangeEvent formatChangeEvent) {
        this.killCurrentView();
        this.panelVideo = new VideoPanel(this.mediaPlayerCurrent);
        this.panelVideo.setZoom(1.0);
        this.panelVideo.addMenuZoomActionListener(this);
        this.panelContent.add((Component)this.panelVideo, "Center");
        this.compControl = this.mediaPlayerCurrent.getControlPanelComponent();
        if (this.compControl != null) {
            this.panelContent.add(this.compControl, "South");
        }
    }

    protected void processReplaceURL(ControllerEvent controllerEvent) {
        this.killCurrentPlayer();
        try {
            Class<?> clazz = Class.forName("com.ibm.media.ReplaceURLEvent");
            Class<?> clazz2 = controllerEvent.getClass();
            clazz.isAssignableFrom(clazz2);
            Method method = clazz2.getMethod("getURL", null);
            URL uRL = (URL)method.invoke((Object)controllerEvent, null);
            this.open(uRL.toString());
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() != this.areaImagePlaceholder && this.areaImagePlaceholder != null && this.areaImagePlaceholder.getParent() == this.panelContent) {
            this.panelContent.remove(this.areaImagePlaceholder);
        }
        this.pack();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.panelContent.getComponentCount() < 1 && containerEvent.getChild() != this.areaImagePlaceholder) {
            this.setPlaceholder();
        } else {
            this.pack();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.killCurrentPlayer();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }
}

