/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.batik.gvt.GVTTreeWalker;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class FindDialog
extends JDialog
implements ActionMap {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.FindDialog";
    public static final String FIND_ACTION = "FindButtonAction";
    public static final String CLEAR_ACTION = "ClearButtonAction";
    public static final String CLOSE_ACTION = "CloseButtonAction";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.FindDialog", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected ButtonFactory buttonFactory;
    protected GraphicsNode gvtRoot;
    protected GVTTreeWalker walker;
    protected int currentIndex;
    protected JTextField search;
    protected JButton findButton;
    protected JButton clearButton;
    protected JButton closeButton;
    protected JCheckBox caseSensitive;
    protected JSVGCanvas svgCanvas;
    protected JRadioButton highlightButton;
    protected JRadioButton highlightCenterButton;
    protected JRadioButton highlightCenterZoomButton;
    protected Map listeners = new HashMap(10);

    public FindDialog(JSVGCanvas jSVGCanvas) {
        this(null, jSVGCanvas);
    }

    public FindDialog(Frame frame, JSVGCanvas jSVGCanvas) {
        super(frame, resources.getString("Dialog.title"));
        this.svgCanvas = jSVGCanvas;
        this.buttonFactory = new ButtonFactory(bundle, (ActionMap)this);
        this.listeners.put(FIND_ACTION, new FindButtonAction());
        this.listeners.put(CLEAR_ACTION, new ClearButtonAction());
        this.listeners.put(CLOSE_ACTION, new CloseButtonAction());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add((Component)this.createFindPanel(), "Center");
        jPanel.add((Component)this.createShowResultPanel(), "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    protected JPanel createFindPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        extendedGridBagConstraints.insets = new Insets(2, 2, 2, 2);
        extendedGridBagConstraints.anchor = 13;
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
        jPanel.add((Component)new JLabel(resources.getString("FindLabel.text")), extendedGridBagConstraints);
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.setWeight(1.0, 0.0);
        extendedGridBagConstraints.setGridBounds(1, 0, 2, 1);
        this.search = new JTextField(20);
        jPanel.add((Component)this.search, extendedGridBagConstraints);
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.anchor = 17;
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        extendedGridBagConstraints.setGridBounds(1, 1, 1, 1);
        this.caseSensitive = this.buttonFactory.createJCheckBox("CaseSensitiveCheckBox");
        jPanel.add((Component)this.caseSensitive, extendedGridBagConstraints);
        return jPanel;
    }

    protected JPanel createShowResultPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("ShowResultPanel.title")));
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        extendedGridBagConstraints.insets = new Insets(2, 2, 2, 2);
        extendedGridBagConstraints.anchor = 17;
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.highlightButton = this.buttonFactory.createJRadioButton("Highlight");
        this.highlightButton.setSelected(true);
        buttonGroup.add(this.highlightButton);
        extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
        jPanel.add((Component)this.highlightButton, extendedGridBagConstraints);
        this.highlightCenterButton = this.buttonFactory.createJRadioButton("HighlightAndCenter");
        buttonGroup.add(this.highlightCenterButton);
        extendedGridBagConstraints.setGridBounds(0, 1, 1, 1);
        jPanel.add((Component)this.highlightCenterButton, extendedGridBagConstraints);
        this.highlightCenterZoomButton = this.buttonFactory.createJRadioButton("HighlightCenterAndZoom");
        buttonGroup.add(this.highlightCenterZoomButton);
        extendedGridBagConstraints.setGridBounds(0, 2, 1, 1);
        jPanel.add((Component)this.highlightCenterZoomButton, extendedGridBagConstraints);
        return jPanel;
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.findButton = this.buttonFactory.createJButton("FindButton");
        jPanel.add(this.findButton);
        this.clearButton = this.buttonFactory.createJButton("ClearButton");
        jPanel.add(this.clearButton);
        this.closeButton = this.buttonFactory.createJButton("CloseButton");
        jPanel.add(this.closeButton);
        return jPanel;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        this.gvtRoot = graphicsNode;
        this.walker = graphicsNode != null ? new GVTTreeWalker(graphicsNode) : null;
    }

    protected GraphicsNode getNext(String string) {
        GraphicsNode graphicsNode;
        int n;
        if (this.walker == null && this.gvtRoot != null) {
            this.walker = new GVTTreeWalker(this.gvtRoot);
        }
        if ((n = this.match(graphicsNode = this.walker.getCurrentGraphicsNode(), string, this.currentIndex + string.length())) >= 0) {
            this.currentIndex = n;
        } else {
            this.currentIndex = 0;
            graphicsNode = this.walker.nextGraphicsNode();
            while (graphicsNode != null && (this.currentIndex = this.match(graphicsNode, string, this.currentIndex)) < 0) {
                graphicsNode = this.walker.nextGraphicsNode();
            }
        }
        return graphicsNode;
    }

    protected int match(GraphicsNode graphicsNode, String string, int n) {
        if (!(graphicsNode instanceof TextNode) || !graphicsNode.isVisible() || string == null || string.length() == 0) {
            return -1;
        }
        String string2 = ((TextNode)graphicsNode).getText();
        if (!this.caseSensitive.isSelected()) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        return string2.indexOf(string, n);
    }

    protected void showSelectedGraphicsNode() {
        double d;
        double d2;
        double d3;
        GraphicsNode graphicsNode = this.walker.getCurrentGraphicsNode();
        if (!(graphicsNode instanceof TextNode)) {
            return;
        }
        TextNode textNode = (TextNode)graphicsNode;
        String string = textNode.getText();
        String string2 = this.search.getText();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        attributedCharacterIterator.first();
        int n = 0;
        while (n < string.indexOf(string2, this.currentIndex)) {
            attributedCharacterIterator.next();
            ++n;
        }
        Mark mark = textNode.getMarkerForChar(attributedCharacterIterator.getIndex(), true);
        int n2 = 0;
        while (n2 < string2.length() - 1) {
            attributedCharacterIterator.next();
            ++n2;
        }
        Mark mark2 = textNode.getMarkerForChar(attributedCharacterIterator.getIndex(), false);
        this.svgCanvas.select(mark, mark2);
        if (this.highlightButton.isSelected()) {
            return;
        }
        Shape shape = textNode.getHighlightShape();
        AffineTransform affineTransform = this.highlightCenterZoomButton.isSelected() ? this.svgCanvas.getInitialTransform() : this.svgCanvas.getRenderingTransform();
        Rectangle rectangle = affineTransform.createTransformedShape(shape).getBounds();
        Dimension dimension = this.svgCanvas.getSize();
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-((RectangularShape)rectangle).getX() - ((RectangularShape)rectangle).getWidth() / 2.0, -((RectangularShape)rectangle).getY() - ((RectangularShape)rectangle).getHeight() / 2.0);
        if (this.highlightCenterZoomButton.isSelected() && (d3 = Math.min(d2 = (double)dimension.width / ((RectangularShape)rectangle).getWidth(), d = (double)dimension.height / ((RectangularShape)rectangle).getHeight()) / 8.0) > 1.0) {
            affineTransform2.preConcatenate(AffineTransform.getScaleInstance(d3, d3));
        }
        affineTransform2.preConcatenate(AffineTransform.getTranslateInstance(dimension.width / 2, dimension.height / 2));
        AffineTransform affineTransform3 = new AffineTransform(affineTransform);
        affineTransform3.preConcatenate(affineTransform2);
        this.svgCanvas.setRenderingTransform(affineTransform3);
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindDialog.this.dispose();
        }
    }

    protected class ClearButtonAction
    extends AbstractAction {
        protected ClearButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindDialog.this.search.setText(null);
            FindDialog.this.walker = null;
        }
    }

    protected class FindButtonAction
    extends AbstractAction {
        protected FindButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = FindDialog.this.search.getText();
            if (string == null || string.length() == 0) {
                return;
            }
            GraphicsNode graphicsNode = FindDialog.this.getNext(string);
            if (graphicsNode != null) {
                FindDialog.this.showSelectedGraphicsNode();
            } else {
                FindDialog.this.walker = null;
                JOptionPane.showMessageDialog(FindDialog.this, resources.getString("End.text"), resources.getString("End.title"), 1);
            }
        }
    }
}

