/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.batik.swing.JSVGCanvas;

public class LocalHistory {
    protected JSVGCanvas svgCanvas;
    protected JMenu menu;
    protected int index;
    protected List visitedURIs = new ArrayList();
    protected int currentURI = -1;
    protected ButtonGroup group = new ButtonGroup();
    protected ActionListener actionListener = new RadioListener();
    protected int state;
    protected static final int STABLE_STATE = 0;
    protected static final int BACK_PENDING_STATE = 1;
    protected static final int FORWARD_PENDING_STATE = 2;
    protected static final int RELOAD_PENDING_STATE = 3;

    public LocalHistory(JMenuBar jMenuBar, JSVGCanvas jSVGCanvas) {
        this.svgCanvas = jSVGCanvas;
        int n = jMenuBar.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            JMenu jMenu = jMenuBar.getMenu(n2);
            int n3 = jMenu.getItemCount();
            int n4 = 0;
            while (n4 < n3) {
                String string;
                JMenuItem jMenuItem = jMenu.getItem(n4);
                if (jMenuItem != null && "@@@".equals(string = jMenuItem.getText())) {
                    this.menu = jMenu;
                    this.index = n4;
                    jMenu.remove(n4);
                    return;
                }
                ++n4;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No '@@@' marker found");
    }

    public void back() {
        this.update();
        this.state = 1;
        this.currentURI -= 2;
        this.svgCanvas.loadSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoBack() {
        return this.currentURI > 0;
    }

    public void forward() {
        this.update();
        this.state = 2;
        this.svgCanvas.loadSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoForward() {
        return this.currentURI < this.visitedURIs.size() - 1;
    }

    public void reload() {
        this.update();
        this.state = 3;
        --this.currentURI;
        this.svgCanvas.loadSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public void update(String string) {
        Object object;
        JMenuItem jMenuItem;
        int n;
        if (this.currentURI < -1) {
            throw new InternalError();
        }
        this.state = 0;
        if (++this.currentURI < this.visitedURIs.size()) {
            if (!this.visitedURIs.get(this.currentURI).equals(string)) {
                int n2 = this.menu.getItemCount();
                n = n2 - 1;
                while (n >= this.index + this.currentURI + 1) {
                    jMenuItem = this.menu.getItem(n);
                    this.group.remove(jMenuItem);
                    this.menu.remove(n);
                    --n;
                }
                this.visitedURIs = this.visitedURIs.subList(0, this.currentURI + 1);
            }
            object = this.menu.getItem(this.index + this.currentURI);
            this.group.remove((AbstractButton)object);
            this.menu.remove(this.index + this.currentURI);
            this.visitedURIs.set(this.currentURI, string);
        } else {
            if (this.visitedURIs.size() >= 15) {
                this.visitedURIs.remove(0);
                object = this.menu.getItem(this.index);
                this.group.remove((AbstractButton)object);
                this.menu.remove(this.index);
                --this.currentURI;
            }
            this.visitedURIs.add(string);
        }
        object = string;
        n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
            if (n != -1) {
                object = string.substring(n + 1);
            }
        } else {
            object = string.substring(n + 1);
        }
        jMenuItem = new JRadioButtonMenuItem((String)object);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this.actionListener);
        this.group.add(jMenuItem);
        jMenuItem.setSelected(true);
        this.menu.insert(jMenuItem, this.index + this.currentURI);
    }

    protected void update() {
        switch (this.state) {
            case 1: {
                this.currentURI += 2;
                break;
            }
            case 3: {
                ++this.currentURI;
            }
        }
    }

    protected class RadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            LocalHistory.this.currentURI = this.getItemIndex((JMenuItem)actionEvent.getSource()) - 1;
            LocalHistory.this.svgCanvas.loadSVGDocument(string);
        }

        public int getItemIndex(JMenuItem jMenuItem) {
            int n = LocalHistory.this.menu.getItemCount();
            int n2 = LocalHistory.this.index;
            while (n2 < n) {
                if (LocalHistory.this.menu.getItem(n2) == jMenuItem) {
                    return n2 - LocalHistory.this.index;
                }
                ++n2;
            }
            throw new InternalError();
        }
    }
}

