/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.svg.MarkerFactory;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class MarkerShorthandFactory
extends AbstractValueFactory {
    protected ValueFactory markerEndFactory;
    protected ValueFactory markerMidFactory;
    protected ValueFactory markerStartFactory;

    public MarkerShorthandFactory(Parser parser) {
        super(parser);
        this.markerEndFactory = new MarkerFactory(this.parser, "marker-end");
        this.markerMidFactory = new MarkerFactory(this.parser, "marker-mid");
        this.markerStartFactory = new MarkerFactory(this.parser, "marker-start");
    }

    public String getPropertyName() {
        return "marker";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)15, "not.supported", null);
    }

    public void createCSSValue(LexicalUnit lexicalUnit, CSSOMStyleDeclaration cSSOMStyleDeclaration, String string) throws DOMException {
        ImmutableValue immutableValue;
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                immutableValue = ValueConstants.INHERIT;
                break;
            }
            case 24: {
                immutableValue = new ImmutableString(20, lexicalUnit.getStringValue());
                break;
            }
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    immutableValue = ValueConstants.NONE_VALUE;
                    break;
                }
            }
            default: {
                throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType())});
            }
        }
        cSSOMStyleDeclaration.setPropertyCSSValue("marker-end", new CSSOMValue(this.markerEndFactory, immutableValue), string);
        cSSOMStyleDeclaration.setPropertyCSSValue("marker-mid", new CSSOMValue(this.markerMidFactory, immutableValue), string);
        cSSOMStyleDeclaration.setPropertyCSSValue("marker-start", new CSSOMValue(this.markerStartFactory, immutableValue), string);
    }
}

