/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractIdentifierFactory;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ImmutableValueList;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class TextDecorationFactory
extends AbstractValueFactory
implements ValueConstants {
    protected static final PropertyMap values = new PropertyMap();
    protected IdentFactory identFactory = new IdentFactory(this.getParser());

    public TextDecorationFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "text-decoration";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                ImmutableValueList immutableValueList = new ImmutableValueList(' ');
                do {
                    immutableValueList.append(new CSSOMValue(this.identFactory, this.identFactory.createValue(lexicalUnit)));
                } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
                return immutableValueList;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s != 21 || !string.equalsIgnoreCase("none")) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
        }
        return ValueConstants.NONE_VALUE;
    }

    static {
        values.put("blink", ValueConstants.BLINK_VALUE);
        values.put("line-through", ValueConstants.LINE_THROUGH_VALUE);
        values.put("overline", ValueConstants.OVERLINE_VALUE);
        values.put("underline", ValueConstants.UNDERLINE_VALUE);
    }

    protected class IdentFactory
    extends AbstractIdentifierFactory {
        public IdentFactory(Parser parser) {
            super(parser);
        }

        public String getPropertyName() {
            return null;
        }

        protected PropertyMap getIdentifiers() {
            return values;
        }
    }
}

