/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileBlock;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public abstract class AbstractTiledRed
extends AbstractRed
implements TileGenerator {
    private TileStore tiles;
    private static int defaultTileSize = 128;

    public static int getDefaultTileSize() {
        return defaultTileSize;
    }

    protected AbstractTiledRed() {
    }

    protected AbstractTiledRed(Rectangle rectangle, Map map) {
        super(rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Map map) {
        super(cachableRed, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, Map map) {
        super(cachableRed, rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = this.createTileStore();
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, Map map) {
        super(list, rectangle, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(list, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(list, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super.init(list, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = this.createTileStore();
    }

    public TileStore getTileStore() {
        return this.tiles;
    }

    protected TileStore createTileStore() {
        return TileCache.getTileMap(this);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRasterByBlocks(writableRaster);
        return writableRaster;
    }

    public Raster getData(Rectangle rectangle) {
        int n = this.getXTile(rectangle.x);
        int n2 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n3 = this.getYTile(rectangle.y);
        int n4 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n == n2 && n3 == n4) {
            Raster raster = this.getTile(n, n3);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        return super.getData(rectangle);
    }

    public Raster getTile(int n, int n2) {
        return this.tiles.getTile(n, n2);
    }

    public Raster genTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public abstract void genRect(WritableRaster var1);

    public void setTile(int n, int n2, Raster raster) {
        this.tiles.setTile(n, n2, raster);
    }

    public void copyToRasterByBlocks(WritableRaster writableRaster) {
        TileBlock tileBlock;
        int n;
        Object object;
        int n2;
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n3 = this.getXTile(rectangle2.x);
        int n4 = this.getYTile(rectangle2.y);
        int n5 = this.getXTile(rectangle2.x + rectangle2.width - 1);
        int n6 = this.getYTile(rectangle2.y + rectangle2.height - 1);
        if (n3 < this.minTileX) {
            n3 = this.minTileX;
        }
        if (n4 < this.minTileY) {
            n4 = this.minTileY;
        }
        if (n5 >= this.minTileX + this.numXTiles) {
            n5 = this.minTileX + this.numXTiles - 1;
        }
        if (n6 >= this.minTileY + this.numYTiles) {
            n6 = this.minTileY + this.numYTiles - 1;
        }
        if (n5 < n3 || n6 < n4) {
            return;
        }
        int n7 = n3;
        int n8 = n5;
        int n9 = n4;
        int n10 = n6;
        int n11 = n3 * this.tileWidth + this.tileGridXOff;
        if (n11 < rectangle2.x && rectangle.x != rectangle2.x) {
            ++n7;
        }
        if ((n2 = n4 * this.tileHeight + this.tileGridYOff) < rectangle2.y && rectangle.y != rectangle2.y) {
            ++n9;
        }
        if ((n11 = (n5 + 1) * this.tileWidth + this.tileGridXOff - 1) >= rectangle2.x + rectangle2.width && rectangle.x + rectangle.width != rectangle2.x + rectangle2.width) {
            --n8;
        }
        if ((n2 = (n6 + 1) * this.tileHeight + this.tileGridYOff - 1) >= rectangle2.y + rectangle2.height && rectangle.y + rectangle.height != rectangle2.y + rectangle2.height) {
            --n10;
        }
        int n12 = n8 - n7 + 1;
        int n13 = n10 - n9 + 1;
        boolean[] blArray = null;
        if (n12 > 0 && n13 > 0) {
            blArray = new boolean[n12 * n13];
        }
        boolean[] blArray2 = new boolean[2 * (n5 - n3 + 1) + 2 * (n6 - n4 + 1)];
        int n14 = 0;
        int n15 = 0;
        int n16 = n4;
        while (n16 <= n6) {
            int n17 = n3;
            while (n17 <= n5) {
                object = this.tiles.getTileNoCompute(n17, n16);
                int n18 = n = object != null ? 1 : 0;
                if (n16 >= n9 && n16 <= n10 && n17 >= n7 && n17 <= n8) {
                    blArray[n17 - n7 + (n16 - n9) * n12] = n;
                } else {
                    blArray2[n14++] = n;
                }
                if (n != 0) {
                    ++n15;
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK((Raster)object, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK((Raster)object, writableRaster);
                    }
                }
                ++n17;
            }
            ++n16;
        }
        if (n12 > 0 && n13 > 0 && (object = (tileBlock = new TileBlock(n7, n9, n12, n13, blArray, 0, 0, n12, n13)).getBestSplit()) != null) {
            n = 0;
            while (n < ((TileBlock[])object).length) {
                TileBlock tileBlock2 = object[n];
                int n19 = tileBlock2.getXLoc() * this.tileWidth + this.tileGridXOff;
                int n20 = tileBlock2.getYLoc() * this.tileHeight + this.tileGridYOff;
                Rectangle rectangle3 = new Rectangle(n19, n20, tileBlock2.getWidth() * this.tileWidth, tileBlock2.getHeight() * this.tileHeight);
                rectangle3 = rectangle3.intersection(rectangle);
                WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                this.genRect(writableRaster2);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ++n;
            }
        }
        n14 = 0;
        n2 = n4;
        while (n2 <= n6) {
            n11 = n3;
            while (n11 <= n5) {
                Raster raster = this.tiles.getTileNoCompute(n11, n2);
                if (n2 >= n9 && n2 <= n10 && n11 >= n7 && n11 <= n8) {
                    if (raster == null) {
                        object = this.makeTile(n11, n2);
                        if (bl) {
                            GraphicsUtil.copyData_INT_PACK(writableRaster, (WritableRaster)object);
                        } else {
                            GraphicsUtil.copyData_FALLBACK(writableRaster, (WritableRaster)object);
                        }
                        this.tiles.setTile(n11, n2, (Raster)object);
                    }
                } else if (!blArray2[n14++]) {
                    raster = this.getTile(n11, n2);
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n11;
            }
            ++n2;
        }
    }

    public void copyToRaster(WritableRaster writableRaster) {
        Rectangle rectangle = writableRaster.getBounds();
        int n = this.getXTile(rectangle.x);
        int n2 = this.getYTile(rectangle.y);
        int n3 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n4 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n < this.minTileX) {
            n = this.minTileX;
        }
        if (n2 < this.minTileY) {
            n2 = this.minTileY;
        }
        if (n3 >= this.minTileX + this.numXTiles) {
            n3 = this.minTileX + this.numXTiles - 1;
        }
        if (n4 >= this.minTileY + this.numYTiles) {
            n4 = this.minTileY + this.numYTiles - 1;
        }
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n5 = n3 - n + 1;
        boolean[] blArray = new boolean[n5 * (n4 - n2 + 1)];
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                Raster raster = this.tiles.getTileNoCompute(n7, n6);
                if (raster != null) {
                    blArray[n7 - n + (n6 - n2) * n5] = true;
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n7;
            }
            ++n6;
        }
        int n8 = n2;
        while (n8 <= n4) {
            int n9 = n;
            while (n9 <= n3) {
                if (!blArray[n9 - n + (n8 - n2) * n5]) {
                    Raster raster = this.getTile(n9, n8);
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n9;
            }
            ++n8;
        }
    }
}

