/*
 * Decompiled with CFR 0.152.
 */
package mpi.alt.java.awt.im.spi.lookup;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import mpi.alt.java.awt.im.spi.lookup.LookupList;

public class Lookup
implements InputMethod {
    static final int lookupWindowSizeInElements = 10;
    public static final Locale IPA96_RTR = new Locale("ipa-96", "", "rtr");
    public static final Locale CHINESE_SIM = new Locale("chinese", "", "simplified");
    public static final Locale CHINESE_TRA = new Locale("chinese", "", "traditional");
    static Locale[] SUPPORTED_LOCALES = new Locale[]{IPA96_RTR, CHINESE_SIM, CHINESE_TRA};
    private static Hashtable hashedFilenames = new Hashtable();
    private static Window statusWindow;
    private static Label statusWindowLabel;
    private static boolean statusWindowIsShown;
    private static HashMap pinyinHash;
    private String[] lookupCandidates;
    private Locale[] lookupLocales;
    private int lookupCandidateCount;
    private int lookupCandidateIndex;
    private LookupList lookupList;
    private int lookupSelection;
    private InputMethodContext inputMethodContext;
    private Locale locale;
    private boolean converted;
    private StringBuffer rawText = new StringBuffer();
    private String convertedText;

    private static final void debugln(String s) {
        if (!"true".equals(System.getProperty("debug"))) {
            return;
        }
        System.out.println(s);
    }

    private final void updateStatusWindow(Locale locale) {
        if (statusWindowLabel == null) {
            return;
        }
        statusWindowLabel.setText(locale == null ? "default" : locale.getDisplayName());
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeHash(Locale locale) throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String buffer;
            pinyinHash = new HashMap();
            BufferedReader datafile = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream((String)hashedFilenames.get(locale)), "UTF8"));
            while ((buffer = datafile.readLine()) != null) {
                void var4_4;
                int index = var4_4.indexOf("\t");
                String pinyin = var4_4.substring(0, index);
                ArrayList<String> newlist = new ArrayList<String>();
                int oldindex = index + 1;
                do {
                    String hanzi;
                    if ((index = var4_4.indexOf(" ", oldindex)) == -1) {
                        index = var4_4.length();
                    }
                    if ((hanzi = var4_4.substring(oldindex, index)).length() <= 0) continue;
                    newlist.add(hanzi);
                } while ((oldindex = index + 1) < var4_4.length());
                pinyinHash.put(pinyin.intern(), newlist);
            }
            datafile.close();
        }
    }

    private final boolean wordResultsInHash(char ch) {
        return pinyinHash.containsKey(this.rawText + new Character(ch).toString());
    }

    private final boolean lookupCharacter(char ch) {
        if (this.wordResultsInHash(ch)) {
            this.rawText.append(ch);
            this.sendText(false);
            return true;
        }
        return false;
    }

    private final void UpDownHandler(boolean up) {
        Lookup.debugln("lookupCandidateIndex " + this.lookupCandidateIndex);
        Lookup.debugln("lookupCandidateCount " + this.lookupCandidateCount);
        Lookup.debugln("lookupSelection " + this.lookupSelection);
        if (up) {
            if (this.lookupSelection + this.lookupCandidateIndex == 0) {
                return;
            }
            if (this.lookupSelection == 1 && this.lookupCandidateIndex != 0) {
                this.scrollHandler(up, 1);
                return;
            }
        } else if (this.lookupCandidateCount - this.lookupCandidateIndex < 10) {
            if (this.lookupSelection + this.lookupCandidateIndex == this.lookupCandidateCount - 1) {
                return;
            }
        } else {
            if (this.lookupSelection == 8) {
                this.scrollHandler(up, 1);
                return;
            }
            if (this.lookupSelection == 9) {
                return;
            }
        }
        this.lookupSelection -= up ? 1 : -1;
        this.lookupList.selectCandidate(this.lookupSelection);
    }

    private final void scrollHandler(boolean up) {
        this.scrollHandler(up, 10);
    }

    private final void scrollHandler(boolean up, int jumpsize) {
        if (up) {
            if (this.lookupCandidateIndex + this.lookupSelection - jumpsize >= 0) {
                this.lookupCandidateIndex -= jumpsize;
                this.lookupList.updateCandidates(this.lookupCandidateIndex);
            }
        } else if (this.lookupCandidateIndex + jumpsize < this.lookupCandidateCount) {
            this.lookupCandidateIndex += jumpsize;
            this.lookupList.updateCandidates(this.lookupCandidateIndex);
            if (this.lookupSelection + this.lookupCandidateIndex > this.lookupCandidateCount) {
                this.lookupSelection = this.lookupCandidateCount - 1 - this.lookupCandidateIndex;
                this.lookupList.selectCandidate(this.lookupSelection);
            }
        }
    }

    private final void handlePressedKey(KeyEvent e) {
        if (this.lookupList == null) {
            return;
        }
        switch (e.getKeyCode()) {
            case 38: {
                this.UpDownHandler(true);
                break;
            }
            case 224: {
                this.UpDownHandler(true);
                break;
            }
            case 40: {
                this.UpDownHandler(false);
                break;
            }
            case 225: {
                this.UpDownHandler(false);
                break;
            }
            case 33: {
                this.scrollHandler(true);
                break;
            }
            case 34: {
                this.scrollHandler(false);
            }
        }
        e.consume();
    }

    private final void handleTypedKey(KeyEvent e) {
        char ch = e.getKeyChar();
        int chkc = e.getKeyCode();
        if (this.lookupList != null) {
            if (' ' == ch || '\n' == ch) {
                this.selectCandidate(this.lookupSelection);
                this.commit();
                this.closeLookupWindow();
                e.consume();
                return;
            }
            if (ch == '\b') {
                if (this.rawText.length() != 0) {
                    this.rawText.setLength(this.rawText.length() - 1);
                    this.sendText(false);
                }
                e.consume();
                return;
            }
            this.lookupCharacter(ch);
            e.consume();
            return;
        }
        if (this.rawText.length() != 0) {
            System.out.println("ask Markus: why is there rawText?");
        }
        if (this.lookupCharacter(ch)) {
            e.consume();
        }
    }

    private final void commit() {
        this.sendText(true);
        this.rawText.setLength(0);
        this.convertedText = null;
        this.converted = false;
        this.closeLookupWindow();
    }

    private final void sendText(boolean committed) {
        InputMethodHighlight highlight;
        String text;
        int committedCharacterCount = 0;
        if (this.converted) {
            text = this.convertedText;
            highlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
        } else if (this.rawText.length() > 0) {
            text = new String(this.rawText);
            highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            String lookupName = this.rawText.toString().toLowerCase();
            ArrayList templist = (ArrayList)pinyinHash.get(lookupName.intern());
            if (templist == null) {
                Toolkit.getDefaultToolkit().beep();
                templist = (ArrayList)pinyinHash.get("a");
            }
            this.lookupCandidates = new String[templist.size()];
            int k = 0;
            while (k < this.lookupCandidates.length) {
                this.lookupCandidates[k] = (String)templist.get(k);
                ++k;
            }
            if (this.lookupCandidates != null) {
                this.lookupCandidateCount = this.lookupCandidates.length;
                this.lookupSelection = 0;
                this.lookupCandidateIndex = 0;
                if (this.lookupList != null) {
                    this.lookupList.setVisible(false);
                    this.lookupList = null;
                }
                this.openLookupWindow();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            text = "";
            highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            this.closeLookupWindow();
        }
        AttributedString as = new AttributedString(text);
        if (committed) {
            committedCharacterCount = text.length();
        } else if (text.length() > 0) {
            as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, highlight);
        }
        this.inputMethodContext.dispatchInputMethodEvent(1100, as.getIterator(), committedCharacterCount, TextHitInfo.leading(text.length()), null);
    }

    private final void selectCandidate(int candidate) {
        this.lookupSelection = this.lookupCandidateIndex + candidate;
        this.lookupList.selectCandidate(this.lookupSelection);
        this.convertedText = this.lookupCandidates[this.lookupSelection];
        this.converted = true;
        this.sendText(false);
    }

    private final void openLookupWindow() {
        this.lookupList = new LookupList(this, this.inputMethodContext, this.lookupCandidates, this.lookupCandidateCount);
        this.lookupList.selectCandidate(this.lookupSelection);
    }

    private final void closeLookupWindow() {
        if (this.lookupList != null) {
            this.lookupList.setVisible(false);
            this.lookupList = null;
        }
    }

    public void activate() {
        if (statusWindowIsShown) {
            if (!statusWindow.isVisible()) {
                ((Component)statusWindow).setVisible(true);
            }
            this.updateStatusWindow(this.locale);
        }
    }

    public void deactivate(boolean isTemporary) {
        this.hideWindows();
    }

    public void dispatchEvent(AWTEvent event) {
        MouseEvent mevent;
        if (event instanceof KeyEvent) {
            switch (((KeyEvent)event).getID()) {
                case 400: {
                    this.handleTypedKey((KeyEvent)event);
                    break;
                }
                case 401: {
                    this.handlePressedKey((KeyEvent)event);
                }
            }
        }
        if (event instanceof MouseEvent && (mevent = (MouseEvent)event).getID() == 501) {
            int n = mevent.getY();
        }
    }

    public void dispose() {
        this.hideWindows();
    }

    public void endComposition() {
        if (this.rawText.length() != 0) {
            this.commit();
        }
        this.hideWindows();
    }

    public Object getControlObject() {
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void hideWindows() {
        this.closeLookupWindow();
        if (statusWindowIsShown) {
            statusWindow.hide();
        }
    }

    public boolean isCompositionEnabled() {
        return true;
    }

    public void notifyClientWindowChange(Rectangle location) {
    }

    public void reconvert() {
        throw new UnsupportedOperationException();
    }

    public void removeNotify() {
    }

    public void setCharacterSubsets(Character.Subset[] subsets) {
    }

    public void setCompositionEnabled(boolean enable) {
        throw new UnsupportedOperationException();
    }

    public void setInputMethodContext(InputMethodContext context) {
        this.inputMethodContext = context;
        if (statusWindow == null && statusWindowIsShown) {
            statusWindow = this.inputMethodContext.createInputMethodWindow("Language", false);
            statusWindowLabel = new Label();
            statusWindowLabel.setBackground(Color.white);
            statusWindowLabel.setSize(200, 50);
            statusWindow.add(statusWindowLabel);
            this.updateStatusWindow(this.locale);
            statusWindow.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)statusWindow).setLocation(d.width - statusWindow.getWidth(), d.height - statusWindow.getHeight());
        }
    }

    public boolean setLocale(Locale locale) {
        if (locale == null) {
            return false;
        }
        if (locale == this.locale) {
            return true;
        }
        if (!hashedFilenames.containsKey(locale)) {
            return false;
        }
        try {
            this.initializeHash(locale);
            this.updateStatusWindow(locale);
            this.closeLookupWindow();
            this.locale = locale;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        hashedFilenames.put(SUPPORTED_LOCALES[0], "ipa96.u8");
        hashedFilenames.put(SUPPORTED_LOCALES[1], "PinyinSC.u8");
        hashedFilenames.put(SUPPORTED_LOCALES[2], "PinyinTC.u8");
        statusWindowIsShown = false;
    }
}

