/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.im.spi.lookup;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.util.Locale;
import javax.swing.JFrame;

public class LookupList
extends Canvas {
    InputMethod inputMethod;
    InputMethodContext context;
    Window lookupWindow;
    String[] candidates;
    Locale[] locales;
    int candidateCount;
    int selected;
    int lookupCandidateIndex;
    final int FONT_SIZE = 22;
    final int INSIDE_INSET = 4;
    final int LINE_SPACING = 24;

    public LookupList(InputMethod inputMethod, InputMethodContext context, String[] candidates, int candidateCount) {
        if (context == null) {
            System.out.println("assertion failed! LookupList.java context is null!");
        }
        this.inputMethod = inputMethod;
        this.context = context;
        this.candidates = candidates;
        this.candidateCount = candidateCount;
        this.lookupCandidateIndex = 0;
        this.lookupWindow = context.createInputMethodJFrame("Lookup list", true);
        this.setFont(new Font("Arial Unicode MS", 0, 22));
        this.setSize(100, 248);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.enableEvents(8L);
        this.enableEvents(16L);
        ((JFrame)this.lookupWindow).getContentPane().add(this);
        this.lookupWindow.pack();
        this.updateWindowLocation();
        this.lookupWindow.setVisible(true);
    }

    private void updateWindowLocation() {
        Point windowLocation = new Point();
        Rectangle caretRect = this.context.getTextLocation(TextHitInfo.leading(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.lookupWindow.getSize();
        int SPACING = 2;
        windowLocation.x = caretRect.x + windowSize.width > screenSize.width ? screenSize.width - windowSize.width : caretRect.x;
        windowLocation.y = caretRect.y + caretRect.height + 2 + windowSize.height > screenSize.height ? caretRect.y - 2 - windowSize.height : caretRect.y + caretRect.height + 2;
        this.lookupWindow.setLocation(windowLocation);
    }

    public void updateCandidates(int candidateIndex) {
        this.lookupCandidateIndex = candidateIndex;
        this.repaint();
    }

    public void selectCandidate(int candidate) {
        this.selected = candidate;
        this.repaint();
    }

    public void paint(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        int descent = metrics.getDescent();
        int ascent = metrics.getAscent();
        int windowCount = this.candidateCount - this.lookupCandidateIndex < 10 ? this.candidateCount - this.lookupCandidateIndex : 10;
        for (int i = this.lookupCandidateIndex; i < this.lookupCandidateIndex + windowCount; ++i) {
            int displayedNumber = i - this.lookupCandidateIndex + 1;
            displayedNumber = displayedNumber == 10 ? 0 : displayedNumber;
            g.drawString("   " + this.candidates[i], 4, 24 * (i - this.lookupCandidateIndex + 1) + 4 - descent);
        }
        Dimension size = this.getSize();
        g.drawRect(2, 24 * (this.selected + 1) + 4 - (descent + ascent + 1), size.width - 4, descent + ascent + 2);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    public void setVisible(boolean visible) {
        if (!visible && this.lookupWindow != null) {
            this.lookupWindow.setVisible(false);
            this.lookupWindow.dispose();
            this.lookupWindow = null;
        } else if (this.lookupWindow != null) {
            this.lookupWindow.setVisible(true);
            this.lookupWindow.toFront();
        }
        super.setVisible(visible);
    }

    protected void processKeyEvent(KeyEvent event) {
        this.inputMethod.dispatchEvent(event);
    }

    protected void processMouseEvent(MouseEvent event) {
        if (event.getID() == 501) {
            this.inputMethod.dispatchEvent(event);
        }
    }
}

