/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ExclusiveUse;
import com.sun.media.util.Registry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

public class JMFInit
extends Frame
implements Runnable {
    private String tempDir = "/tmp";
    private TextArea textBox;
    private boolean done = false;
    private String userHome;

    public JMFInit(String[] stringArray) {
        super("Initializing JMF...");
        this.createGUI();
        this.updateTemp(stringArray);
        if (stringArray.length > 2) {
            boolean bl = false;
            if (stringArray[2].equals("1")) {
                bl = true;
            }
            Registry.set("secure.allowCaptureFromApplets", new Boolean(bl));
            bl = false;
            if (stringArray.length > 3) {
                if (stringArray[3].equals("1")) {
                    bl = true;
                }
                Registry.set("secure.allowSaveFileFromApplets", new Boolean(bl));
            }
            try {
                Registry.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread thread = new Thread(this);
        thread.run();
        int n2 = 0;
        while (!this.done && n2 < 120000) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n2 += 500;
        }
        if (!this.done) {
            this.message("Aborting detection!");
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        this.detectDirectAudio();
        this.detectS8DirectAudio();
        this.detectCaptureDevices();
        this.done = true;
    }

    private void updateTemp(String[] stringArray) {
        if (stringArray.length > 0) {
            this.tempDir = stringArray[0];
            this.message("Setting cache directory to " + this.tempDir);
            Registry registry = new Registry();
            try {
                Registry.set("secure.cacheDir", this.tempDir);
                Registry.commit();
                this.message("Updated registry");
            }
            catch (Exception exception) {
                this.message("Couldn't update registry!");
            }
        }
    }

    private void detectCaptureDevices() {
        this.message("Looking for Audio capturer");
        Class<?> clazz = null;
        try {
            clazz = Class.forName("DirectSoundAuto");
            clazz.newInstance();
            this.message("Finished detecting DirectSound capturer");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("JavaSoundAuto");
            clazz2.newInstance();
            this.message("Finished detecting javasound capturer");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.message("JavaSound capturer detection failed!");
        }
        this.message("Looking for video capture devices");
        Class<?> clazz3 = null;
        Class<?> clazz4 = null;
        try {
            clazz3 = Class.forName("VFWAuto");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz3 == null) {
            try {
                clazz3 = Class.forName("SunVideoAuto");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz4 = Class.forName("SunVideoPlusAuto");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Object obj = clazz3.newInstance();
            if (clazz4 != null) {
                Object obj2 = clazz4.newInstance();
            }
            this.message("Finished detecting video capture devices");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.message("Capture device detection failed!");
        }
    }

    private void detectDirectAudio() {
        int n2 = 4;
        String string = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> clazz = Class.forName("VFWAuto");
            clazz = Class.forName("com.sun.media.protocol.dsound.DSound");
            clazz = Class.forName(string);
            Renderer renderer = (Renderer)clazz.newInstance();
            try {
                AudioFormat audioFormat = new AudioFormat("LINEAR", 44100.0, 16, 2);
                renderer.setInputFormat(audioFormat);
                renderer.open();
                Format[] formatArray = renderer.getSupportedInputFormats();
                PlugInManager.addPlugIn(string, formatArray, new Format[0], n2);
                Vector vector = PlugInManager.getPlugInList(null, null, n2);
                int n3 = vector.size();
                if (vector.elementAt(n3 - 1).equals(string)) {
                    vector.removeElementAt(n3 - 1);
                    vector.insertElementAt(string, 0);
                    PlugInManager.setPlugInList(vector, n2);
                    PlugInManager.commit();
                }
                renderer.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void detectS8DirectAudio() {
        int n2 = 4;
        String string = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> clazz = Class.forName("SunVideoAuto");
            clazz = Class.forName(string);
            Renderer renderer = (Renderer)clazz.newInstance();
            if (renderer instanceof ExclusiveUse && !((ExclusiveUse)((Object)renderer)).isExclusive()) {
                Vector vector = PlugInManager.getPlugInList(null, null, n2);
                int n3 = vector.size();
                boolean bl = false;
                String string2 = null;
                int n4 = 0;
                while (n4 < n3) {
                    string2 = (String)vector.elementAt(n4);
                    if (string2.equals(string)) {
                        bl = true;
                        vector.removeElementAt(n4);
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    vector.insertElementAt(string, 0);
                    PlugInManager.setPlugInList(vector, n2);
                    PlugInManager.commit();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void message(String string) {
        this.textBox.append(string + "\n");
    }

    private void createGUI() {
        this.textBox = new TextArea(5, 50);
        this.add("Center", this.textBox);
        this.textBox.setEditable(false);
        this.addNotify();
        ((Component)this).setVisible(true);
        this.pack();
    }

    public static void main(String[] stringArray) {
        new JMFInit(stringArray);
        System.exit(0);
    }
}

