/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.protocol.sunvideo.XILCapture;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class SunVideoAuto {
    private static String DEVICE_PREFIX = "/dev/rtvc";
    private static String PROTOCOL = "sunvideo";
    private static String LOCATOR_PREFIX = PROTOCOL + "://";
    CaptureDeviceInfo[] devices = null;
    int currentID = -1;
    XILCapture xilCap;
    Vector formats = null;
    int[] ports = new int[]{1, 2, 0};
    int[] scales = new int[]{2, 4, 1};
    static /* synthetic */ Class array$B;

    public SunVideoAuto() {
        Vector vector = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
            String string = captureDeviceInfo.getLocator().getProtocol();
            if (!string.equals(PROTOCOL)) continue;
            CaptureDeviceManager.removeDevice(captureDeviceInfo);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 7) {
            File file = new File(DEVICE_PREFIX + n3);
            if (file.exists()) {
                this.doDevice(n3);
                ++n2;
            }
            ++n3;
        }
        try {
            CaptureDeviceManager.commit();
            System.err.println("SunVideoAuto: Committed ok");
        }
        catch (IOException iOException) {
            System.err.println("SunVideoAuto: error committing cdm");
        }
    }

    private void addFormat(Format format) {
        Enumeration enumeration = this.formats.elements();
        while (enumeration.hasMoreElements()) {
            Format format2 = (Format)enumeration.nextElement();
            if (!format2.equals(format)) continue;
            return;
        }
        this.formats.addElement(format);
    }

    private void doDevice(int n2) {
        this.xilCap = new XILCapture(null);
        this.formats = new Vector();
        boolean bl = false;
        if (!this.xilCap.connect(n2)) {
            this.dummyDevice(n2);
            return;
        }
        int n3 = 0;
        while (n3 < this.ports.length) {
            if (this.xilCap.setPort(this.ports[n3])) {
                this.getJpegFormats(n3);
                this.getRGBFormats(n3);
            }
            ++n3;
        }
        this.xilCap.disconnect();
        if (this.formats.size() > 0) {
            this.addDevice(n2);
        } else {
            this.dummyDevice(n2);
        }
    }

    private void getRGBFormats(int n2) {
        if (!this.xilCap.setCompress("RGB")) {
            return;
        }
        int n3 = 0;
        while (n3 < this.scales.length) {
            this.xilCap.setScale(this.scales[n3]);
            if (this.xilCap.start()) {
                Dimension dimension = new Dimension(this.xilCap.getWidth(), this.xilCap.getHeight());
                int n4 = this.xilCap.getLineStride();
                int n5 = n4 * dimension.width;
                this.addFormat(new RGBFormat(dimension, n5, array$B == null ? SunVideoAuto.class$("[B") : array$B, 15.0f, 24, 3, 2, 1, 3, n4, 0, -1));
            }
            this.xilCap.stop();
            ++n3;
        }
    }

    private void getJpegFormats(int n2) {
        if (!this.xilCap.setCompress("Jpeg")) {
            return;
        }
        int n3 = 0;
        while (n3 < this.scales.length) {
            this.xilCap.setScale(this.scales[n3]);
            if (this.xilCap.start()) {
                Dimension dimension = new Dimension(this.xilCap.getWidth(), this.xilCap.getHeight());
                int n4 = 3 * dimension.width * dimension.height;
                this.addFormat(new VideoFormat("jpeg", dimension, n4, array$B == null ? SunVideoAuto.class$("[B") : array$B, 15.0f));
            }
            this.xilCap.stop();
            ++n3;
        }
    }

    private void dummyDevice(int n2) {
        this.addFormat(new VideoFormat("jpeg"));
        this.addFormat(new RGBFormat());
        this.addDevice(n2);
    }

    private void addDevice(int n2) {
        Serializable serializable;
        String string = "SunVideo device " + n2;
        String string2 = LOCATOR_PREFIX + n2;
        Format[] formatArray = new Format[this.formats.size()];
        Enumeration enumeration = this.formats.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            serializable = (Format)enumeration.nextElement();
            formatArray[n3++] = serializable;
        }
        serializable = new CaptureDeviceInfo(string, new MediaLocator(string2), formatArray);
        CaptureDeviceManager.addDevice((CaptureDeviceInfo)serializable);
    }

    public static void main(String[] stringArray) {
        SunVideoAuto sunVideoAuto = new SunVideoAuto();
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

