/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.protocol.sunvideo.XILCapture;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class SunVideoManual
extends Frame {
    private static String DEVICE_PREFIX = "/dev/rtvc";
    private static String PROTOCOL = "sunvideo";
    private static String LOCATOR_PREFIX = PROTOCOL + "://";
    CaptureDeviceInfo[] devices = null;
    int currentID = -1;

    public SunVideoManual() {
        super("Register SunVideo Caputure Devices");
        this.setLayout(new FlowLayout());
        int n2 = 0;
        int n3 = 0;
        while (n3 < 7) {
            File file = new File(DEVICE_PREFIX + n3);
            if (file.exists()) {
                Button button = new Button(DEVICE_PREFIX + n3);
                this.add(button);
                button.addActionListener(new DBListener(n3));
                ++n2;
            }
            ++n3;
        }
        this.devices = new CaptureDeviceInfo[n2];
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (SunVideoManual.this.currentID != -1) {
                    System.err.println("Need to close other window first");
                    return;
                }
                SunVideoManual.this.dispose();
                System.exit(0);
            }
        });
    }

    public void createDialog(int n2) {
        if (this.currentID == n2) {
            return;
        }
        this.currentID = n2;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FormatsDialog formatsDialog = new FormatsDialog(SunVideoManual.this.currentID);
                ((Component)formatsDialog).setVisible(true);
                CaptureDeviceInfo captureDeviceInfo = formatsDialog.getDeviceInfo();
                if (captureDeviceInfo != null) {
                    System.err.println("CaptureDeviceInfo = " + captureDeviceInfo.getName() + " " + captureDeviceInfo.getLocator());
                }
                SunVideoManual.this.currentID = -1;
            }
        });
        thread.start();
    }

    public static void main(String[] stringArray) {
        SunVideoManual sunVideoManual = new SunVideoManual();
        ((Component)sunVideoManual).setVisible(true);
    }

    class DBListener
    implements ActionListener {
        int id;

        public DBListener(int n2) {
            this.id = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SunVideoManual.this.createDialog(this.id);
        }
    }

    class FormatsDialog
    extends Frame {
        int id;
        Button bVideoFormat;
        Button bDone;
        Button bCancel;
        CheckboxGroup cPortGroup;
        Checkbox cPort1;
        Checkbox cPort2;
        Checkbox cSvhs;
        Checkbox cRGB;
        Checkbox cJpeg;
        Checkbox cFull;
        Checkbox cHalf;
        Checkbox cQuarter;
        Vector formats = new Vector();
        XILCapture xilCap = null;
        Integer lock = new Integer(1);
        boolean finished = false;
        boolean needVideoFormat = false;
        static /* synthetic */ Class array$B;

        public FormatsDialog(int n2) {
            super("sunvideo " + DEVICE_PREFIX + n2);
            this.id = n2;
            this.setLayout(new BorderLayout());
            this.cPortGroup = new CheckboxGroup();
            this.cPort1 = new Checkbox("1", true, this.cPortGroup);
            this.cPort2 = new Checkbox("2", false, this.cPortGroup);
            this.cSvhs = new Checkbox("S-VHS", false, this.cPortGroup);
            this.cJpeg = new Checkbox("Jpeg", true);
            this.cRGB = new Checkbox("RGB", false);
            this.cFull = new Checkbox("1", false);
            this.cHalf = new Checkbox("1/2", true);
            this.cQuarter = new Checkbox("1/4", false);
            this.bVideoFormat = new Button("VideoFormat");
            this.bDone = new Button("Done");
            this.bCancel = new Button("Cancel");
            this.xilCap = new XILCapture(null);
            if (!this.xilCap.connect(n2)) {
                throw new Error("Unable to connect to device");
            }
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Port"));
            panel.add(this.cPort1);
            panel.add(this.cPort2);
            panel.add(this.cSvhs);
            this.add("North", panel);
            Panel panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Formats"));
            panel.add(this.cJpeg);
            panel.add(this.cRGB);
            panel2.add("North", panel);
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Sizes"));
            panel.add(this.cFull);
            panel.add(this.cHalf);
            panel.add(this.cQuarter);
            panel2.add("South", panel);
            this.add("Center", panel2);
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(this.bVideoFormat);
            panel.add(this.bDone);
            panel.add(this.bCancel);
            this.add("South", panel);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bDone.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bCancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bVideoFormat.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.needVideoFormat = true;
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.lock.notify();
                    }
                }
            });
        }

        private void addFormat(Format format) {
            Enumeration enumeration = this.formats.elements();
            while (enumeration.hasMoreElements()) {
                Format format2 = (Format)enumeration.nextElement();
                if (!format2.equals(format)) continue;
                return;
            }
            System.err.println("New format = " + format);
            this.formats.addElement(format);
        }

        public void mydispose() {
            this.xilCap.disconnect();
            this.dispose();
            System.err.println("Disconnected driver");
        }

        public void doVideoFormat() {
            Checkbox checkbox = this.cPortGroup.getSelectedCheckbox();
            int n2 = 1;
            if (checkbox == this.cPort1) {
                n2 = 1;
            } else if (checkbox == this.cPort2) {
                n2 = 2;
            } else if (checkbox == this.cSvhs) {
                n2 = 0;
            } else {
                System.err.println("No port specified");
                return;
            }
            if (!this.xilCap.setPort(n2)) {
                System.err.println("Video source not recognized on port");
                return;
            }
            if (this.cHalf.getState()) {
                this.xilCap.setScale(2);
                this.getFormats();
            }
            if (this.cQuarter.getState()) {
                this.xilCap.setScale(4);
                this.getFormats();
            }
            if (this.cFull.getState()) {
                this.xilCap.setScale(1);
                this.getFormats();
            }
        }

        private void getFormats() {
            if (this.cJpeg.getState()) {
                this.getJpegFormat();
            }
            if (this.cRGB.getState()) {
                this.getRGBFormat();
            }
        }

        private void getRGBFormat() {
            if (!this.xilCap.setCompress("RGB")) {
                return;
            }
            if (this.xilCap.start()) {
                Dimension dimension = new Dimension(this.xilCap.getWidth(), this.xilCap.getHeight());
                int n2 = this.xilCap.getLineStride();
                int n3 = n2 * dimension.width;
                this.addFormat(new RGBFormat(dimension, n3, array$B == null ? (array$B = FormatsDialog.class$("[B")) : array$B, 15.0f, 24, 3, 2, 1, 3, n2, 0, -1));
            }
            this.xilCap.stop();
        }

        private void getJpegFormat() {
            if (!this.xilCap.setCompress("Jpeg")) {
                return;
            }
            if (this.xilCap.start()) {
                Dimension dimension = new Dimension(this.xilCap.getWidth(), this.xilCap.getHeight());
                int n2 = 3 * dimension.width * dimension.height;
                this.addFormat(new VideoFormat("jpeg", dimension, n2, array$B == null ? (array$B = FormatsDialog.class$("[B")) : array$B, 15.0f));
            }
            this.xilCap.stop();
        }

        public CaptureDeviceInfo getDeviceInfo() {
            Serializable serializable;
            Object object;
            try {
                while (!this.finished) {
                    object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                    if (!this.needVideoFormat) continue;
                    this.needVideoFormat = false;
                    this.doVideoFormat();
                }
            }
            catch (InterruptedException interruptedException) {
                this.mydispose();
                return null;
            }
            object = "SunVideo device " + this.id;
            String string = LOCATOR_PREFIX + this.id;
            this.mydispose();
            if (this.formats == null || this.formats.size() < 1) {
                return null;
            }
            Format[] formatArray = new Format[this.formats.size()];
            Enumeration enumeration = this.formats.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                serializable = (Format)enumeration.nextElement();
                formatArray[n2++] = serializable;
            }
            serializable = CaptureDeviceManager.getDevice((String)object);
            if (serializable != null) {
                CaptureDeviceManager.removeDevice(serializable);
            }
            serializable = new CaptureDeviceInfo((String)object, new MediaLocator(string), formatArray);
            CaptureDeviceManager.addDevice(serializable);
            try {
                CaptureDeviceManager.commit();
                System.err.println("SunVideoManual: Committed ok");
            }
            catch (IOException iOException) {
                System.err.println("SunVideoManual: error committing cdm");
            }
            return serializable;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

