/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.dvi;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.dvi.DVI;
import com.ibm.media.codec.audio.dvi.DVIState;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private DVIState dviState;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("dvi/rtp")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "DVI Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.dviState = new DVIState();
    }

    public void close() {
        this.dviState = null;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2 = 0;
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n3 = this.outputFormat.getChannels();
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, (byArray.length - 4) * 4);
        int n4 = buffer.getOffset();
        int n5 = byArray[n4++] << 8;
        int n6 = n4++;
        int n7 = byArray[n4++] & 0xFF;
        this.dviState.valprev = n5 |= byArray[n6] & 0xFF;
        this.dviState.index = n7;
        DVI.decode(byArray, ++n4, byArray2, 0, 2 * (buffer.getLength() - 4), this.dviState);
        n2 = 4 * (buffer.getLength() - 4);
        this.updateOutput(buffer2, this.outputFormat, n2, 0);
        return 0;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

