/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.gsm.GsmEncoder;

public class GsmVadEncoder
extends GsmEncoder {
    private static final float DIST_TH = 0.05f;
    private static final int PITCH_TH = 4;
    private static final int PITCH_PRECISION = 2;
    private static final float PTH = 6.984919E-5f;
    private static final float MARGIN = 0.018626451f;
    private static final float PLEV = 1.8626451E-4f;
    private static final float FAC = 3.0f;
    private static final int ADP = 8;
    private static final float INC = 16.0f;
    private static final float DEC = 32.0f;
    private static final float EPSILON = 1.0E-15f;
    private static final int NEW_SID = -1;
    private static final float MAX_LAR = 1.625f;
    private static final int E_PTH = 19;
    private static final int M_PTH = 18750;
    private static final int E_MARGIN = 27;
    private static final int M_MARGIN = 19531;
    private static final int E_PLEV = 20;
    private static final int M_PLEV = 25000;
    public static final int UPDATE_RATE = 10;
    private static final int nFRAMES = 4;
    int vad_sincelastSID;
    int vad_sinceSPEECHburst;
    float[][] vad_prevLARs = new float[4][8];
    float[][] vad_prevxmax = new float[4][4];
    int[] vad_prevSID = new int[77];
    int vad_hangover;
    int vad_LARindex;
    boolean vad_SP;
    float[] vad_LAR = new float[8];
    float[] vad_currentxmax = new float[4];
    int vad_blocknumber;
    int vad_lastsent;
    boolean vad_prevSP;
    float[] vad_rvad = new float[9];
    float[][] vad_sacf = new float[3][9];
    float[][] vad_sav0 = new float[4][9];
    int vad_sacfPt;
    int vad_sav0Pt;
    float vad_lastdm;
    int vad_oldlagcount;
    int vad_veryoldlagcount;
    int vad_adaptcount;
    int vad_burstcount;
    int vad_hangcount;
    int vad_oldlag;
    float vad_thvad;
    float[] vadAux_av0 = new float[9];
    float[] vadAux_av1 = new float[9];
    float[] vadAux_refcoef = new float[9];
    float[] vadAux_rav1 = new float[9];
    float[] vadAux_coef = new float[9];
    float[] vadAux_tempcoef = new float[9];
    float[] vadAux_aav1 = new float[9];

    protected void doVAD() {
        this.vad_calculations();
        this.DisConTrans();
    }

    public void gsm_encoder_reset() {
        super.gsm_encoder_reset();
        this.vadSupportFlag = true;
        this.vad_sincelastSID = 24;
        this.vad_sinceSPEECHburst = 0;
        int n2 = 0;
        while (n2 < this.vad_prevLARs.length) {
            int n3 = 0;
            while (n3 < this.vad_prevLARs[n2].length) {
                this.vad_prevLARs[n2][n3] = 0.0f;
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.vad_prevxmax.length) {
            this.vad_prevxmax[n4][0] = 0.0f;
            this.vad_prevxmax[n4][1] = 0.0f;
            this.vad_prevxmax[n4][2] = 0.0f;
            this.vad_prevxmax[n4][3] = 0.0f;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.vad_prevSID.length) {
            this.vad_prevSID[n5] = 0;
            ++n5;
        }
        this.vad_prevSID[0] = 2;
        this.vad_prevSID[1] = 28;
        this.vad_prevSID[2] = 18;
        this.vad_prevSID[3] = 12;
        this.vad_prevSID[4] = 7;
        this.vad_prevSID[5] = 5;
        this.vad_prevSID[6] = 3;
        this.vad_prevSID[7] = 2;
        this.vad_hangover = 1;
        this.vad_LARindex = 0;
        this.vad_SP = true;
        this.vad_prevSP = true;
        this.vad_lastsent = 0;
        this.vad_rvad[0] = 6.0f;
        this.vad_rvad[1] = -4.0f;
        this.vad_rvad[2] = 1.0f;
        int n6 = 3;
        while (n6 < this.vad_rvad.length) {
            this.vad_rvad[n6] = 0.0f;
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.vad_sacf.length) {
            int n8 = 0;
            while (n8 < this.vad_sacf[n7].length) {
                this.vad_sacf[n7][n8] = 0.0f;
                ++n8;
            }
            ++n7;
        }
        int n9 = 0;
        while (n9 < this.vad_sav0.length) {
            int n10 = 0;
            while (n10 < this.vad_sav0[n9].length) {
                this.vad_sav0[n9][n10] = 0.0f;
                ++n10;
            }
            ++n9;
        }
        this.vad_sacfPt = 0;
        this.vad_sav0Pt = 0;
        this.vad_lastdm = 0.0f;
        this.vad_oldlagcount = 0;
        this.vad_veryoldlagcount = 0;
        this.vad_adaptcount = 0;
        this.vad_burstcount = 0;
        this.vad_hangcount = -1;
        this.vad_oldlag = 40;
        this.vad_thvad = 2.3283064E-4f;
    }

    void vad_calculations() {
        int[] nArray = GsmEncoder.lut_lg2s;
        boolean bl = this.VAD(this.data_acf, this.data_Nc);
        if (bl) {
            this.vad_sinceSPEECHburst = 0;
            this.vad_SP = true;
            this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
            int n2 = 0;
            while (n2 < 8) {
                this.vad_prevLARs[this.vad_LARindex][n2] = this.vad_LAR[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < 4) {
                this.vad_prevxmax[this.vad_LARindex][n2] = this.vad_currentxmax[n2];
                ++n2;
            }
            if (this.vad_sincelastSID < 24) {
                ++this.vad_sincelastSID;
            }
        } else {
            if (this.vad_sinceSPEECHburst++ == 0) {
                this.vad_hangover = this.vad_sincelastSID >= 24 ? 1 : 0;
            } else if (this.vad_sinceSPEECHburst > 4) {
                this.vad_hangover = -1;
            }
            if (this.vad_hangover == 1) {
                this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
                int n3 = 0;
                while (n3 < 8) {
                    this.vad_prevLARs[this.vad_LARindex][n3] = this.data_LAR[n3];
                    ++n3;
                }
                n3 = 0;
                while (n3 < 4) {
                    this.vad_prevxmax[this.vad_LARindex][n3] = this.vad_currentxmax[n3];
                    ++n3;
                }
                if (this.vad_sincelastSID < 24) {
                    ++this.vad_sincelastSID;
                }
                this.vad_SP = true;
            } else if (this.vad_hangover == 0) {
                this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
                int n4 = 0;
                while (n4 < 8) {
                    this.vad_prevLARs[this.vad_LARindex][n4] = this.data_LAR[n4];
                    ++n4;
                }
                n4 = 0;
                while (n4 < 4) {
                    this.vad_prevxmax[this.vad_LARindex][n4] = this.vad_currentxmax[n4];
                    ++n4;
                }
                n4 = 0;
                while (n4 < 77) {
                    this.data_Parameters[n4] = this.vad_prevSID[n4];
                    ++n4;
                }
                if (this.vad_sincelastSID < 24) {
                    ++this.vad_sincelastSID;
                }
                this.vad_SP = false;
            } else {
                int n5 = 1;
                while (n5 <= 8) {
                    float f2 = 0.25f * (this.vad_prevLARs[0][n5 - 1] + this.vad_prevLARs[1][n5 - 1] + this.vad_prevLARs[2][n5 - 1] + this.vad_prevLARs[3][n5 - 1]);
                    if ((f2 = GsmEncoder.lut_A[n5] * f2 + GsmEncoder.lut_B[n5]) > GsmEncoder.lut_MAC[n5]) {
                        f2 = GsmEncoder.lut_MAC[n5];
                    }
                    if (f2 < GsmEncoder.lut_MIC[n5]) {
                        f2 = GsmEncoder.lut_MIC[n5];
                    }
                    this.vad_prevSID[n5 - 1] = (int)(f2 - GsmEncoder.lut_MIC[n5] + 0.5f);
                    ++n5;
                }
                float f3 = 0.0f;
                n5 = 0;
                while (n5 < 4) {
                    int n6 = 0;
                    while (n6 < 4) {
                        f3 += this.vad_prevxmax[n6][n5];
                        ++n6;
                    }
                    ++n5;
                }
                if ((double)(f3 *= 0.0625f) < 0.015625) {
                    f3 *= 1024.0f;
                } else {
                    int n7 = (int)(32768.0 * (double)f3);
                    if ((n7 >>= 10) < 31) {
                        n5 = nArray[n7];
                        f3 = (float)(n5 << 3) + f3 * (float)(1024 >> n5);
                    } else {
                        f3 = 63.0f;
                    }
                }
                n5 = 0;
                while (n5 < 4) {
                    this.vad_prevSID[11 + 17 * n5] = (int)f3;
                    ++n5;
                }
                this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
                n5 = 0;
                while (n5 < 8) {
                    this.vad_prevLARs[this.vad_LARindex][n5] = this.data_LAR[n5];
                    ++n5;
                }
                n5 = 0;
                while (n5 < 4) {
                    this.vad_prevxmax[this.vad_LARindex][n5] = this.vad_currentxmax[n5];
                    ++n5;
                }
                n5 = 0;
                while (n5 < 77) {
                    this.data_Parameters[n5] = this.vad_prevSID[n5];
                    ++n5;
                }
                this.vad_sincelastSID = 0;
                this.vad_SP = false;
            }
        }
    }

    void DisConTrans() {
        boolean bl = false;
        if (this.vad_SP) {
            this.frameType = 0;
            bl = true;
        } else if (!this.vad_SP && this.vad_prevSP) {
            this.frameType = 1;
            bl = true;
        }
        this.vad_prevSP = this.vad_SP;
        if (bl) {
            this.vad_lastsent = 0;
        } else if (this.sidUpdateRate > 0 && ++this.vad_lastsent >= this.sidUpdateRate) {
            this.vad_lastsent = 0;
            bl = true;
            this.frameType = 1;
        } else {
            int n2 = 0;
            while (n2 < 77) {
                this.data_Parameters[n2] = 0;
                ++n2;
            }
            this.frameType = 2;
        }
    }

    boolean VAD(float[] fArray, int[] nArray) {
        float[] fArray2 = this.vadAux_av0;
        float[] fArray3 = this.vadAux_av1;
        float[] fArray4 = this.vadAux_refcoef;
        float[] fArray5 = this.vadAux_rav1;
        float f2 = this.adaptiveFiltering(fArray);
        this.ACFaverage(fArray, fArray2, fArray3);
        this.schurRecursion(fArray3, fArray4);
        this.Step_up(fArray4, fArray5);
        boolean bl = this.SpectralComp(fArray5, fArray2);
        boolean bl2 = this.PitchDetect();
        this.ThresAdapt(bl2, bl, fArray, fArray5, f2);
        boolean bl3 = this.vad_decision(f2);
        this.pitchCounting(nArray);
        return bl3;
    }

    float adaptiveFiltering(float[] fArray) {
        if (fArray[0] < 1.0E-15f) {
            float f2 = 0.0f;
            fArray[0] = 0.0f;
            return f2;
        }
        float f3 = 0.0f;
        int n2 = 1;
        while (n2 <= 8) {
            f3 += this.vad_rvad[n2] * fArray[n2];
            ++n2;
        }
        f3 = 2.0f * f3 + this.vad_rvad[0] * fArray[0];
        return f3;
    }

    void ACFaverage(float[] fArray, float[] fArray2, float[] fArray3) {
        int n2 = this.vad_sacfPt;
        int n3 = this.vad_sav0Pt;
        int n4 = 0;
        while (n4 <= 8) {
            fArray2[n4] = fArray[n4] + this.vad_sacf[0][n4] + this.vad_sacf[1][n4] + this.vad_sacf[2][n4];
            this.vad_sacf[n2][n4] = fArray[n4];
            fArray3[n4] = this.vad_sav0[n3][n4];
            this.vad_sav0[n3][n4] = fArray2[n4];
            ++n4;
        }
        this.vad_sacfPt = n2 == 2 ? 0 : n2 + 1;
        this.vad_sav0Pt = n3 == 3 ? 0 : n3 + 1;
    }

    void Step_up(float[] fArray, float[] fArray2) {
        int n2;
        float[] fArray3 = this.vadAux_coef;
        float[] fArray4 = this.vadAux_tempcoef;
        float[] fArray5 = this.vadAux_aav1;
        fArray3[0] = 1.0f;
        fArray3[1] = fArray[1];
        int n3 = 2;
        while (n3 < 9) {
            n2 = 1;
            while (n2 < n3) {
                fArray4[n2] = fArray3[n2] + fArray[n3] * fArray3[n3 - n2];
                ++n2;
            }
            n2 = 1;
            while (n2 < n3) {
                fArray3[n2] = fArray4[n2];
                ++n2;
            }
            fArray3[n3] = fArray[n3];
            ++n3;
        }
        n2 = 0;
        while (n2 <= 8) {
            fArray5[n2] = fArray3[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 <= 8) {
            fArray2[n2] = 0.0f;
            int n4 = 0;
            while (n4 <= 8 - n2) {
                fArray2[n2] = fArray2[n2] + fArray5[n4] * fArray5[n4 + n2];
                ++n4;
            }
            ++n2;
        }
    }

    boolean SpectralComp(float[] fArray, float[] fArray2) {
        float f2;
        if (fArray2[0] < 1.0E-15f) {
            f2 = 0.0f;
            int n2 = 1;
            while (n2 <= 8) {
                f2 += fArray[n2];
                ++n2;
            }
            f2 = 2.0f * f2 + fArray[0];
        } else {
            f2 = 0.0f;
            int n3 = 1;
            while (n3 <= 8) {
                f2 += fArray[n3] * fArray2[n3];
                ++n3;
            }
            f2 = 2.0f * f2 + fArray[0] * fArray2[0];
            f2 /= fArray2[0];
        }
        float f3 = f2 - this.vad_lastdm;
        boolean bl = f3 < 0.05f && f3 > -0.05f;
        this.vad_lastdm = f2;
        return bl;
    }

    boolean PitchDetect() {
        return this.vad_oldlagcount + this.vad_veryoldlagcount >= 4;
    }

    void ThresAdapt(boolean bl, boolean bl2, float[] fArray, float[] fArray2, float f2) {
        float f3 = this.vad_thvad;
        if (fArray[0] < 6.984919E-5f) {
            this.vad_thvad = 1.8626451E-4f;
            return;
        }
        if (bl || !bl2) {
            this.vad_adaptcount = 0;
            return;
        }
        if (++this.vad_adaptcount <= 8) {
            return;
        }
        float f4 = f2 * 3.0f;
        if ((f3 -= f3 / 32.0f) < f4 && f4 < (f3 += f3 / 16.0f)) {
            f3 = f4;
        }
        if (f3 > (f4 = f2 + 0.018626451f)) {
            f3 = f4;
        }
        this.vad_thvad = f3;
        int n2 = 0;
        while (n2 <= 8) {
            this.vad_rvad[n2] = fArray2[n2];
            ++n2;
        }
        this.vad_adaptcount = 9;
    }

    boolean vad_decision(float f2) {
        boolean bl;
        if (f2 > this.vad_thvad) {
            bl = true;
            ++this.vad_burstcount;
            if (this.vad_burstcount >= 3) {
                this.vad_hangcount = 5;
                this.vad_burstcount = 3;
            }
        } else {
            bl = false;
            this.vad_burstcount = 0;
        }
        if (this.vad_hangcount >= 0) {
            bl = true;
            --this.vad_hangcount;
        }
        return bl;
    }

    void pitchCounting(int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 <= 3) {
            int n4;
            int n5;
            if (this.vad_oldlag > nArray[n3]) {
                n5 = nArray[n3];
                n4 = this.vad_oldlag;
            } else {
                n5 = this.vad_oldlag;
                n4 = nArray[n3];
            }
            int n6 = n4 % n5;
            if (n6 < 2 || n5 - n6 < 2) {
                ++n2;
            }
            this.vad_oldlag = nArray[n3];
            ++n3;
        }
        this.vad_veryoldlagcount = this.vad_oldlagcount;
        this.vad_oldlagcount = n2;
    }
}

