/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.gsm.GsmDecoder;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    protected GsmDecoder decoder;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("gsm"), new AudioFormat("gsm/rtp")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "GSM Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.decoder = new GsmDecoder();
        this.decoder.decoderInit();
    }

    public void reset() {
        this.resetDecoder();
    }

    public void close() {
        this.freeDecoder();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = buffer.getLength();
        int n3 = this.calculateOutputSize(buffer.getLength());
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        this.decode(byArray, buffer.getOffset(), byArray2, 0, n2);
        this.updateOutput(buffer2, this.outputFormat, n3, 0);
        return 0;
    }

    protected void freeDecoder() {
        this.decoder = null;
    }

    protected void resetDecoder() {
        this.decoder.decoderInit();
    }

    protected int calculateOutputSize(int n2) {
        return n2 / 33 * 320;
    }

    protected void decode(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n4 / 33;
        int n6 = 1;
        while (n6 <= n5) {
            this.decoder.decodeFrame(byArray, n2, byArray2, n3);
            ++n6;
            n3 += 320;
            n2 += 33;
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, true, false);
        }
        return this.controls;
    }
}

