/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import com.sun.media.format.WavAudioFormat;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaEncoder_ms
extends BufferedEncoder {
    private IMA4State ima4stateL;
    private IMA4State ima4stateR;
    private int inputframeSizeInBytes = 1010;

    public JavaEncoder_ms() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new WavAudioFormat("ima4/ms")};
        this.PLUGIN_NAME = "IMA4 MS Encoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        int n2 = ((this.inputframeSizeInBytes - 2) * 2 + 32) * audioFormat.getChannels();
        int n3 = this.inputframeSizeInBytes / 2;
        this.supportedOutputFormats = new AudioFormat[]{new WavAudioFormat("ima4/ms", audioFormat.getSampleRate(), 4, audioFormat.getChannels(), n2, (int)audioFormat.getSampleRate() * 2 / 8 * n2 / this.inputframeSizeInBytes, -1, -1, -1.0f, Format.byteArray, new byte[]{(byte)(n3 & 0xFF), (byte)(n3 >> 8)})};
        this.historySize = this.inputframeSizeInBytes * audioFormat.getChannels();
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4stateL = new IMA4State();
        this.ima4stateR = new IMA4State();
    }

    public void close() {
        this.ima4stateL = null;
        this.ima4stateR = null;
    }

    public void codecReset() {
        this.ima4stateL.index = 0;
        this.ima4stateL.valprev = 0;
        this.ima4stateR.index = 0;
        this.ima4stateR.valprev = 0;
    }

    protected int calculateOutputSize(int n2) {
        return this.calculateFramesNumber(n2) * ((this.inputframeSizeInBytes - 4) * 4 + 2);
    }

    protected int calculateFramesNumber(int n2) {
        return n2 / this.inputframeSizeInBytes;
    }

    protected boolean codecProcess(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n5 = 0;
        int n6 = 0;
        int n7 = this.inputFormat.getChannels();
        boolean bl = n7 == 2;
        int n8 = bl ? 2 : 0;
        int n9 = n4 / (n7 * 1010);
        int n10 = this.inputframeSizeInBytes - 2 >> 1;
        nArray4[0] = n3;
        int n11 = 0;
        while (n11 < n9) {
            int n12 = byArray[n2 + n5++] & 0xFF;
            this.ima4stateL.valprev = n12 |= byArray[n2 + n5++] << 8;
            if (this.ima4stateL.index > 88) {
                this.ima4stateL.index = 88;
            } else if (this.ima4stateL.index < 0) {
                this.ima4stateL.index = 0;
            }
            byArray2[n3 + n6++] = (byte)n12;
            byArray2[n3 + n6++] = (byte)(n12 >> 8);
            byArray2[n3 + n6++] = (byte)this.ima4stateL.index;
            ++n6;
            if (bl) {
                n12 = byArray[n2 + n5++] & 0xFF;
                this.ima4stateR.valprev = n12 |= byArray[n2 + n5++] << 8;
                if (this.ima4stateR.index > 88) {
                    this.ima4stateR.index = 88;
                } else if (this.ima4stateR.index < 0) {
                    this.ima4stateR.index = 0;
                }
                byArray2[n3 + n6++] = (byte)n12;
                byArray2[n3 + n6++] = (byte)(n12 >> 8);
                byArray2[n3 + n6++] = (byte)this.ima4stateR.index;
                ++n6;
            }
            int n13 = 0;
            while (n13 < n10 / 8) {
                IMA4.encode(byArray, n5 + n2, byArray2, n6 + n3, 8, this.ima4stateL, n8);
                n6 += 4;
                if (bl) {
                    IMA4.encode(byArray, n5 + n2 + 2, byArray2, n6 + n3, 8, this.ima4stateR, n8);
                    n6 += 4;
                    n5 += 32;
                } else {
                    n5 += 16;
                }
                ++n13;
            }
            nArray4[n11 + 1] = n6 + n3;
            this.regionsTypes[n11] = 0;
            ++n11;
        }
        nArray[0] = n5;
        nArray2[0] = n6;
        nArray3[0] = n9;
        return true;
    }
}

