/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicClock;
import com.sun.media.ConfigureWorkThread;
import com.sun.media.CreateTimedThreadAction;
import com.sun.media.CreateWorkThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.PrefetchWorkThread;
import com.sun.media.RealizeWorkThread;
import com.sun.media.SendEventQueue;
import com.sun.media.StopTimeThread;
import com.sun.media.TimedStartThread;
import com.sun.media.util.jdk12;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.ConfigureCompleteEvent;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.Duration;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaTimeSetEvent;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;

public abstract class BasicController
implements Controller,
Duration {
    private int targetState = 100;
    protected int state = 100;
    private Vector listenerList = null;
    private SendEventQueue sendEvtQueue;
    private ConfigureWorkThread configureThread = null;
    private RealizeWorkThread realizeThread = null;
    private PrefetchWorkThread prefetchThread = null;
    protected String processError = null;
    private Clock clock;
    private TimedStartThread startThread = null;
    private StopTimeThread stopTimeThread = null;
    private boolean interrupted = false;
    private Object interruptSync = new Object();
    static final int Configuring = 140;
    static final int Configured = 180;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected boolean stopThreadEnabled = true;
    static String TimeBaseError;
    static String SyncStartError;
    static String StopTimeError;
    static String MediaTimeError;
    static String GetTimeBaseError;
    static String SetRateError;
    static String LatencyError;
    static String DeallocateError;
    static /* synthetic */ Class class$com$sun$media$SendEventQueue;
    static /* synthetic */ Class class$com$sun$media$BasicController;
    static /* synthetic */ Class class$com$sun$media$TimedStartThread;
    static /* synthetic */ Class class$com$sun$media$StopTimeThread;
    static /* synthetic */ Class class$com$sun$media$ConfigureWorkThread;
    static /* synthetic */ Class class$com$sun$media$RealizeWorkThread;
    static /* synthetic */ Class class$com$sun$media$PrefetchWorkThread;

    public BasicController() {
        Object object;
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = CreateWorkThreadAction.cons;
                this.sendEvtQueue = (SendEventQueue)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$SendEventQueue == null ? (class$com$sun$media$SendEventQueue = BasicController.class$("com.sun.media.SendEventQueue")) : class$com$sun$media$SendEventQueue, class$com$sun$media$BasicController == null ? (class$com$sun$media$BasicController = BasicController.class$("com.sun.media.BasicController")) : class$com$sun$media$BasicController, this));
                this.sendEvtQueue.setName(this.sendEvtQueue.getName() + ": SendEventQueue: " + this.getClass().getName());
                this.sendEvtQueue.start();
                this.clock = new BasicClock();
            }
            catch (Exception exception) {}
        } else {
            this.sendEvtQueue = new SendEventQueue(this);
            this.sendEvtQueue.setName(this.sendEvtQueue.getName() + ": SendEventQueue: " + this.getClass().getName());
            this.sendEvtQueue.start();
            this.clock = new BasicClock();
        }
    }

    protected abstract boolean isConfigurable();

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected void interrupt() {
        Object object = this.interruptSync;
        synchronized (object) {
            this.interrupted = true;
            this.interruptSync.notify();
        }
    }

    protected void resetInterrupt() {
        Object object = this.interruptSync;
        synchronized (object) {
            this.interrupted = false;
            this.interruptSync.notify();
        }
    }

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    protected boolean doConfigure() {
        return true;
    }

    protected void abortConfigure() {
    }

    protected abstract boolean doRealize();

    protected abstract void abortRealize();

    protected abstract boolean doPrefetch();

    protected abstract void abortPrefetch();

    protected abstract void doStart();

    protected void doStop() {
    }

    public final void close() {
        this.doClose();
        this.interrupt();
        if (this.startThread != null) {
            this.startThread.abort();
        }
        if (this.stopTimeThread != null) {
            this.stopTimeThread.abort();
        }
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.kill();
            this.sendEvtQueue = null;
        }
    }

    protected void doClose() {
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(TimeBaseError));
        }
        this.clock.setTimeBase(timeBase);
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public Control getControl(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Control[] controlArray = this.getControls();
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (clazz.isInstance(controlArray[n2])) {
                return controlArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public void syncStart(Time time) {
        Object object;
        if (this.state < 500) {
            this.throwError(new NotPrefetchedError(SyncStartError));
        }
        this.clock.syncStart(time);
        this.state = 600;
        this.setTargetState(600);
        this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), time));
        long l2 = this.checkStopTime();
        if (l2 < 0L || this.stopThreadEnabled && this.activateStopThread(l2)) {
            this.stopAtTime();
            return;
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = CreateTimedThreadAction.cons;
                this.startThread = (TimedStartThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$TimedStartThread == null ? (class$com$sun$media$TimedStartThread = BasicController.class$("com.sun.media.TimedStartThread")) : class$com$sun$media$TimedStartThread, class$com$sun$media$BasicController == null ? (class$com$sun$media$BasicController = BasicController.class$("com.sun.media.BasicController")) : class$com$sun$media$BasicController, this, new Long(time.getNanoseconds())));
                this.startThread.setName(this.startThread.getName() + " ( startThread: " + this + " )");
                this.startThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.startThread = new TimedStartThread(this, time.getNanoseconds());
            this.startThread.setName(this.startThread.getName() + " ( startThread: " + this + " )");
            this.startThread.start();
        }
    }

    protected boolean syncStartInProgress() {
        return this.startThread != null && this.startThread.isAlive();
    }

    private long checkStopTime() {
        long l2 = this.getStopTime().getNanoseconds();
        if (l2 == Long.MAX_VALUE) {
            return 1L;
        }
        return (long)((float)(l2 - this.getMediaTime().getNanoseconds()) / this.getRate());
    }

    private boolean activateStopThread(long l2) {
        if (this.getStopTime().getNanoseconds() == Long.MAX_VALUE) {
            return false;
        }
        if (this.stopTimeThread != null && this.stopTimeThread.isAlive()) {
            this.stopTimeThread.abort();
            this.stopTimeThread = null;
        }
        if (l2 > 100000000L) {
            Object object;
            if (jmfSecurity != null) {
                object = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        object = "thread";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        object = "thread group";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable throwable) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    object = CreateTimedThreadAction.cons;
                    this.stopTimeThread = (StopTimeThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$StopTimeThread == null ? (class$com$sun$media$StopTimeThread = BasicController.class$("com.sun.media.StopTimeThread")) : class$com$sun$media$StopTimeThread, class$com$sun$media$BasicController == null ? (class$com$sun$media$BasicController = BasicController.class$("com.sun.media.BasicController")) : class$com$sun$media$BasicController, this, new Long(l2)));
                    this.stopTimeThread.start();
                }
                catch (Exception exception) {}
            } else {
                this.stopTimeThread = new StopTimeThread(this, l2);
                this.stopTimeThread.start();
            }
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.state == 600 || this.state == 400) {
            this.stopControllerOnly();
            this.doStop();
        }
    }

    protected void stopControllerOnly() {
        if (this.state == 600 || this.state == 400) {
            this.clock.stop();
            this.state = 500;
            this.setTargetState(500);
            if (this.stopTimeThread != null && this.stopTimeThread.isAlive() && Thread.currentThread() != this.stopTimeThread) {
                this.stopTimeThread.abort();
            }
            if (this.startThread != null && this.startThread.isAlive()) {
                this.startThread.abort();
            }
        }
    }

    protected void stopAtTime() {
        this.stop();
        this.setStopTime(Clock.RESET);
        this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    public void setStopTime(Time time) {
        long l2;
        if (this.state < 300) {
            this.throwError(new NotRealizedError(StopTimeError));
        }
        Time time2 = this.getStopTime();
        this.clock.setStopTime(time);
        boolean bl = false;
        if (this.state == 600 && ((l2 = this.checkStopTime()) < 0L || this.stopThreadEnabled && this.activateStopThread(l2))) {
            bl = true;
        }
        if (time2.getNanoseconds() != time.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, time));
        }
        if (bl) {
            this.stopAtTime();
        }
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public void setMediaTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(MediaTimeError));
        }
        this.clock.setMediaTime(time);
        this.doSetMediaTime(time);
        this.sendEvent(new MediaTimeSetEvent(this, time));
    }

    protected void doSetMediaTime(Time time) {
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public TimeBase getTimeBase() {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(GetTimeBaseError));
        }
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return this.clock.mapToTimeBase(time);
    }

    public float setRate(float f2) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(SetRateError));
        }
        float f3 = this.getRate();
        float f4 = this.doSetRate(f2);
        float f5 = this.clock.setRate(f4);
        if (f5 != f3) {
            this.sendEvent(new RateChangeEvent(this, f5));
        }
        return f5;
    }

    protected float doSetRate(float f2) {
        return f2;
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public final int getState() {
        return this.state;
    }

    protected final void setTargetState(int n2) {
        this.targetState = n2;
    }

    public final int getTargetState() {
        return this.targetState;
    }

    public Time getStartLatency() {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(LatencyError));
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    protected void setMediaLength(long l2) {
        if (this.clock instanceof BasicClock) {
            ((BasicClock)this.clock).setMediaLength(l2);
        }
    }

    public synchronized void configure() {
        if (this.getTargetState() < 180) {
            this.setTargetState(180);
        }
        switch (this.state) {
            case 180: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new ConfigureCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: {
                break;
            }
            case 100: {
                Object object;
                this.state = 140;
                this.sendEvent(new TransitionEvent(this, 100, 140, this.getTargetState()));
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = CreateWorkThreadAction.cons;
                        this.configureThread = (ConfigureWorkThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$ConfigureWorkThread == null ? (class$com$sun$media$ConfigureWorkThread = BasicController.class$("com.sun.media.ConfigureWorkThread")) : class$com$sun$media$ConfigureWorkThread, class$com$sun$media$BasicController == null ? (class$com$sun$media$BasicController = BasicController.class$("com.sun.media.BasicController")) : class$com$sun$media$BasicController, this));
                        this.configureThread.setName(this.configureThread.getName() + "[ " + this + " ]" + " ( configureThread)");
                        this.configureThread.start();
                    }
                    catch (Exception exception) {}
                    break;
                }
                this.configureThread = new ConfigureWorkThread(this);
                this.configureThread.setName(this.configureThread.getName() + "[ " + this + " ]" + " ( configureThread)");
                this.configureThread.start();
            }
        }
    }

    protected synchronized void completeConfigure() {
        this.state = 180;
        this.sendEvent(new ConfigureCompleteEvent(this, 140, 180, this.getTargetState()));
        if (this.getTargetState() >= 300) {
            this.realize();
        }
    }

    protected void doFailedConfigure() {
        this.state = 100;
        this.setTargetState(100);
        String string = "Failed to configure";
        if (this.processError != null) {
            string = string + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, string));
        this.processError = null;
    }

    public final synchronized void realize() {
        if (this.getTargetState() < 300) {
            this.setTargetState(300);
        }
        switch (this.state) {
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new RealizeCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: 
            case 200: {
                break;
            }
            case 100: {
                if (this.isConfigurable()) {
                    this.configure();
                    break;
                }
            }
            case 180: {
                Object object;
                int n2 = this.state;
                this.state = 200;
                this.sendEvent(new TransitionEvent(this, n2, 200, this.getTargetState()));
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = CreateWorkThreadAction.cons;
                        this.realizeThread = (RealizeWorkThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$RealizeWorkThread == null ? (class$com$sun$media$RealizeWorkThread = BasicController.class$("com.sun.media.RealizeWorkThread")) : class$com$sun$media$RealizeWorkThread, class$com$sun$media$BasicController == null ? (class$com$sun$media$BasicController = BasicController.class$("com.sun.media.BasicController")) : class$com$sun$media$BasicController, this));
                        this.realizeThread.setName(this.realizeThread.getName() + "[ " + this + " ]" + " ( realizeThread)");
                        this.realizeThread.start();
                    }
                    catch (Exception exception) {}
                    break;
                }
                this.realizeThread = new RealizeWorkThread(this);
                this.realizeThread.setName(this.realizeThread.getName() + "[ " + this + " ]" + " ( realizeThread)");
                this.realizeThread.start();
            }
        }
    }

    protected synchronized void completeRealize() {
        this.state = 300;
        this.sendEvent(new RealizeCompleteEvent(this, 200, 300, this.getTargetState()));
        if (this.getTargetState() >= 500) {
            this.prefetch();
        }
    }

    protected void doFailedRealize() {
        this.state = 100;
        this.setTargetState(100);
        String string = "Failed to realize";
        if (this.processError != null) {
            string = string + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, string));
        this.processError = null;
    }

    public final void prefetch() {
        if (this.getTargetState() <= 300) {
            this.setTargetState(500);
        }
        switch (this.state) {
            case 500: 
            case 600: {
                this.sendEvent(new PrefetchCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: 
            case 200: 
            case 400: {
                break;
            }
            case 100: 
            case 180: {
                this.realize();
                break;
            }
            case 300: {
                Object object;
                this.state = 400;
                this.sendEvent(new TransitionEvent(this, 300, 400, this.getTargetState()));
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = CreateWorkThreadAction.cons;
                        this.prefetchThread = (PrefetchWorkThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$PrefetchWorkThread == null ? (class$com$sun$media$PrefetchWorkThread = BasicController.class$("com.sun.media.PrefetchWorkThread")) : class$com$sun$media$PrefetchWorkThread, class$com$sun$media$BasicController == null ? (class$com$sun$media$BasicController = BasicController.class$("com.sun.media.BasicController")) : class$com$sun$media$BasicController, this));
                        this.prefetchThread.setName(this.prefetchThread.getName() + "[ " + this + " ]" + " ( prefetchThread)");
                        this.prefetchThread.start();
                    }
                    catch (Exception exception) {}
                    break;
                }
                this.prefetchThread = new PrefetchWorkThread(this);
                this.prefetchThread.setName(this.prefetchThread.getName() + " ( prefetchThread)");
                this.prefetchThread.start();
            }
        }
    }

    protected void completePrefetch() {
        this.clock.stop();
        this.state = 500;
        this.sendEvent(new PrefetchCompleteEvent(this, 400, 500, this.getTargetState()));
    }

    protected void doFailedPrefetch() {
        this.state = 300;
        this.setTargetState(300);
        String string = "Failed to prefetch";
        if (this.processError != null) {
            string = string + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, string));
        this.processError = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void deallocate() {
        int n2 = this.getState();
        if (this.state == 600) {
            this.throwError(new ClockStartedError(DeallocateError));
        }
        switch (this.state) {
            case 140: 
            case 200: {
                this.interrupt();
                this.state = 100;
                break;
            }
            case 400: {
                this.interrupt();
                this.state = 300;
                break;
            }
            case 500: {
                this.abortPrefetch();
                this.state = 300;
                this.resetInterrupt();
                break;
            }
        }
        this.setTargetState(this.state);
        this.doDeallocate();
        Object object = this.interruptSync;
        synchronized (object) {
            while (this.isInterrupted()) {
                try {
                    this.interruptSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.sendEvent(new DeallocateEvent(this, n2, this.state, this.state, this.getMediaTime()));
    }

    protected void doDeallocate() {
    }

    public final void addControllerListener(ControllerListener controllerListener) {
        if (this.listenerList == null) {
            this.listenerList = new Vector();
        }
        Vector vector = this.listenerList;
        synchronized (vector) {
            if (!this.listenerList.contains(controllerListener)) {
                this.listenerList.addElement(controllerListener);
            }
        }
    }

    public final void removeControllerListener(ControllerListener controllerListener) {
        if (this.listenerList == null) {
            return;
        }
        Vector vector = this.listenerList;
        synchronized (vector) {
            if (this.listenerList != null) {
                this.listenerList.removeElement(controllerListener);
            }
        }
    }

    protected final void sendEvent(ControllerEvent controllerEvent) {
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.postEvent(controllerEvent);
        }
    }

    protected final void dispatchEvent(ControllerEvent controllerEvent) {
        if (this.listenerList == null) {
            return;
        }
        Vector vector = this.listenerList;
        synchronized (vector) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                ControllerListener controllerListener = (ControllerListener)enumeration.nextElement();
                controllerListener.controllerUpdate(controllerEvent);
            }
        }
    }

    protected void throwError(Error error) {
        Log.dumpStack(error);
        throw error;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        TimeBaseError = "Cannot set time base on an unrealized controller.";
        SyncStartError = "Cannot start the controller before it has been prefetched.";
        StopTimeError = "Cannot set stop time on an unrealized controller.";
        MediaTimeError = "Cannot set media time on a unrealized controller";
        GetTimeBaseError = "Cannot get Time Base from an unrealized controller";
        SetRateError = "Cannot set rate on an unrealized controller.";
        LatencyError = "Cannot get start latency from an unrealized controller";
        DeallocateError = "deallocate cannot be used on a started controller.";
    }
}

