/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicFilterModule;
import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicRendererModule;
import com.sun.media.BasicSourceModule;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.Module;
import com.sun.media.OutputConnector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Controls;
import javax.media.Format;
import javax.media.PlugIn;

public final class BasicJMD
extends Panel
implements JMD,
WindowListener {
    Vector modList = new Vector();
    Vector conList = new Vector();
    boolean graphic = true;
    Panel center;
    Label status;
    Frame frame = null;
    boolean activated = false;
    Button button = null;
    Dimension preferredSize = new Dimension(512, 140);
    int ro;
    int col;
    int colMax = 1;
    int roMax = 1;
    int wrapWidth = 200;
    int wrapHeight = 50;
    int offX = 0;
    int offY = 0;
    int fill = 10;
    int cSize = 10;

    public BasicJMD(String string) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.center = new Panel(){

            public Dimension getPreferredSize() {
                return BasicJMD.this.preferredSize;
            }
        };
        this.center.setLayout(null);
        this.add("North", this.center);
        this.status = new Label();
        this.add("South", this.status);
        this.setSize(512, 200);
    }

    public Component getControlComponent() {
        if (this.button == null) {
            this.button = new Button("PlugIn Viewer"){

                public void removeNotify() {
                    super.removeNotify();
                    BasicJMD.this.dispose();
                }
            };
            this.button.setName("PlugIns");
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BasicJMD.this.setVisible(true);
                }
            });
        }
        return this.button;
    }

    public synchronized void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public synchronized void setVisible(boolean bl) {
        if (this.getParent() == null) {
            if (bl && this.frame == null) {
                this.frame = new Frame("PlugIn Viewer");
                this.frame.setLayout(new BorderLayout());
                this.frame.add("Center", this);
                this.frame.addWindowListener(this);
                this.frame.pack();
                ((Component)this.frame).setVisible(true);
            }
        } else if (this.getParent() == this.frame) {
            ((Component)this.frame).setVisible(bl);
        } else {
            super.setVisible(bl);
        }
    }

    public void initGraph(BasicModule basicModule) {
        this.center.removeAll();
        this.modList = new Vector();
        this.conList = new Vector();
        this.drawGraph(basicModule);
        this.ro = 0;
        this.col = 0;
        this.preferredSize = new Dimension((this.colMax + 1) * this.wrapWidth + this.offX * 2, this.roMax * this.wrapHeight + this.offY * 2);
    }

    public void drawGraph(BasicModule basicModule) {
        String[] stringArray = basicModule.getOutputConnectorNames();
        int n2 = stringArray.length;
        if (n2 == 0) {
            n2 = 1;
        }
        this.createModuleWrap(basicModule, this.ro, this.col, n2);
        if (this.roMax < stringArray.length) {
            this.roMax = stringArray.length;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            OutputConnector outputConnector = basicModule.getOutputConnector(stringArray[n3]);
            InputConnector inputConnector = outputConnector.getInputConnector();
            if (inputConnector == null) {
                if (this.col == 0) {
                    ++this.ro;
                }
            } else {
                Module module = inputConnector.getModule();
                if (module == null) {
                    if (this.col == 0) {
                        ++this.ro;
                    }
                } else {
                    ++this.col;
                    if (this.col > this.colMax) {
                        this.colMax = this.col;
                    }
                    this.drawGraph((BasicModule)module);
                    --this.col;
                    if (this.col == 0) {
                        ++this.ro;
                    }
                }
            }
            ++n3;
        }
    }

    public void createModuleWrap(BasicModule basicModule, int n2, int n3, int n4) {
        Controls controls = basicModule;
        if (basicModule instanceof BasicSourceModule) {
            controls = ((BasicSourceModule)basicModule).getDemultiplexer();
        } else if (basicModule instanceof BasicFilterModule) {
            controls = ((BasicFilterModule)basicModule).getCodec();
        } else if (basicModule instanceof BasicRendererModule) {
            controls = ((BasicRendererModule)basicModule).getRenderer();
        } else if (basicModule instanceof BasicMuxModule) {
            controls = ((BasicMuxModule)basicModule).getMultiplexer();
        }
        String string = ((PlugIn)controls).getName();
        ModButton modButton = new ModButton(string, basicModule, (PlugIn)controls);
        modButton.setName("M" + basicModule.hashCode());
        this.modList.addElement(modButton);
        modButton.setBackground(new Color(192, 192, 128));
        modButton.setForeground(Color.black);
        this.center.add(modButton);
        modButton.setBounds(this.offX + n3 * this.wrapWidth + this.fill, this.offY + n2 * this.wrapHeight + this.fill, this.wrapWidth - this.fill * 2, n4 * this.wrapHeight - this.fill * 2);
        modButton.setVisible(true);
        this.center.invalidate();
    }

    public void moduleIn(BasicModule basicModule, int n2, Buffer buffer, boolean bl) {
        this.updateConnector(basicModule, n2, buffer, bl, 0);
    }

    public void updateConnector(BasicModule basicModule, int n2, Buffer buffer, boolean bl, int n3) {
        if (!this.activated) {
            return;
        }
        Con con = this.findConnector(basicModule, n2, n3);
        if (con == null) {
            return;
        }
        con.setData(buffer);
        if (bl) {
            if (buffer.isEOM()) {
                con.flash(Color.red);
            } else if (buffer.isDiscard()) {
                con.flash(Color.yellow);
            } else {
                con.flash(Color.green);
            }
        } else {
            con.flash(Color.gray);
        }
    }

    public void moduleOut(BasicModule basicModule, int n2, Buffer buffer, boolean bl) {
        this.updateConnector(basicModule, n2, buffer, bl, 1);
    }

    public Con findConnector(BasicModule basicModule, int n2, int n3) {
        Component component;
        String string = "C" + basicModule.hashCode() + n2 + n3;
        Enumeration enumeration = this.conList.elements();
        while (enumeration.hasMoreElements()) {
            component = (Con)enumeration.nextElement();
            if (!component.getName().equals(string)) continue;
            return component;
        }
        component = this.findModule(basicModule);
        if (component == null) {
            return null;
        }
        Point point = component.getLocation();
        Con con = new Con();
        this.center.add(con);
        con.setBounds(point.x - this.fill + (this.wrapWidth - this.fill) * n3, point.y + (this.wrapHeight - 2 * this.fill - this.cSize) / 2 + this.wrapHeight * n2, this.cSize, this.cSize);
        con.setName(string);
        this.conList.addElement(con);
        return con;
    }

    public Component findModule(BasicModule basicModule) {
        String string = "M" + basicModule.hashCode();
        Enumeration enumeration = this.modList.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.getName().equals(string)) continue;
            return component;
        }
        return null;
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.activated = true;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.activated = false;
    }

    class Con
    extends Button {
        Graphics g = null;
        Buffer data = null;
        boolean mouseHere = false;

        public Con() {
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Con this$1;
                {
                    this.this$1 = con;
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.updateStatus();
                    this.this$1.mouseHere = true;
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.mouseHere = false;
                }
            });
        }

        public void flash(Color color) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setColor(color);
            graphics.fillRect(1, 1, BasicJMD.this.cSize - 2, BasicJMD.this.cSize - 2);
        }

        public Graphics getGraphics() {
            this.g = super.getGraphics();
            return this.g;
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, BasicJMD.this.cSize - 1, BasicJMD.this.cSize - 1);
            graphics.setColor(Color.gray);
            graphics.fillRect(1, 1, BasicJMD.this.cSize - 2, BasicJMD.this.cSize - 2);
        }

        public void setData(Buffer buffer) {
            if (this.mouseHere) {
                this.updateStatus();
            }
            this.data = buffer;
        }

        void updateStatus() {
            Format format = this.data.getFormat();
            String string = format == null ? "null" : format.toString();
            BasicJMD.this.status.setText(string + ", Length = " + this.data.getLength());
        }
    }

    class ModButton
    extends Button {
        BasicModule module;
        boolean mouseHere = false;
        PlugIn plugin;

        public String cropName(String string) {
            String string2;
            int n2 = 120;
            FontMetrics fontMetrics = this.getFontMetrics(new Font("Dialog", 0, 11));
            int n3 = fontMetrics.stringWidth(string2 = string);
            boolean bl = n3 > n2;
            while (n3 > n2) {
                int n4 = string2.length();
                string2 = string.substring(0, n4 - 1);
                n3 = fontMetrics.stringWidth(string2);
            }
            if (bl) {
                string2 = string2 + "...";
            }
            return string2;
        }

        public ModButton(String string, BasicModule basicModule, PlugIn plugIn) {
            string = this.cropName(string);
            super.setLabel(string);
            this.module = basicModule;
            this.plugin = plugIn;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ModButton this$1;
                {
                    this.this$1 = modButton;
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.updateStatus();
                    this.this$1.mouseHere = true;
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.mouseHere = false;
                }
            });
        }

        public void updateStatus() {
            BasicJMD.this.status.setText(this.plugin.getClass().getName() + " , " + this.plugin.getName());
        }
    }
}

