/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicSourceModule;
import com.sun.media.Log;
import com.sun.media.MyOutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.rtp.util.RTPTimeBase;
import com.sun.media.util.LoopThread;
import javax.media.Buffer;
import javax.media.Track;
import javax.media.TrackListener;

class SourceThread
extends LoopThread
implements TrackListener {
    BasicSourceModule bsm;
    int index = 0;
    protected MyOutputConnector oc;
    protected boolean readBlocked = false;
    protected boolean checkLatency = false;
    protected boolean resetted = false;
    long sequenceNum = 0L;
    static int remapTimeFlag = 4480;
    protected long lastRelativeTime = -1L;
    long currentTime = 0L;
    long counter = 0L;

    public SourceThread(BasicSourceModule basicSourceModule, MyOutputConnector myOutputConnector, int n2) {
        this.bsm = basicSourceModule;
        this.oc = myOutputConnector;
        this.index = n2;
        this.setName(this.getName() + ": " + myOutputConnector.track);
        myOutputConnector.track.setTrackListener(this);
    }

    public synchronized void start() {
        super.start();
        this.lastRelativeTime = -1L;
    }

    public void readHasBlocked(Track track) {
        this.readBlocked = true;
        if (this.bsm.moduleListener != null) {
            this.bsm.moduleListener.dataBlocked(this.bsm, true);
        }
    }

    protected boolean process() {
        Buffer buffer;
        block31: {
            this.readBlocked = false;
            buffer = this.oc.getEmptyBuffer();
            if (PlaybackEngine.DEBUG) {
                this.bsm.jmd.moduleOut(this.bsm, this.index, buffer, true);
            }
            buffer.setOffset(0);
            buffer.setLength(0);
            buffer.setFlags(0);
            buffer.setSequenceNumber(this.sequenceNum++);
            if (this.resetted) {
                Object object = this.bsm.resetSync;
                synchronized (object) {
                    if (this.resetted) {
                        buffer.setFlags(512);
                        this.resetted = false;
                        this.pause();
                        if (this.bsm.checkAllPaused()) {
                            this.bsm.parser.stop();
                            this.bsm.parser.reset();
                        }
                        if (PlaybackEngine.DEBUG) {
                            this.bsm.jmd.moduleOut(this.bsm, this.index, buffer, false);
                        }
                        this.oc.writeReport();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            try {
                this.oc.track.readFrame(buffer);
            }
            catch (Throwable throwable) {
                Log.dumpStack(throwable);
                if (this.bsm.moduleListener == null) break block31;
                this.bsm.moduleListener.internalErrorOccurred(this.bsm);
            }
        }
        if (PlaybackEngine.TRACE_ON && !this.bsm.verifyBuffer(buffer)) {
            System.err.println("verify buffer failed: " + this.oc.track);
            Thread.dumpStack();
            if (this.bsm.moduleListener != null) {
                this.bsm.moduleListener.internalErrorOccurred(this.bsm);
            }
        }
        if (buffer.getTimeStamp() != -1L && (buffer.getFlags() & remapTimeFlag) != 0) {
            boolean bl = true;
            if ((buffer.getFlags() & 0x80) != 0) {
                bl = this.remapSystemTime(buffer);
            } else if ((buffer.getFlags() & 0x100) != 0) {
                bl = this.remapRelativeTime(buffer);
            } else if ((buffer.getFlags() & 0x1000) != 0) {
                bl = this.remapRTPTime(buffer);
            }
            if (!bl) {
                buffer.setDiscard(true);
                this.oc.writeReport();
                return true;
            }
        }
        if (this.checkLatency) {
            buffer.setFlags(buffer.getFlags() | 0x400);
            if (this.bsm.moduleListener != null) {
                this.bsm.moduleListener.markedDataArrived(this.bsm, buffer);
            }
            this.checkLatency = false;
        } else {
            buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
        }
        if (this.readBlocked && this.bsm.moduleListener != null) {
            this.bsm.moduleListener.dataBlocked(this.bsm, false);
        }
        if (buffer.isEOM()) {
            Object object = this.bsm.resetSync;
            synchronized (object) {
                if (!this.resetted) {
                    this.pause();
                    if (this.bsm.checkAllPaused()) {
                        this.bsm.parser.stop();
                    }
                }
            }
        } else {
            this.bsm.bitsRead += (long)buffer.getLength();
        }
        if (PlaybackEngine.DEBUG) {
            this.bsm.jmd.moduleOut(this.bsm, this.index, buffer, false);
        }
        this.oc.writeReport();
        return true;
    }

    private boolean remapRelativeTime(Buffer buffer) {
        buffer.setFlags(buffer.getFlags() & 0xFFFFFEFF | 0x60);
        return true;
    }

    private boolean remapSystemTime(Buffer buffer) {
        if (!this.bsm.started) {
            return false;
        }
        long l2 = buffer.getTimeStamp() - this.bsm.lastSystemTime;
        if (l2 < 0L) {
            return false;
        }
        this.bsm.currentSystemTime = this.bsm.originSystemTime + l2;
        buffer.setTimeStamp(this.bsm.currentSystemTime);
        buffer.setFlags(buffer.getFlags() & 0xFFFFFF7F | 0x60);
        return true;
    }

    private boolean remapRTPTime(Buffer buffer) {
        long l2;
        if (buffer.getTimeStamp() <= 0L) {
            buffer.setTimeStamp(-1L);
            return true;
        }
        if (this.bsm.cname == null) {
            this.bsm.cname = this.bsm.engine.getCNAME();
            if (this.bsm.cname == null) {
                buffer.setTimeStamp(-1L);
                return true;
            }
        }
        if (this.bsm.rtpOffsetInvalid) {
            if (this.bsm.rtpMapperUpdatable == null) {
                this.bsm.rtpMapperUpdatable = RTPTimeBase.getMapperUpdatable(this.bsm.cname);
                if (this.bsm.rtpMapperUpdatable == null) {
                    this.bsm.rtpOffsetInvalid = false;
                }
            }
            if (this.bsm.rtpMapperUpdatable != null) {
                this.bsm.rtpMapperUpdatable.setOrigin(this.bsm.currentRTPTime);
                this.bsm.rtpMapperUpdatable.setOffset(buffer.getTimeStamp());
                this.bsm.rtpOffsetInvalid = false;
            }
        }
        if (this.bsm.rtpMapper == null) {
            this.bsm.rtpMapper = RTPTimeBase.getMapper(this.bsm.cname);
        }
        if (this.bsm.rtpMapper.getOffset() != this.bsm.oldOffset) {
            this.bsm.oldOffset = this.bsm.rtpMapper.getOffset();
        }
        if ((l2 = buffer.getTimeStamp() - this.bsm.rtpMapper.getOffset()) < 0L) {
            if (this.bsm.rtpMapperUpdatable != null) {
                this.bsm.rtpOffsetInvalid = true;
            } else {
                l2 = 0L;
            }
        }
        this.bsm.currentRTPTime = this.bsm.rtpMapper.getOrigin() + l2;
        buffer.setTimeStamp(this.bsm.currentRTPTime);
        return true;
    }
}

