/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepakpro;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeEncoder
extends BasicCodec {
    private RGBFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private static boolean loaded = false;
    private static boolean canLoad = true;
    private int peer = 0;
    private boolean newframe = true;
    private int current_offset = 0;
    int returnVal = 0;
    private boolean bCcontextAllocated = false;
    private Control[] controls = null;
    private DC dc = null;

    public NativeEncoder() {
        this.inputFormats = new RGBFormat[1];
        this.inputFormats[0] = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255);
        this.outputFormats = new VideoFormat[1];
        this.outputFormats[0] = new VideoFormat("cvid");
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(format)) {
            return new Format[0];
        }
        Format[] formatArray = new Format[]{this.computeOutputFormat(format)};
        return formatArray;
    }

    private boolean verifyInputFormat(Format format) {
        if (!(format instanceof RGBFormat)) {
            return false;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        return rGBFormat.getBitsPerPixel() == 32 && rGBFormat.getRedMask() == 0xFF0000 && rGBFormat.getGreenMask() == 65280 && rGBFormat.getBlueMask() == 255 && rGBFormat.getSize() != null && rGBFormat.getLineStride() >= rGBFormat.getSize().width && rGBFormat.getPixelStride() == 1;
    }

    public Format setInputFormat(Format format) {
        if (!this.verifyInputFormat(format)) {
            return null;
        }
        this.inputFormat = (RGBFormat)format;
        return this.inputFormat;
    }

    public Format setOutputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)format;
        return this.outputFormat;
    }

    private final VideoFormat computeOutputFormat(Format format) {
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n2 = dimension.width * dimension.height * 3;
        VideoFormat videoFormat = new VideoFormat("cvid", dimension, n2, Format.byteArray, rGBFormat.getFrameRate());
        return videoFormat;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native CinepakPro converter");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmfCVIDPro");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native cinepak encoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on the cinepak encoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        Dimension dimension = this.inputFormat.getSize();
        try {
            this.peer = this.initCinepakEncoder(dimension.width, dimension.height, this.inputFormat.getLineStride(), this.inputFormat.getBitsPerPixel(), 9, 300000, 1000.0 / (double)this.inputFormat.getFrameRate(), 30, false, false, false, 2.1, false, 3500, 13);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize cinepak encoder");
        }
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeCinepakEncoder(this.peer);
        }
        this.peer = 0;
    }

    public void reset() {
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        boolean bl;
        Object var3_3 = null;
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        Format format = buffer.getFormat();
        Format format2 = buffer2.getFormat();
        int[] nArray = (int[])buffer.getData();
        boolean bl2 = bl = ((RGBFormat)format).getFlipped() == 1;
        if (this.outputFormat.getEncoding().equals("cvid")) {
            byte[] byArray = (byte[])buffer2.getData();
            if (byArray == null || byArray.length < this.outputFormat.getMaxDataLength()) {
                byArray = new byte[this.outputFormat.getMaxDataLength()];
                buffer2.setData(byArray);
            }
            if (format2 == null) {
                buffer2.setFormat(this.outputFormat);
            }
            if (this.peer == 0) {
                try {
                    this.open();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    return 1;
                }
            }
            Dimension dimension = this.inputFormat.getSize();
            this.returnVal = this.encodeCinepakFrame(this.peer, nArray, 0, byArray);
            if (this.returnVal > 0) {
                buffer2.setLength(this.returnVal);
                buffer2.setOffset(0);
                buffer.setLength(0);
                buffer2.setTimeStamp(buffer.getTimeStamp());
                if (this.wasKeyFrame(this.peer)) {
                    buffer2.setFlags(16);
                } else {
                    buffer2.setFlags(buffer2.getFlags() & 0xFFFFFFEF);
                }
                return 0;
            }
            buffer2.setDiscard(true);
            return 1;
        }
        return 1;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "CinepakPro Encoder by CTi";
    }

    private native int initCinepakEncoder(int var1, int var2, int var3, int var4, int var5, int var6, double var7, int var9, boolean var10, boolean var11, boolean var12, double var13, boolean var15, int var16, int var17);

    private native int encodeCinepakFrame(int var1, int[] var2, int var3, byte[] var4);

    private native boolean wasKeyFrame(int var1);

    private native int freeCinepakEncoder(int var1);

    public Object[] getControls() {
        if (this.dc == null) {
            this.dc = new DC();
            this.controls = new Control[1];
            this.controls[0] = this.dc;
        }
        return this.controls;
    }

    class DC
    implements FrameProcessingControl,
    QualityControl {
        DC() {
        }

        public int getFramesDropped() {
            return 0;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean setMinimalProcessing(boolean bl) {
            return false;
        }

        public void setFramesBehind(float f2) {
        }

        public float setQuality(float f2) {
            return 1.0f;
        }

        public float getQuality() {
            return 1.0f;
        }

        public float getPreferredQuality() {
            return 1.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return true;
        }
    }
}

