/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.codec.video.jpeg.NativeEncoder;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeDecoder
extends BasicCodec {
    private VideoFormat inputFormat = null;
    private RGBFormat outputFormat = null;
    private static boolean loaded = false;
    private static boolean canLoad = true;
    private int peer = 0;
    int returnVal = 0;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private int decimation = -1;

    public NativeDecoder() {
        this.inputFormats = new VideoFormat[2];
        this.inputFormats[0] = new VideoFormat("jpeg");
        this.inputFormats[1] = new VideoFormat("mjpg");
        this.outputFormats = new RGBFormat[1];
        this.outputFormats[0] = new RGBFormat();
        FrameProcessingControl frameProcessingControl = new FrameProcessingControl(){

            public boolean setMinimalProcessing(boolean bl) {
                NativeDecoder.this.minimal = bl;
                return NativeDecoder.this.minimal;
            }

            public void setFramesBehind(float f2) {
                if (f2 >= 1.0f) {
                    NativeDecoder.this.dropFrame = true;
                } else {
                    NativeDecoder.this.dropFrame = false;
                }
            }

            public Component getControlComponent() {
                return null;
            }

            public int getFramesDropped() {
                return 0;
            }
        };
        this.controls = new Control[1];
        this.controls[0] = frameProcessingControl;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(format)) {
            return new Format[0];
        }
        return this.computeOutputFormats(format);
    }

    private boolean verifyInputFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return false;
        }
        return format.getEncoding().equalsIgnoreCase("jpeg") || format.getEncoding().equalsIgnoreCase("mjpg");
    }

    public Format setInputFormat(Format format) {
        if (!this.verifyInputFormat(format)) {
            return null;
        }
        this.inputFormat = (VideoFormat)format;
        if (this.opened) {
            this.close();
            this.outputFormat = this.updateRGBFormat(this.inputFormat, this.outputFormat);
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (RGBFormat)format;
        return format;
    }

    private final VideoFormat[] computeOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            dimension = new Dimension(320, 240);
        }
        int n2 = (dimension.width + 7 & 0xFFFFFFF8) * (dimension.height + 7 & 0xFFFFFFF8);
        VideoFormat[] videoFormatArray = new RGBFormat[]{new RGBFormat(dimension, n2 * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 1, 2, 3, 3, dimension.width * 3, 1, -1), new RGBFormat(dimension, n2 * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, dimension.width * 3, 1, -1), new RGBFormat(dimension, n2, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, dimension.width, 1, -1), new RGBFormat(dimension, n2, Format.intArray, videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, dimension.width, 1, -1), new RGBFormat(dimension, n2 * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 1, 2, 3, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, n2 * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, n2, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, dimension.width, 0, -1), new RGBFormat(dimension, n2, Format.intArray, videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, dimension.width, 0, -1)};
        return videoFormatArray;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG decoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on the JPEG decoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        Dimension dimension = this.inputFormat.getSize();
        try {
            this.peer = this.initJPEGDecoder(dimension.width, dimension.height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.inputFormat instanceof JPEGFormat) {
            this.decimation = ((JPEGFormat)this.inputFormat).getDecimation();
        }
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG decoder");
        }
        super.open();
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGDecoder(this.peer);
        }
        this.peer = 0;
        super.close();
    }

    public void reset() {
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        boolean bl;
        Object var3_3 = null;
        RGBFormat rGBFormat = null;
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.minimal || this.dropFrame) {
            buffer2.setFlags(buffer2.getFlags() | 2);
            return 0;
        }
        Format format = buffer.getFormat();
        byte[] byArray = (byte[])buffer.getData();
        if (buffer.getLength() < 1) {
            return 0;
        }
        if (!format.equals(this.inputFormat)) {
            this.setInputFormat(format);
            this.close();
        }
        if (rGBFormat == null) {
            buffer2.setFormat(this.outputFormat);
            rGBFormat = this.outputFormat;
        }
        Object object = this.validateData(buffer2, 0, true);
        boolean bl2 = bl = rGBFormat.getFlipped() == 1;
        if (this.peer == 0) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return 1;
            }
        }
        Dimension dimension = this.inputFormat.getSize();
        Integer n2 = NativeEncoder.processLock;
        synchronized (n2) {
            if (object instanceof byte[]) {
                this.returnVal = this.decodeJPEGToByte(this.peer, byArray, buffer.getLength(), dimension.width, dimension.height, (byte[])object, this.outputFormat.getMaxDataLength(), bl, this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getBitsPerPixel());
                buffer2.setLength(dimension.width * dimension.height * this.outputFormat.getBitsPerPixel() / 8);
            } else if (object instanceof int[]) {
                this.returnVal = this.decodeJPEGToInt(this.peer, byArray, buffer.getLength(), dimension.width, dimension.height, (int[])object, this.outputFormat.getMaxDataLength(), bl, this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getBitsPerPixel());
                buffer2.setLength(dimension.width * dimension.height);
            } else if (object instanceof NBA) {
                NBA nBA = (NBA)object;
                this.returnVal = this.decodeJPEGToNBA(this.peer, byArray, buffer.getLength(), dimension.width, dimension.height, nBA.data, this.outputFormat.getMaxDataLength(), bl, this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getBitsPerPixel());
                buffer2.setLength(dimension.width * dimension.height);
                if (this.outputFormat.getDataType() == Format.byteArray) {
                    buffer2.setLength(buffer2.getLength() * this.outputFormat.getBitsPerPixel() / 8);
                }
            }
        }
        if (this.returnVal > 0) {
            buffer2.setOffset(0);
            buffer.setLength(0);
            buffer2.setFlags(buffer2.getFlags() | 0x10);
            buffer2.setTimeStamp(buffer.getTimeStamp());
            return 0;
        }
        buffer2.setDiscard(true);
        return 1;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Decoder";
    }

    private native int initJPEGDecoder(int var1, int var2);

    private native int decodeJPEGToByte(int var1, byte[] var2, int var3, int var4, int var5, byte[] var6, int var7, boolean var8, int var9, int var10, int var11, int var12);

    private native int decodeJPEGToInt(int var1, byte[] var2, int var3, int var4, int var5, int[] var6, int var7, boolean var8, int var9, int var10, int var11, int var12);

    private native int decodeJPEGToNBA(int var1, byte[] var2, int var3, int var4, int var5, long var6, int var8, boolean var9, int var10, int var11, int var12, int var13);

    private native boolean freeJPEGDecoder(int var1);
}

