/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicClock;
import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaTimeBase;
import com.sun.media.controls.MonitorAdapter;
import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;

public class RawBufferMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected ContentDescriptor[] supported = null;
    protected ContentDescriptor contentDesc = null;
    protected RawBufferDataSource source = null;
    protected RawBufferSourceStream[] streams = null;
    protected BasicClock clock = null;
    protected RawMuxTimeBase timeBase = null;
    protected long[] mediaTime;
    protected int masterTrackID = -1;
    boolean sourceDisconnected = false;
    boolean allowDrop = false;
    boolean hasRead = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected int numTracks = 0;
    protected Format[] trackFormats;
    protected MonitorAdapter[] mc = null;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = -1L;
    long mediaStartTime = -1L;

    public RawBufferMux() {
        this.supported = new ContentDescriptor[1];
        this.supported[0] = new ContentDescriptor("raw");
        this.timeBase = new RawMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return "Raw Buffer Multiplexer";
    }

    public void open() throws ResourceUnavailableException {
        this.initializeTracks(this.trackFormats);
        if (this.source == null || this.source.getStreams() == null) {
            throw new ResourceUnavailableException("DataSource and SourceStreams were not created succesfully.");
        }
        try {
            this.source.connect();
        }
        catch (IOException iOException) {
            throw new ResourceUnavailableException(iOException.getMessage());
        }
        int n2 = 0;
        this.mediaTime = new long[this.trackFormats.length];
        this.mc = new MonitorAdapter[this.trackFormats.length];
        int n3 = 0;
        while (n3 < this.trackFormats.length) {
            this.mediaTime[n3] = 0L;
            if (this.trackFormats[n3] instanceof VideoFormat || this.trackFormats[n3] instanceof AudioFormat) {
                this.mc[n3] = new MonitorAdapter(this.trackFormats[n3], this);
                if (this.mc[n3] != null) {
                    ++n2;
                }
            }
            ++n3;
        }
        int n4 = 0;
        this.controls = new Control[n2];
        n3 = 0;
        while (n3 < this.mc.length) {
            if (this.mc[n3] != null) {
                this.controls[n4++] = this.mc[n3];
            }
            ++n3;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
        int n2 = 0;
        while (n2 < this.mc.length) {
            if (this.mc[n2] != null) {
                this.mc[n2].close();
            }
            ++n2;
        }
    }

    public void reset() {
        int n2 = 0;
        while (n2 < this.streams.length) {
            this.streams[n2].reset();
            if (this.mc[n2] != null) {
                this.mc[n2].reset();
            }
            ++n2;
        }
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        return this.supported;
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null), new VideoFormat(null)};
    }

    public DataSource getDataOutput() {
        return this.source;
    }

    public int setNumTracks(int n2) {
        this.numTracks = n2;
        this.trackFormats = new Format[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.trackFormats[n3] = null;
            ++n3;
        }
        return n2;
    }

    public Format setInputFormat(Format format, int n2) {
        if (n2 < this.numTracks) {
            this.trackFormats[n2] = format;
        }
        int n3 = 0;
        while (n3 < this.numTracks) {
            if (this.trackFormats[n3] == null) {
                return format;
            }
            ++n3;
        }
        return format;
    }

    public boolean initializeTracks(Format[] formatArray) {
        if (this.source.getStreams() != null) {
            throw new Error("initializeTracks has been called previously. ");
        }
        this.source.initialize(formatArray);
        this.streams = (RawBufferSourceStream[])this.source.getStreams();
        return true;
    }

    public int process(Buffer buffer, int n2) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[n2] != null && this.mc[n2].isEnabled()) {
            this.mc[n2].process(buffer);
        }
        if (this.streams == null || buffer == null || n2 >= this.streams.length) {
            return 1;
        }
        this.updateTime(buffer, n2);
        return this.streams[n2].process(buffer);
    }

    protected void updateTime(Buffer buffer, int n2) {
        if (buffer.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buffer.getFormat())) {
                if (buffer.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[n2] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[n2] = buffer.getTimeStamp();
                }
            } else {
                long l2 = ((AudioFormat)buffer.getFormat()).computeDuration(buffer.getLength());
                if (l2 >= 0L) {
                    int n3 = n2;
                    this.mediaTime[n3] = this.mediaTime[n3] + l2;
                } else {
                    this.mediaTime[n2] = buffer.getTimeStamp();
                }
            }
        } else if (buffer.getTimeStamp() < 0L) {
            if (this.systemStartTime >= 0L) {
                this.mediaTime[n2] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
            }
        } else {
            this.mediaTime[n2] = buffer.getTimeStamp();
        }
        this.timeBase.update();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) {
        if (BasicPlugIn.matches(contentDescriptor, this.supported) == null) {
            return null;
        }
        this.contentDesc = contentDescriptor;
        this.source = new RawBufferDataSource();
        return this.contentDesc;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (timeBase != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    public void syncStart(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(time);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = this.getMediaNanoseconds() / 1000000L;
        }
    }

    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    public void setStopTime(Time time) {
        this.clock.setStopTime(time);
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public void setMediaTime(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(time);
            int n2 = 0;
            while (n2 < this.mediaTime.length) {
                this.mediaTime[n2] = time.getNanoseconds();
                ++n2;
            }
            this.timeBase.update();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = time.getNanoseconds() / 1000000L;
        }
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return this.clock.mapToTimeBase(time);
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public float setRate(float f2) {
        if (f2 == this.clock.getRate()) {
            return f2;
        }
        return this.clock.setRate(1.0f);
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class RawBufferSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        Format format = null;
        CircularBuffer bufferQ;
        boolean started = false;
        Object startReq = new Integer(0);
        BufferTransferHandler handler = null;
        Thread streamThread = null;
        boolean closed = false;
        boolean draining = false;
        Object drainSync = new Object();
        static /* synthetic */ Class class$com$sun$media$util$MediaThread;

        public RawBufferSourceStream(Format format) {
            Object object;
            this.contentDescriptor = RawBufferMux.this.contentDesc;
            this.format = format;
            this.bufferQ = new CircularBuffer(5);
            if (jmfSecurity != null) {
                object = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        object = "thread";
                        jmfSecurity.requestPermission(RawBufferMux.this.m, RawBufferMux.this.cl, RawBufferMux.this.args, 16);
                        RawBufferMux.this.m[0].invoke((Object)RawBufferMux.this.cl[0], RawBufferMux.this.args[0]);
                        object = "thread group";
                        jmfSecurity.requestPermission(RawBufferMux.this.m, RawBufferMux.this.cl, RawBufferMux.this.args, 32);
                        RawBufferMux.this.m[0].invoke((Object)RawBufferMux.this.cl[0], RawBufferMux.this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable throwable) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                object = this;
                try {
                    Constructor constructor = jdk12CreateThreadRunnableAction.cons;
                    this.streamThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = RawBufferSourceStream.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                }
                catch (Exception exception) {}
            } else {
                this.streamThread = new MediaThread(this, "RawBufferStream Thread");
            }
            if (this.streamThread != null) {
                this.streamThread.start();
            }
        }

        public Format getFormat() {
            return this.format;
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            this.handler = bufferTransferHandler;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void read(Buffer buffer) throws IOException {
            Object object;
            if (this.closed) {
                throw new IOException("The source stream is closed");
            }
            Buffer buffer2 = null;
            CircularBuffer circularBuffer = this.bufferQ;
            // MONITORENTER : circularBuffer
            while (!this.bufferQ.canRead()) {
                try {
                    this.bufferQ.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            buffer2 = this.bufferQ.read();
            // MONITOREXIT : circularBuffer
            if (buffer2.isEOM()) {
                object = this.drainSync;
                // MONITORENTER : object
                if (this.draining) {
                    this.draining = false;
                    this.drainSync.notifyAll();
                }
                // MONITOREXIT : object
            }
            object = buffer.getData();
            Object object2 = buffer.getHeader();
            buffer.copy(buffer2);
            buffer2.setData(object);
            buffer2.setHeader(object2);
            CircularBuffer circularBuffer2 = this.bufferQ;
            // MONITORENTER : circularBuffer2
            RawBufferMux.this.hasRead = true;
            this.bufferQ.readReport();
            this.bufferQ.notifyAll();
            // MONITOREXIT : circularBuffer2
        }

        protected void start() {
            Object object = this.startReq;
            synchronized (object) {
                if (this.started) {
                    return;
                }
                this.started = true;
                this.startReq.notifyAll();
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.notifyAll();
            }
        }

        protected void stop() {
            Object object = this.startReq;
            synchronized (object) {
                this.started = false;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.notifyAll();
            }
        }

        protected void close() {
            this.closed = true;
            if (this.streamThread != null) {
                try {
                    this.reset();
                    Object object = this.startReq;
                    synchronized (object) {
                        this.startReq.notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void reset() {
            Object object;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (this.bufferQ.canRead()) {
                    object = this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                this.bufferQ.notifyAll();
            }
            object = this.drainSync;
            synchronized (object) {
                if (this.draining) {
                    this.draining = false;
                    this.drainSync.notifyAll();
                }
            }
        }

        protected int process(Buffer buffer) {
            Buffer buffer2;
            Object object;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                if (RawBufferMux.this.allowDrop && !this.bufferQ.canWrite() && this.bufferQ.canRead() && (((Buffer)(object = this.bufferQ.peek())).getFlags() & 0x20) == 0) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                while (!this.bufferQ.canWrite() && !this.closed) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.closed) {
                    int n2 = 0;
                    return n2;
                }
                buffer2 = this.bufferQ.getEmptyBuffer();
            }
            object = buffer2.getData();
            Object object2 = buffer2.getHeader();
            buffer2.setData(buffer.getData());
            buffer2.setHeader(buffer.getHeader());
            buffer.setData(object);
            buffer.setHeader(object2);
            buffer2.setLength(buffer.getLength());
            buffer2.setEOM(buffer.isEOM());
            buffer2.setFlags(buffer.getFlags());
            buffer2.setTimeStamp(buffer.getTimeStamp());
            buffer2.setFormat(buffer.getFormat());
            buffer2.setOffset(buffer.getOffset());
            buffer2.setSequenceNumber(buffer.getSequenceNumber());
            if (buffer.isEOM()) {
                this.draining = true;
            }
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
            if (buffer.isEOM()) {
                Object object3 = this.drainSync;
                synchronized (object3) {
                    try {
                        if (this.draining) {
                            this.drainSync.wait(3000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }

        public void run() {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!this.started && !this.closed) {
                            this.startReq.wait();
                        }
                    }
                    CircularBuffer circularBuffer = this.bufferQ;
                    synchronized (circularBuffer) {
                        do {
                            if (!RawBufferMux.this.hasRead) {
                                this.bufferQ.wait(250L);
                            }
                            RawBufferMux.this.hasRead = false;
                        } while (!this.bufferQ.canRead() && !this.closed && this.started);
                    }
                    if (this.closed) {
                        return;
                    }
                    if (!this.started || this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Thread " + interruptedException.getMessage());
                return;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class RawBufferDataSource
    extends BasicPushBufferDataSource {
        public RawBufferDataSource() {
            if (RawBufferMux.this.contentDesc == null) {
                return;
            }
            this.contentType = RawBufferMux.this.contentDesc.getContentType();
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        public void start() throws IOException {
            super.start();
            int n2 = 0;
            while (n2 < RawBufferMux.this.streams.length) {
                RawBufferMux.this.streams[n2].start();
                ++n2;
            }
        }

        public void stop() throws IOException {
            super.stop();
            int n2 = 0;
            while (n2 < RawBufferMux.this.streams.length) {
                RawBufferMux.this.streams[n2].stop();
                ++n2;
            }
        }

        public void connect() throws IOException {
            super.connect();
            RawBufferMux.this.sourceDisconnected = false;
        }

        public void disconnect() {
            super.disconnect();
            RawBufferMux.this.sourceDisconnected = true;
            int n2 = 0;
            while (n2 < RawBufferMux.this.streams.length) {
                RawBufferMux.this.streams[n2].stop();
                RawBufferMux.this.streams[n2].close();
                ++n2;
            }
        }

        private void initialize(Format[] formatArray) {
            RawBufferMux.this.streams = new RawBufferSourceStream[formatArray.length];
            int n2 = 0;
            while (n2 < formatArray.length) {
                RawBufferMux.this.streams[n2] = new RawBufferSourceStream(formatArray[n2]);
                ++n2;
            }
        }
    }

    class RawMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        RawMuxTimeBase() {
        }

        public long getMediaTime() {
            if (RawBufferMux.this.masterTrackID >= 0) {
                return RawBufferMux.this.mediaTime[RawBufferMux.this.masterTrackID];
            }
            if (!this.updated) {
                return this.ticks;
            }
            if (RawBufferMux.this.mediaTime.length == 1) {
                this.ticks = RawBufferMux.this.mediaTime[0];
            } else {
                this.ticks = RawBufferMux.this.mediaTime[0];
                int n2 = 1;
                while (n2 < RawBufferMux.this.mediaTime.length) {
                    if (RawBufferMux.this.mediaTime[n2] < this.ticks) {
                        this.ticks = RawBufferMux.this.mediaTime[n2];
                    }
                    ++n2;
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }
}

