/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.Log;
import com.sun.media.parser.BasicPullParser;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class BasicTrack
implements Track {
    private Format format;
    private boolean enabled = true;
    protected Time duration;
    private Time startTime;
    private int numBuffers;
    private int dataSize;
    private PullSourceStream stream;
    private long minLocation;
    private long maxLocation;
    private long maxStartLocation;
    private BasicPullParser parser;
    private long sequenceNumber = 0L;
    private TrackListener listener;
    private long seekLocation = -1L;
    private long mediaSizeAtEOM = -1L;
    private boolean warnedUserOfReadPastEOM = false;

    public BasicTrack(BasicPullParser basicPullParser, Format format, boolean bl, Time time, Time time2, int n2, int n3, PullSourceStream pullSourceStream) {
        this(basicPullParser, format, bl, time, time2, n2, n3, pullSourceStream, 0L, Long.MAX_VALUE);
    }

    public BasicTrack(BasicPullParser basicPullParser, Format format, boolean bl, Time time, Time time2, int n2, int n3, PullSourceStream pullSourceStream, long l2, long l3) {
        this.parser = basicPullParser;
        this.format = format;
        this.enabled = bl;
        this.duration = time;
        this.startTime = time2;
        this.numBuffers = n2;
        this.dataSize = n3;
        this.stream = pullSourceStream;
        this.minLocation = l2;
        this.maxLocation = l3;
        this.maxStartLocation = l3 - (long)n3;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Time getDuration() {
        return this.duration;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public void setTrackListener(TrackListener trackListener) {
        this.listener = trackListener;
    }

    public synchronized void setSeekLocation(long l2) {
        this.seekLocation = l2;
    }

    public synchronized long getSeekLocation() {
        return this.seekLocation;
    }

    public void readFrame(Buffer buffer) {
        byte[] byArray;
        boolean bl;
        long l2;
        if (buffer == null) {
            return;
        }
        if (!this.enabled) {
            buffer.setDiscard(true);
            return;
        }
        buffer.setFormat(this.format);
        Object object = buffer.getData();
        BasicTrack basicTrack = this;
        synchronized (basicTrack) {
            if (this.seekLocation != -1L) {
                l2 = this.seekLocation;
                if (this.seekLocation < this.maxLocation) {
                    this.seekLocation = -1L;
                }
                bl = true;
            } else {
                l2 = this.parser.getLocation(this.stream);
                bl = false;
            }
        }
        if (l2 < this.minLocation) {
            buffer.setDiscard(true);
            return;
        }
        if (l2 >= this.maxLocation) {
            buffer.setLength(0);
            buffer.setEOM(true);
            return;
        }
        int n2 = l2 > this.maxStartLocation ? this.dataSize - (int)(l2 - this.maxStartLocation) : this.dataSize;
        if (object == null || !(object instanceof byte[]) || ((byte[])object).length < n2) {
            byArray = new byte[n2];
            buffer.setData(byArray);
        } else {
            byArray = (byte[])object;
        }
        try {
            long l3;
            if (this.parser.cacheStream != null && this.listener != null && this.parser.cacheStream.willReadBytesBlock(l2, n2)) {
                this.listener.readHasBlocked(this);
            }
            if (bl && (l3 = ((Seekable)((Object)this.stream)).seek(l2)) == -2L) {
                buffer.setDiscard(true);
                return;
            }
            if (this.parser.getMediaTime() != null) {
                buffer.setTimeStamp(this.parser.getMediaTime().getNanoseconds());
            } else {
                buffer.setTimeStamp(-1L);
            }
            buffer.setDuration(-1L);
            int n3 = this.parser.readBytes(this.stream, byArray, n2);
            buffer.setOffset(0);
            buffer.setLength(n3);
            buffer.setSequenceNumber(++this.sequenceNumber);
        }
        catch (IOException iOException) {
            if (this.maxLocation != Long.MAX_VALUE) {
                if (!this.warnedUserOfReadPastEOM) {
                    Log.warning("Warning: Attempt to read past End of Media");
                    Log.warning("This typically happens if the duration is not known or");
                    Log.warning("if the media file has incorrect header info");
                    this.warnedUserOfReadPastEOM = true;
                }
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            long l4 = this.parser.streams[0].getContentLength();
            if (l4 != -1L) {
                this.maxLocation = l4;
                this.maxStartLocation = this.maxLocation - (long)this.dataSize;
                this.mediaSizeAtEOM = this.maxLocation - this.minLocation;
                buffer.setLength(0);
                buffer.setDiscard(true);
            }
            this.maxLocation = this.parser.getLocation(this.stream);
            this.maxStartLocation = this.maxLocation - (long)this.dataSize;
            this.mediaSizeAtEOM = this.maxLocation - this.minLocation;
            buffer.setLength(0);
            buffer.setEOM(true);
        }
    }

    public int mapTimeToFrame(Time time) {
        return Integer.MAX_VALUE;
    }

    public Time mapFrameToTime(int n2) {
        return Track.TIME_UNKNOWN;
    }

    public long getMediaSizeAtEOM() {
        return this.mediaSizeAtEOM;
    }
}

