/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.CircularBuffer;
import com.sun.media.parser.RawParser;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class RawStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw stream parser";

    public String getName() {
        return NAME;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PushDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.streams = ((PushDataSource)dataSource).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.source = dataSource;
        this.streams = this.streams;
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PushSourceStream;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int n2 = 0;
        while (n2 < this.streams.length) {
            this.tracks[n2] = new FrameTrack(this, (PushSourceStream)this.streams[n2], 5);
            ++n2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                int n2 = 0;
                while (n2 < this.tracks.length) {
                    ((FrameTrack)this.tracks[n2]).stop();
                    ++n2;
                }
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void start() throws IOException {
        this.source.start();
        int n2 = 0;
        while (n2 < this.tracks.length) {
            ((FrameTrack)this.tracks[n2]).start();
            ++n2;
        }
    }

    public void stop() {
        try {
            this.source.stop();
            int n2 = 0;
            while (n2 < this.tracks.length) {
                ((FrameTrack)this.tracks[n2]).stop();
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class FrameTrack
    implements Track,
    SourceTransferHandler {
        Demultiplexer parser;
        PushSourceStream pss;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);
        boolean stopped = true;

        public FrameTrack(Demultiplexer demultiplexer, PushSourceStream pushSourceStream, int n2) {
            this.pss = pushSourceStream;
            pushSourceStream.setTransferHandler(this);
            this.bufferQ = new CircularBuffer(n2);
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean bl) {
            if (bl) {
                this.pss.setTransferHandler(this);
            } else {
                this.pss.setTransferHandler(null);
            }
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readFrame(Buffer buffer) {
            Buffer buffer2;
            Object object;
            Integer n2 = this.stateReq;
            synchronized (n2) {
                if (this.stopped) {
                    buffer.setDiscard(true);
                    buffer.setFormat(this.format);
                    return;
                }
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        object = this.stateReq;
                        synchronized (object) {
                            if (this.stopped) {
                                buffer.setDiscard(true);
                                buffer.setFormat(this.format);
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                buffer2 = this.bufferQ.read();
                this.bufferQ.notifyAll();
            }
            object = (byte[])buffer2.getData();
            buffer2.setData(buffer.getData());
            buffer.setData(object);
            buffer.setLength(buffer2.getLength());
            buffer.setFormat(this.format);
            buffer.setTimeStamp(-1L);
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
                return;
            }
        }

        public void stop() {
            Integer n2 = this.stateReq;
            synchronized (n2) {
                this.stopped = true;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.notifyAll();
            }
        }

        public void start() {
            Integer n2 = this.stateReq;
            synchronized (n2) {
                this.stopped = false;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.notifyAll();
            }
        }

        public int mapTimeToFrame(Time time) {
            return -1;
        }

        public Time mapFrameToTime(int n2) {
            return new Time(0L);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transferData(PushSourceStream pushSourceStream) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canWrite()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                buffer = this.bufferQ.getEmptyBuffer();
                this.bufferQ.notifyAll();
            }
            int n2 = pushSourceStream.getMinimumTransferSize();
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null || byArray.length < n2) {
                byArray = new byte[n2];
                buffer.setData(byArray);
            }
            try {
                int n3 = pushSourceStream.read(byArray, 0, n2);
                buffer.setLength(n3);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
                return;
            }
        }
    }
}

