/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class WavParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private WavAudioFormat format = null;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private int encoding;
    private String encodingString;
    private int sampleRate;
    private int channels;
    private int sampleSizeInBits;
    private int blockAlign;
    private int samplesPerBlock;
    private long minLocation;
    private long maxLocation;
    private double locationToMediaTime = -1.0;
    private double timePerBlockNano = -1.0;
    private PullSourceStream stream = null;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_wav")};

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.minLocation = this.getLocation(this.stream);
        this.maxLocation = this.minLocation + (long)this.dataSize;
        this.tracks[0] = new WavTrack(this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        int n2;
        String string = this.readString(this.stream);
        if (!string.equals("RIFF")) {
            throw new BadHeaderException("WAVE Parser: expected magic string RIFF, got " + string);
        }
        int n3 = this.readInt(this.stream, false);
        String string2 = this.readString(this.stream);
        if (!string2.equals("WAVE")) {
            throw new BadHeaderException("WAVE Parser: expected magic string WAVE, got " + string2);
        }
        n3 += 8;
        while (!this.readString(this.stream).equals("fmt ")) {
            n2 = this.readInt(this.stream, false);
            this.skip(this.stream, n2);
        }
        int n4 = n2 = this.readInt(this.stream, false);
        if (n2 < 16) {
            // empty if block
        }
        this.encoding = this.readShort(this.stream, false);
        this.encodingString = (String)WavAudioFormat.formatMapper.get(new Integer(this.encoding));
        if (this.encodingString == null) {
            this.encodingString = "unknown";
        }
        this.channels = this.readShort(this.stream, false);
        this.sampleRate = this.readInt(this.stream, false);
        int n5 = this.readInt(this.stream, false);
        this.blockAlign = this.readShort(this.stream, false);
        this.sampleSizeInBits = this.readShort(this.stream, false);
        if (this.encoding == 85) {
            this.sampleSizeInBits = 16;
        }
        this.samplesPerBlock = -1;
        if ((n4 -= 16) > 0 && this.encoding == 1 || n4 <= 2) {
            this.skip(this.stream, n4);
            n4 = 0;
        }
        byte[] byArray = null;
        short s = 0;
        if (n4 >= 2) {
            s = this.readShort(this.stream, false);
            n4 -= 2;
            if (s > 0) {
                byArray = new byte[s];
                this.readBytes(this.stream, byArray, byArray.length);
                n4 -= s;
            }
        }
        switch (this.encoding) {
            case 2: 
            case 17: 
            case 49: {
                if (s < 2) {
                    throw new BadHeaderException("msadpcm: samplesPerBlock field not available");
                }
                this.samplesPerBlock = BasicPullParser.parseShortFromArray(byArray, false);
                this.locationToMediaTime = (double)this.samplesPerBlock / (double)(this.sampleRate * this.blockAlign);
                break;
            }
            default: {
                this.locationToMediaTime = 1.0 / (double)(this.sampleRate * this.blockAlign);
            }
        }
        if (n4 < 0) {
            throw new BadHeaderException("WAVE Parser: incorrect chunkSize in the fmt chunk");
        }
        if (n4 > 0) {
            this.skip(this.stream, n4);
        }
        while (!this.readString(this.stream).equals("data")) {
            int n6 = this.readInt(this.stream, false);
            this.skip(this.stream, n6);
        }
        this.dataSize = this.readInt(this.stream, false);
        this.bufferSize = this.blockAlign != 0 ? (n5 < this.dataSize ? n5 - n5 % this.blockAlign : this.dataSize - this.dataSize % this.blockAlign) : (n5 < this.dataSize ? n5 : this.dataSize);
        double d2 = -1.0;
        if (this.channels * this.sampleSizeInBits / 8 == this.blockAlign) {
            d2 = (float)this.dataSize / (float)n5;
        } else if (this.samplesPerBlock > 0) {
            d2 = (float)this.dataSize / (float)this.blockAlign * (float)this.samplesPerBlock / (float)this.sampleRate;
            this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / (double)this.sampleRate;
        } else {
            this.timePerBlockNano = (double)this.blockAlign * 1.0E9 / (double)n5;
            d2 = (float)this.dataSize / (float)n5;
        }
        this.duration = new Time(d2);
        boolean bl = this.sampleSizeInBits > 8;
        this.format = new WavAudioFormat(this.encodingString, this.sampleRate, this.sampleSizeInBits, this.channels, this.blockAlign * 8, n5, 0, bl ? 1 : 0, -1.0f, Format.byteArray, byArray);
    }

    public Time setPosition(Time time, int n2) {
        long l2;
        if (!this.seekable) {
            return this.getMediaTime();
        }
        long l3 = time.getNanoseconds();
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (this.timePerBlockNano <= 0.0) {
            int n3 = this.sampleRate * this.blockAlign;
            double d2 = (double)(l3 * (long)this.sampleRate * (long)this.blockAlign) / 1.0E9;
            double d3 = d2 % (double)this.blockAlign;
            l2 = (long)(d2 - d3);
            if (d3 > 0.0) {
                switch (n2) {
                    case 1: {
                        l2 += (long)this.blockAlign;
                        break;
                    }
                    case 3: {
                        if (!(d3 > (double)this.blockAlign / 2.0)) break;
                        l2 += (long)this.blockAlign;
                    }
                }
            }
        } else {
            double d4 = (double)l3 / this.timePerBlockNano;
            int n4 = (int)d4;
            double d5 = d4 - (double)n4;
            if (d5 > 0.0) {
                switch (n2) {
                    case 1: {
                        ++n4;
                        break;
                    }
                    case 3: {
                        if (!(d5 > 0.5)) break;
                        ++n4;
                    }
                }
            }
            l2 = n4 * this.blockAlign;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(l2 += this.minLocation);
        if (this.cacheStream != null) {
            WavParser wavParser = this;
            synchronized (wavParser) {
                this.cacheStream.abortRead();
            }
        }
        return time;
    }

    public Time getMediaTime() {
        long l2 = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long l3 = l2 != -1L ? l2 - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)l3 * this.locationToMediaTime);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        return this.duration;
    }

    public String getName() {
        return "Parser for WAV file format";
    }

    class WavTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime = new SettableTime();

        WavTrack(WavAudioFormat wavAudioFormat, boolean bl, Time time, int n2, int n3, long l2, long l3) {
            super(WavParser.this, wavAudioFormat, bl, WavParser.this.duration, time, n2, n3, WavParser.this.stream, l2, l3);
            double d2 = wavAudioFormat.getSampleRate();
            int n4 = wavAudioFormat.getChannels();
            int n5 = wavAudioFormat.getSampleSizeInBits();
            int n6 = wavAudioFormat.getFrameSizeInBits() / 8;
            if (WavParser.this.encoding == 1 || WavParser.this.encoding == 7 || WavParser.this.encoding == 6 || WavParser.this.encoding == 257 || WavParser.this.encoding == 258) {
                float f2 = (float)d2 * (float)n6;
                float f3 = n3;
                this.timePerFrame = (float)n3 / f2;
            } else if (WavParser.this.encoding == 2 || WavParser.this.encoding == 17 || WavParser.this.encoding == 49) {
                float f4 = n3;
                float f5 = (float)n3 / (float)n6;
                float f6 = f5 * (float)WavParser.this.samplesPerBlock;
                this.timePerFrame = (float)((double)f6 / d2);
            } else {
                float f7 = (float)d2 * (float)n6;
                float f8 = n3;
                this.timePerFrame = (float)n3 / f7;
            }
        }

        WavTrack(WavAudioFormat wavAudioFormat, boolean bl, Time time, int n2, int n3) {
            this(wavAudioFormat, bl, time, n2, n3, 0L, Long.MAX_VALUE);
        }
    }
}

