/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.protocol.BasicPullSourceStream;
import com.sun.media.protocol.CachedPullSourceStream;
import com.sun.media.ui.CacheControlComponent;
import com.sun.media.util.ContentType;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.Registry;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12ConnectionAction;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import javax.media.DownloadProgressListener;
import javax.media.ExtendedCachingControl;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class DataSource
extends PullDataSource {
    protected boolean connected = false;
    private String contentType = null;
    private PullSourceStream[] pssArray = new PullSourceStream[1];
    private CachedPullSourceStream cachedStream = null;
    private long contentLength = -1L;
    private InputStream inputStream;
    private String fileSeparator = System.getProperty("file.separator");
    private boolean downLoadThreadStarted = false;
    private boolean isEnabledCaching = false;
    private ExtendedCachingControl[] cachingControls = new ExtendedCachingControl[0];
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        Object object;
        URLConnection uRLConnection;
        URL uRL;
        if (this.connected) {
            return;
        }
        MediaLocator mediaLocator = this.getLocator();
        if (mediaLocator == null) {
            throw new IOException(this + ": connect() failed");
        }
        try {
            uRL = mediaLocator.getURL();
            uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(true);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(this + ": connect() failed");
        }
        String string = uRL.getProtocol();
        boolean bl = true;
        try {
            this.inputStream = uRLConnection.getInputStream();
            bl = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.inputStream == null) {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Exception exception) {
                    jmfSecurity.permissionFailureNotification(128);
                    throw new IOException("Unable to get connect permission" + exception.getMessage());
                }
            }
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor constructor = jdk12ConnectionAction.cons;
                    this.inputStream = (InputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(uRLConnection));
                } else {
                    this.inputStream = uRLConnection.getInputStream();
                }
            }
            catch (Throwable throwable) {
                throw new IOException(JMFI18N.getResource("error.connectionerror") + throwable.getMessage());
            }
        }
        if (this.inputStream == null) {
            throw new IOException(JMFI18N.getResource("error.connectionerror") + "Unable to open a URL connection");
        }
        if (string.equals("ftp")) {
            this.contentType = "content/unknown";
        } else {
            this.contentType = uRLConnection.getContentType();
            this.contentLength = uRLConnection.getContentLength();
        }
        this.contentType = ContentType.getCorrectedContentType(this.contentType, mediaLocator.getRemainder());
        this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
        boolean bl2 = (Boolean)Manager.getHint(2);
        if (this.contentType.endsWith(".mvr") || this.contentType.endsWith("x_shockwave_flash") || this.contentType.endsWith("futuresplash")) {
            bl2 = false;
        }
        String string2 = null;
        if (bl2 && (string2 = Manager.getCacheDirectory()) != null && (object = Registry.get("secure.allowCaching")) != null) {
            this.isEnabledCaching = (Boolean)object;
        }
        if (this.isEnabledCaching) {
            object = string2 + this.fileSeparator + DataSource.generateFileName(this.getLocator().getRemainder());
            try {
                this.cachedStream = new CachedPullSourceStream(this.inputStream, (String)object, this.contentLength, string);
                this.pssArray[0] = this.cachedStream;
                this.cachingControls = new ExtendedCachingControl[1];
                this.cachingControls[0] = new CachingControl(this.cachedStream);
                Log.comment("Caching in " + string2);
            }
            catch (IOException iOException) {
                this.isEnabledCaching = false;
            }
        }
        if (!this.isEnabledCaching) {
            try {
                this.pssArray[0] = new BasicPullSourceStream(uRL, this.inputStream, this.contentLength, bl);
                this.cachedStream = null;
            }
            catch (Exception exception) {
                this.pssArray[0] = null;
                throw new IOException(JMFI18N.getResource("error.connectionerror") + exception.getMessage());
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.cachedStream != null) {
            this.cachedStream.close();
            this.cachedStream = null;
        }
        this.pssArray[0] = null;
        this.connected = false;
    }

    public void start() throws IOException {
        if (!this.connected) {
            return;
        }
        if (this.cachedStream != null) {
            if (!this.downLoadThreadStarted) {
                this.cachedStream.startDownload();
                this.downLoadThreadStarted = true;
            } else {
                this.cachedStream.resumeDownload();
            }
        }
    }

    public void stop() throws IOException {
        if (!this.connected) {
            return;
        }
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return null;
    }

    public Object[] getControls() {
        return this.cachingControls;
    }

    public Object getControl(String string) {
        if (this.cachingControls.length > 0 && string.equals("javax.media.CachingControl")) {
            return this.cachingControls[0];
        }
        return null;
    }

    public static String generateFileName(String string) {
        String string2 = null;
        int n2 = 0;
        Random random = new Random();
        int n3 = string.lastIndexOf(46);
        int n4 = random.nextInt();
        if (n3 != -1) {
            string2 = new String(string.substring(n3));
        } else {
            n3 = string.length();
        }
        n2 = string.lastIndexOf(File.separatorChar);
        n2 = Math.max(string.lastIndexOf(47), n2);
        if (n2 >= n3) {
            n3 = string.length();
            string2 = null;
        }
        String string3 = string.substring(n2 + 1, n3);
        String string4 = string2 != null ? new String(string3 + n4 + string2) : new String(string3 + n4);
        return DataSource.convertNonAlphaNumericToUnderscore(string4);
    }

    private static String convertNonAlphaNumericToUnderscore(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (!(c2 == '.' || 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z' || '0' <= c2 && c2 <= '9')) {
                cArray[n3] = 95;
            }
            ++n3;
        }
        return new String(cArray);
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class CachingControl
    implements ExtendedCachingControl {
        private CacheControlComponent controlComponent;
        private Component progressBar;
        private CachedPullSourceStream cpss;

        CachingControl(CachedPullSourceStream cachedPullSourceStream) {
            this.cpss = cachedPullSourceStream;
            this.controlComponent = new CacheControlComponent(this, null);
            this.progressBar = this.controlComponent.getProgressBar();
        }

        public boolean isDownloading() {
            return this.cpss.isDownloading();
        }

        public long getContentLength() {
            return DataSource.this.contentLength;
        }

        public long getContentProgress() {
            return this.cpss.getContentProgress();
        }

        public Component getProgressBarComponent() {
            return this.progressBar;
        }

        public Component getControlComponent() {
            return this.controlComponent;
        }

        public void pauseDownload() {
            this.cpss.pauseDownload();
        }

        public void resumeDownload() {
            this.cpss.resumeDownload();
        }

        public long getStartOffset() {
            return this.cpss.getStartOffset();
        }

        public long getEndOffset() {
            return this.cpss.getEndOffset();
        }

        public void setBufferSize(Time time) {
        }

        public Time getBufferSize() {
            return null;
        }

        public void addDownloadProgressListener(DownloadProgressListener downloadProgressListener, int n2) {
            this.cpss.addDownloadProgressListener(downloadProgressListener, n2);
        }

        public void removeDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
            this.cpss.removeDownloadProgressListener(downloadProgressListener);
        }
    }
}

