/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.avi;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.ContentType;
import com.sun.media.util.JMFI18N;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

class FileDataSource
extends PullDataSource {
    private String fileName;
    private RandomAccessFile raf;
    private boolean connected = false;
    private long length = -1L;
    private String contentType = null;
    private PullSourceStream[] pssArray = new PullSourceStream[1];
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public FileDataSource(String string) throws IOException {
        this.fileName = string;
    }

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            if (securityPrivelege && jmfSecurity != null) {
                try {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                }
                catch (Exception exception) {
                    System.err.println("Unable to get read file privilege  " + exception);
                    securityPrivelege = false;
                }
            }
            this.contentType = ContentType.getCorrectedContentType("content/unknown", this.fileName);
            this.contentType = ContentType.getCorrectedContentType("content/unknown", this.fileName);
            this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
            System.out.println("contentType is " + this.contentType);
            this.raf = new RandomAccessFile(this.fileName, "r");
            this.length = this.raf.length();
            if (this.length < 0L) {
                this.length = -1L;
            }
            RAFPullSourceStream rAFPullSourceStream = new RAFPullSourceStream();
            this.pssArray[0] = rAFPullSourceStream;
            this.connected = true;
        }
        catch (IOException iOException) {
            throw new IOException(JMFI18N.getResource("error.filenotfound"));
        }
    }

    public void disconnect() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.pssArray != null) {
            this.pssArray[0] = null;
        }
        this.connected = false;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void setLocator(MediaLocator mediaLocator) {
        if (mediaLocator != null && mediaLocator.getProtocol() != null && mediaLocator.getProtocol().equals("file")) {
            MediaLocator mediaLocator2 = mediaLocator;
            String string = mediaLocator.getRemainder();
            boolean bl = false;
            if (string == null) {
                super.setLocator(mediaLocator);
                return;
            }
            try {
                int n2 = 0;
                while ((n2 = string.indexOf("%", n2)) >= 0) {
                    if (string.length() > n2 + 2) {
                        byte[] byArray = new byte[1];
                        try {
                            byArray[0] = (byte)Integer.valueOf(string.substring(n2 + 1, n2 + 3), 16).intValue();
                            string = string.substring(0, n2) + new String(byArray) + string.substring(n2 + 3);
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    mediaLocator = new MediaLocator(mediaLocator.getProtocol() + ":" + string);
                }
            }
            catch (Exception exception) {
                mediaLocator = mediaLocator2;
            }
        }
        super.setLocator(mediaLocator);
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    protected String getCorrectedContentType(String string) {
        if (string != null) {
            String string2;
            if (string.equals("audio/wav")) {
                string = "audio/x-wav";
            } else if (string.equals("audio/aiff")) {
                string = "audio/x-aiff";
            } else if (string.equals("application/x-troff-msvideo")) {
                string = "video/x-msvideo";
            } else if (string.equals("video/msvideo")) {
                string = "video/x-msvideo";
            } else if (string.equals("audio/x-mpegaudio")) {
                string = "audio/mpeg";
            } else if (string.equals("content/unknown") && (string2 = this.guessContentType(this.getLocator())) != null) {
                string = string2;
            }
        } else {
            string = "content/unknown";
        }
        return string;
    }

    private String guessContentType(MediaLocator mediaLocator) {
        String string = mediaLocator.getRemainder();
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            String string2 = string.substring(n2 + 1).toLowerCase();
            if (string2.equals("mov")) {
                return "video/quicktime";
            }
            if (string2.equals("avi")) {
                return "video/x_msvideo";
            }
            if (string2.equals("mpg")) {
                return "video/mpeg";
            }
            if (string2.equals("mpv")) {
                return "video/mpeg";
            }
            if (string2.equals("viv")) {
                return "video/vivo";
            }
            if (string2.equals("au")) {
                return "audio/basic";
            }
            if (string2.equals("wav")) {
                return "audio/x_wav";
            }
            if (string2.equals("mid") || string2.equals("midi")) {
                return "audio/midi";
            }
            if (string2.equals("rmf")) {
                return "audio/rmf";
            }
            if (string2.equals("gsm")) {
                return "audio/x_gsm";
            }
            if (string2.equals("mp2")) {
                return "audio/mpeg";
            }
            if (string2.equals("mp3")) {
                return "audio/mpeg";
            }
            if (string2.equals("mpa")) {
                return "audio/mpeg";
            }
            if (string2.equals("swf")) {
                return "application/x-shockwave-flash";
            }
            if (string2.equals("spl")) {
                return "application/futuresplash";
            }
        }
        return null;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        RAFPullSourceStream() {
        }

        public long seek(long l2) {
            try {
                FileDataSource.this.raf.seek(l2);
                return this.tell();
            }
            catch (IOException iOException) {
                System.out.println("seek: " + iOException);
                return -1L;
            }
        }

        public long tell() {
            try {
                return FileDataSource.this.raf.getFilePointer();
            }
            catch (IOException iOException) {
                System.out.println("tell: " + iOException);
                return -1L;
            }
        }

        public boolean isRandomAccess() {
            return true;
        }

        public boolean willReadBlock() {
            return false;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return FileDataSource.this.raf.read(byArray, n2, n3);
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return FileDataSource.this.length;
        }

        public boolean endOfStream() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }
    }
}

