/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.file;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MimeManager;
import com.sun.media.util.ContentType;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12RandomAccessFileAction;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private RandomAccessFile raf;
    private boolean connected = false;
    private long length = -1L;
    private String contentType = null;
    private PullSourceStream[] pssArray = new PullSourceStream[1];
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private static Hashtable mimeTable;

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        Object object;
        URL uRL;
        if (this.connected) {
            return;
        }
        MediaLocator mediaLocator = this.getLocator();
        if (mediaLocator == null) {
            System.err.println("medialocator is null");
            throw new IOException(this + ": connect() failed");
        }
        try {
            uRL = mediaLocator.getURL();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(this.getLocator() + ": Don't know how to deal with non-URL locator yet!");
            throw new IOException(this + ": connect() failed");
        }
        String string = DataSource.getFileName(mediaLocator);
        if (jmfSecurity != null) {
            int n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                object = string.substring(n2 + 1).toLowerCase();
                if (!mimeTable.containsKey(object) && !((String)object).equalsIgnoreCase("aif")) {
                    throw new IOException("Permission Denied: From an applet cannot read media file with extension " + (String)object);
                }
            } else {
                throw new IOException("For security reasons, from an applet, cannot read a media file with no extension");
            }
        }
        try {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                    }
                }
                catch (Throwable throwable) {
                    jmfSecurity.permissionFailureNotification(2);
                    throw new IOException("No permissions to read file");
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor constructor = jdk12RandomAccessFileAction.cons;
                    this.raf = (RandomAccessFile)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(string, "r"));
                }
                catch (Throwable throwable) {
                    throw new IOException(JMFI18N.getResource("error.filenotfound"));
                }
            } else {
                this.raf = new RandomAccessFile(string, "r");
            }
            this.length = this.raf.length();
            if (this.length < 0L) {
                this.length = -1L;
            }
            RAFPullSourceStream rAFPullSourceStream = new RAFPullSourceStream();
            this.pssArray[0] = rAFPullSourceStream;
            object = uRL.openConnection();
            try {
                this.contentType = ((URLConnection)object).getContentType();
            }
            catch (Throwable throwable) {
                this.contentType = null;
            }
            this.contentType = ContentType.getCorrectedContentType(this.contentType, mediaLocator.getRemainder());
            this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
            this.connected = true;
        }
        catch (Throwable throwable) {
            throw new IOException(JMFI18N.getResource("error.filenotfound"));
        }
    }

    public void disconnect() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.pssArray != null) {
            this.pssArray[0] = null;
        }
        this.connected = false;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void setLocator(MediaLocator mediaLocator) {
        if (mediaLocator != null && mediaLocator.getProtocol() != null && mediaLocator.getProtocol().equals("file")) {
            MediaLocator mediaLocator2 = mediaLocator;
            String string = mediaLocator.getRemainder();
            boolean bl = false;
            if (string == null) {
                super.setLocator(mediaLocator);
                return;
            }
            try {
                int n2 = 0;
                while ((n2 = string.indexOf("%", n2)) >= 0) {
                    if (string.length() > n2 + 2) {
                        byte[] byArray = new byte[1];
                        try {
                            byArray[0] = (byte)Integer.valueOf(string.substring(n2 + 1, n2 + 3), 16).intValue();
                            string = string.substring(0, n2) + new String(byArray) + string.substring(n2 + 3);
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    mediaLocator = new MediaLocator(mediaLocator.getProtocol() + ":" + string);
                }
            }
            catch (Exception exception) {
                mediaLocator = mediaLocator2;
            }
        }
        super.setLocator(mediaLocator);
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public javax.media.protocol.DataSource createClone() {
        DataSource dataSource = new DataSource();
        dataSource.setLocator(this.getLocator());
        if (this.connected) {
            try {
                dataSource.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return dataSource;
    }

    public static String getFileName(MediaLocator mediaLocator) {
        try {
            String string;
            URL uRL = mediaLocator.getURL();
            String string2 = string = mediaLocator.getRemainder();
            try {
                int n2 = 0;
                while ((n2 = string.indexOf("%", n2)) >= 0) {
                    if (string.length() > n2 + 2) {
                        byte[] byArray = new byte[1];
                        try {
                            byArray[0] = (byte)Integer.valueOf(string.substring(n2 + 1, n2 + 3), 16).intValue();
                            string = string.substring(0, n2) + new String(byArray) + string.substring(n2 + 3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                n2 = 0;
                while ((n2 = string.indexOf("|")) >= 0) {
                    string = n2 > 0 ? string.substring(0, n2) + ":" + string.substring(n2 + 1) : string.substring(1);
                }
                while (string.startsWith("///")) {
                    string = string.substring(2);
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    while (string.charAt(0) == '/' && string.charAt(2) == ':') {
                        string = string.substring(1);
                    }
                }
            }
            catch (Exception exception) {
                string = string2;
            }
            return string;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
            mimeTable = MimeManager.getDefaultMimeTable();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        RAFPullSourceStream() {
        }

        public long seek(long l2) {
            try {
                DataSource.this.raf.seek(l2);
                return this.tell();
            }
            catch (IOException iOException) {
                System.out.println("seek: " + iOException);
                return -1L;
            }
        }

        public long tell() {
            try {
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException iOException) {
                System.out.println("tell: " + iOException);
                return -1L;
            }
        }

        public boolean isRandomAccess() {
            return true;
        }

        public boolean willReadBlock() {
            return false;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return DataSource.this.raf.read(byArray, n2, n3);
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return DataSource.this.length;
        }

        public boolean endOfStream() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }
    }
}

