/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.sunvideo;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.AtomicControlAdapter;
import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.QualityAdapter;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.sunvideo.DataSource;
import com.sun.media.protocol.sunvideo.PushThread;
import com.sun.media.protocol.sunvideo.XILCapture;
import com.sun.media.protocol.sunvideo.jdk12CreateThreadAction;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.util.jdk12;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.SystemTimeBase;
import javax.media.control.FormatControl;
import javax.media.control.PortControl;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

class SunVideoSourceStream
extends BasicSourceStream
implements PushBufferStream,
Owned {
    private DataSource dataSource = null;
    private MediaLocator locator = null;
    int maxDataSize = 230400;
    BufferTransferHandler transferHandler = null;
    private byte[] data = null;
    private int length = 0;
    private long nextSequence = 1L;
    long timeStamp = 0L;
    XILCapture svCap = null;
    SystemTimeBase systemTimeBase = new SystemTimeBase();
    private VideoFormat capFormat = null;
    private static Format[] supported;
    private static final boolean CONTROL_PANEL_HACK = false;
    private Frame controlFrame = null;
    private static Integer SunVideoLock;
    Integer readLock = new Integer(1);
    private boolean started = false;
    private boolean connected = false;
    private boolean connectedOK = false;
    private boolean inUse = false;
    private int cardNo = 0;
    private static String[] VALID_PORTS;
    private static final int DEFAULT_PORT = 1;
    private int portNo = 1;
    private static String[] VALID_COMPRESS;
    private static String[] VIDEO_COMPRESS;
    private static final int DEFAULT_COMPRESS = 0;
    private static final int RGB_COMPRESS = 1;
    private int compressNo = 0;
    private static String[] VALID_SIZES;
    private static Dimension[] DEFAULT_DIMENSIONS;
    private static float[] VALID_SIZES_FLOAT;
    private static int[] VALID_SCALE;
    private static final int DEFAULT_SIZE = 1;
    private static float SIZE_GRANULARITY;
    private int sizeNo = 1;
    private static final int DEFAULT_RATE = 30;
    private int rateNo = 30;
    private static final int DEFAULT_QUALITY = 50;
    private int qualityNo = 50;
    private LocalPortControl portControl = null;
    private RateControl rateControl = null;
    private LocalQualityControl qualityControl = null;
    private LocalFormatControl formatControl = null;
    private float preferredFrameRate = 30.0f;
    private PushThread pt = null;
    long ptDelay = 1000 / this.rateNo;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$protocol$sunvideo$PushThread;

    public SunVideoSourceStream(DataSource dataSource) {
        super(new ContentDescriptor("raw"), -1L);
        this.dataSource = dataSource;
        this.locator = dataSource.getLocator();
        this.cardNo = 0;
        String string = this.locator.getRemainder();
        if (string != null && string.length() > 0) {
            String string2;
            while (string.length() > 1 && string.charAt(0) == '/') {
                string = string.substring(1);
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n2 = string.indexOf(47);
            if (n2 == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n2);
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(47)) == -1) {
                    string3 = string;
                } else {
                    string3 = string.substring(0, n2);
                    if ((n2 = (string = string.substring(n2 + 1)).indexOf(47)) == -1) {
                        string4 = string;
                    } else {
                        string4 = string.substring(0, n2);
                        string5 = string.substring(n2 + 1);
                    }
                }
            }
            try {
                Integer n3 = Integer.valueOf(string2);
                if (n3 != null) {
                    this.cardNo = n3;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string3 != null && string3.length() > 0) {
                int n4 = 0;
                while (n4 < VALID_PORTS.length) {
                    if (VALID_PORTS[n4].equalsIgnoreCase(string3)) {
                        this.portNo = n4;
                    }
                    ++n4;
                }
            }
            if (string4 != null && string4.length() > 0) {
                int n5 = 0;
                while (n5 < VALID_COMPRESS.length) {
                    if (VALID_COMPRESS[n5].equalsIgnoreCase(string4)) {
                        this.compressNo = n5;
                    }
                    ++n5;
                }
            }
            if (string5 != null && string5.length() > 0) {
                int n6 = 0;
                while (n6 < VALID_SIZES.length) {
                    if (VALID_SIZES[n6].equalsIgnoreCase(string5)) {
                        this.sizeNo = n6;
                    }
                    ++n6;
                }
            }
        }
        this.capFormat = new VideoFormat(VIDEO_COMPRESS[this.compressNo], DEFAULT_DIMENSIONS[this.sizeNo], -1, Format.byteArray, this.getRate());
        this.svCap = new XILCapture(this);
        this.portControl = new LocalPortControl(this, VALID_PORTS, this.portNo);
        this.rateControl = new RateControl(this, 30.0f, 1.0f, 30.0f);
        this.qualityControl = new LocalQualityControl(this, 0.5f, 0.01f, 0.62f);
        this.formatControl = new LocalFormatControl(this);
        this.controls = new Object[4];
        this.controls[0] = this.portControl;
        this.controls[1] = this.rateControl;
        this.controls[2] = this.qualityControl;
        this.controls[3] = this.formatControl;
    }

    public Object getDataType() {
        return Format.byteArray;
    }

    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        this.transferHandler = bufferTransferHandler;
    }

    public void connect() throws IOException {
        Integer n2 = SunVideoLock;
        synchronized (n2) {
            if (this.inUse) {
                throw new IOException("Capture device in use");
            }
            this.inUse = true;
            this.connected = false;
            if (!this.doConnect()) {
                this.inUse = false;
                throw new IOException("Could not connect to capture device");
            }
            this.connected = true;
        }
    }

    private boolean doConnect() {
        if (!this.svCap.connect(this.cardNo, this.portNo)) {
            return false;
        }
        this.setSize(this.sizeNo);
        this.setCompress(this.compressNo);
        this.data = new byte[this.maxDataSize];
        this.nextSequence = 1L;
        return true;
    }

    synchronized void disconnect() {
        if (this.started) {
            try {
                this.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Integer n2 = SunVideoLock;
        synchronized (n2) {
            this.connected = false;
            this.svCap.disconnect();
            this.pt = null;
            this.inUse = false;
        }
    }

    void start() throws IOException {
        if (this.started) {
            return;
        }
        if (!this.svCap.start()) {
            throw new IOException("SunVideoStart failed");
        }
        SunVideoSourceStream sunVideoSourceStream = this;
        synchronized (sunVideoSourceStream) {
            this.started = true;
            if (this.pt == null) {
                Object object;
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = jdk12CreateThreadAction.cons;
                        this.pt = (PushThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$protocol$sunvideo$PushThread == null ? (class$com$sun$media$protocol$sunvideo$PushThread = SunVideoSourceStream.class$("com.sun.media.protocol.sunvideo.PushThread")) : class$com$sun$media$protocol$sunvideo$PushThread, this));
                    }
                    catch (Exception exception) {
                        System.err.println("SunVideoSourceStream: exception when creating thread");
                    }
                } else {
                    this.pt = new PushThread(this);
                }
                if (this.pt != null) {
                    this.pt.start();
                }
            }
            if (this.formatControl != null) {
                this.formatControl.getControlComponent().setEnabled(false);
            }
        }
    }

    void stop() throws IOException {
        this.started = false;
        this.svCap.stop();
        if (this.portControl != null) {
            this.portControl.setEnabled(true);
        }
        if (this.formatControl != null) {
            this.formatControl.getControlComponent().setEnabled(true);
        }
    }

    public void finalize() {
        if (this.connected) {
            this.disconnect();
        }
    }

    boolean getStarted() {
        return this.started;
    }

    boolean getConnected() {
        return this.connected;
    }

    public Format getFormat() {
        return this.capFormat;
    }

    public Format[] getSupportedFormats() {
        return supported;
    }

    byte[] getData() {
        return this.data;
    }

    void setData(byte[] byArray) {
        this.data = byArray;
    }

    void pushData(int n2) {
        this.length = n2;
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    public boolean willReadBlock() {
        return true;
    }

    public void read(Buffer buffer) {
        if (!this.started) {
            buffer.setDiscard(true);
            this.length = 0;
            return;
        }
        Integer n2 = this.readLock;
        synchronized (n2) {
            if (this.length > 0) {
                byte[] byArray = this.data;
                Object object = buffer.getData();
                this.data = object instanceof byte[] && ((byte[])object).length >= this.maxDataSize ? (byte[])object : new byte[this.maxDataSize];
                buffer.setOffset(0);
                buffer.setData(byArray);
                buffer.setLength(this.length);
                buffer.setDiscard(false);
                buffer.setSequenceNumber(this.nextSequence++);
                buffer.setTimeStamp(this.timeStamp);
                buffer.setFlags(buffer.getFlags() | 0x80 | 0x10 | 0x8000);
                buffer.setFormat(this.capFormat);
            } else {
                buffer.setDiscard(true);
            }
            this.length = 0;
        }
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return new CaptureDeviceInfo("SunVideo", this.locator, supported);
    }

    public void setRGBFormat(int n2, int n3, int n4, int n5, int n6) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        Dimension dimension = new Dimension(n4, n5);
        if (n6 == -1) {
            n6 = 3 * n4;
        }
        this.maxDataSize = n6 * n5;
        this.capFormat = new RGBFormat(dimension, this.maxDataSize, Format.byteArray, this.getRate(), 24, 3, 2, 1, 3, n6, 0, -1);
        this.formatControl.setCurrentFormat(this.capFormat);
    }

    public void setJpegFormat(int n2, int n3, int n4, int n5, int n6) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        Dimension dimension = new Dimension(n4, n5);
        this.maxDataSize = n6 > 60 ? 3 * n4 * n5 : 2 * n4 * n5;
        this.capFormat = new JPEGFormat(dimension, this.maxDataSize, Format.byteArray, this.getRate(), this.qualityNo, -1);
        this.formatControl.setCurrentFormat(this.capFormat);
    }

    public void setMpegFormat(int n2, int n3, int n4, int n5, int n6) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        Dimension dimension = new Dimension(n4, n5);
        this.maxDataSize = n6 > 60 ? 3 * n4 * n5 : 2 * n4 * n5;
        this.capFormat = new VideoFormat("mpeg", dimension, this.maxDataSize, Format.byteArray, this.getRate());
        this.formatControl.setCurrentFormat(this.capFormat);
    }

    private void setPort(int n2) {
        this.portNo = n2;
        this.svCap.setPort(this.portNo);
    }

    private void setCompress(String string) {
        if (string != null && string.length() > 0) {
            int n2 = 0;
            while (n2 < VALID_COMPRESS.length) {
                if (VALID_COMPRESS[n2].equalsIgnoreCase(string)) {
                    this.compressNo = n2;
                    if (this.connected) {
                        this.setCompress(this.compressNo);
                    }
                }
                ++n2;
            }
        }
    }

    private void setCompress(int n2) {
        this.compressNo = n2;
        this.svCap.setCompress(VALID_COMPRESS[this.compressNo]);
        if (n2 == 1) {
            this.qualityControl.setEnabled(false);
        } else {
            this.qualityControl.setEnabled(true);
        }
    }

    int getSize() {
        return this.sizeNo;
    }

    void setSize(Dimension dimension) {
        int n2 = 1;
        n2 = dimension.width > 384 ? 1 : (dimension.width >= 320 ? 2 : 4);
        int n3 = 0;
        while (n3 < VALID_SIZES.length) {
            if (VALID_SCALE[n3] == n2) {
                this.sizeNo = n3;
                if (this.connected) {
                    this.setSize(this.sizeNo);
                }
            }
            ++n3;
        }
    }

    void setSize(int n2) {
        this.sizeNo = n2;
        this.svCap.setScale(VALID_SCALE[this.sizeNo]);
    }

    float getSizeFloat() {
        return VALID_SIZES_FLOAT[this.sizeNo];
    }

    float[] getSizesFloat() {
        return VALID_SIZES_FLOAT;
    }

    void setSize(float f2) {
        if (f2 > VALID_SIZES_FLOAT[0]) {
            this.sizeNo = 0;
        } else {
            int n2 = 1;
            while (n2 < VALID_SIZES_FLOAT.length) {
                this.sizeNo = n2;
                if (f2 > VALID_SIZES_FLOAT[n2]) {
                    if (!(VALID_SIZES_FLOAT[n2 - 1] - f2 < f2 - VALID_SIZES_FLOAT[n2])) break;
                    this.sizeNo = n2 - 1;
                    break;
                }
                ++n2;
            }
        }
        this.svCap.setScale(VALID_SCALE[this.sizeNo]);
    }

    float getQuality() {
        return (float)this.qualityNo / 100.0f;
    }

    void setQuality(float f2) {
        this.qualityNo = (int)(f2 * 100.0f + 0.5f);
        this.svCap.setQuality(this.qualityNo);
        if (this.capFormat != null && this.capFormat instanceof JPEGFormat) {
            this.capFormat = new JPEGFormat(this.capFormat == null ? null : this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), this.qualityNo, -1);
        }
    }

    float getRate() {
        if (this.rateNo == 30) {
            return 29.97f;
        }
        return this.rateNo;
    }

    void setRate(float f2) {
        this.rateNo = (int)((double)f2 + 0.5);
        if (this.rateNo <= 0) {
            this.rateNo = 1;
        }
        this.ptDelay = 1000 / this.rateNo;
        if (this.capFormat != null) {
            if ("jpeg".equals(this.capFormat.getEncoding())) {
                this.capFormat = new JPEGFormat(this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), this.qualityNo, -1);
            } else if ("rgb".equals(this.capFormat.getEncoding())) {
                this.capFormat = new RGBFormat(this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), 24, 3, 2, 1, 3, ((RGBFormat)this.capFormat).getLineStride(), 0, -1);
            } else if ("mpeg".equals(this.capFormat.getEncoding())) {
                this.capFormat = new VideoFormat("mpeg", this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate());
            }
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    public Format setFormat(Format format) {
        if (format.equals(this.capFormat)) {
            return this.capFormat;
        }
        Format format2 = null;
        int n2 = 0;
        while (n2 < supported.length) {
            if (format.matches(supported[n2]) && (format2 = format.intersects(supported[n2])) != null) break;
            ++n2;
        }
        if (format2 != null) {
            VideoFormat videoFormat = (VideoFormat)format2;
            if (videoFormat.getEncoding().equals("jpeg")) {
                this.setCompress("Jpeg");
            } else {
                this.setCompress("RGB");
            }
            if (videoFormat.getFrameRate() != -1.0f) {
                this.rateControl.setFrameRate(videoFormat.getFrameRate());
            }
            this.setSize(videoFormat.getSize());
            if (!this.connected) {
                this.capFormat = videoFormat;
            }
        }
        return this.capFormat;
    }

    private void doControlPanelHack() {
        if (this.controlFrame != null) {
            ((Component)this.controlFrame).setVisible(true);
            return;
        }
        this.controlFrame = new Frame("SunVideo Controls");
        this.controlFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)SunVideoSourceStream.this.controlFrame).setVisible(false);
            }
        });
        this.controlFrame.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        panel.add(this.portControl.getControlComponent());
        panel.add(this.formatControl.getControlComponent());
        this.controlFrame.add((Component)panel, "North");
        panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        panel.add(this.rateControl.getControlComponent());
        panel.add(this.qualityControl.getControlComponent());
        this.controlFrame.add((Component)panel, "South");
        this.controlFrame.pack();
        ((Component)this.controlFrame).setVisible(true);
    }

    public Object getOwner() {
        return this.dataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SunVideoLock = new Integer(0);
        VALID_PORTS = new String[]{"S-VHS", "1", "2"};
        VALID_COMPRESS = new String[]{"JPEG", "RGB"};
        VIDEO_COMPRESS = new String[]{"jpeg", "rgb"};
        VALID_SIZES = new String[]{"1", "1/2", "1/4"};
        DEFAULT_DIMENSIONS = new Dimension[]{new Dimension(640, 480), new Dimension(320, 240), new Dimension(160, 120)};
        VALID_SIZES_FLOAT = new float[]{1.0f, 0.5f, 0.25f};
        VALID_SCALE = new int[]{1, 2, 4};
        SIZE_GRANULARITY = 0.25f;
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        supported = new Format[]{new VideoFormat("jpeg", new Dimension(320, 240), -1, Format.byteArray, -1.0f), new VideoFormat("jpeg", new Dimension(160, 120), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(640, 480), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(320, 240), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(160, 120), -1, Format.byteArray, -1.0f), new VideoFormat("jpeg", new Dimension(384, 288), -1, Format.byteArray, -1.0f), new VideoFormat("jpeg", new Dimension(192, 144), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(768, 576), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(384, 288), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(192, 144), -1, Format.byteArray, -1.0f)};
    }

    class LocalFormatControl
    implements FormatControl,
    Owned {
        private SunVideoSourceStream stream;
        private VideoFormatChooser vfc;

        public LocalFormatControl(SunVideoSourceStream sunVideoSourceStream2) {
            this.stream = sunVideoSourceStream2;
        }

        public void setCurrentFormat(Format format) {
            if (this.vfc != null) {
                this.vfc.setCurrentFormat((VideoFormat)format);
            }
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public Format getFormat() {
            return this.stream.getFormat();
        }

        public Format setFormat(Format format) {
            Format format2 = this.stream.setFormat(format);
            this.setCurrentFormat(format2);
            return format2;
        }

        public Format[] getSupportedFormats() {
            return this.stream.getSupportedFormats();
        }

        public boolean isEnabled() {
            return XILCapture.isAvailable();
        }

        public void setEnabled(boolean bl) {
        }

        public Component getControlComponent() {
            if (this.vfc == null) {
                this.vfc = new VideoFormatChooser(this.stream.getSupportedFormats(), (VideoFormat)this.stream.getFormat());
                if (SunVideoSourceStream.this.started || !XILCapture.isAvailable()) {
                    this.vfc.setEnabled(false);
                }
            }
            return this.vfc;
        }
    }

    class LocalQualityControl
    extends QualityAdapter
    implements Owned {
        SunVideoSourceStream stream;

        public LocalQualityControl(SunVideoSourceStream sunVideoSourceStream2, float f2, float f3, float f4) {
            super(f2, f3, f4, true);
            this.stream = sunVideoSourceStream2;
        }

        public void setEnabled(boolean bl) {
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public float getQuality() {
            return this.stream.getQuality();
        }

        public float setQuality(float f2) {
            if (f2 > this.maxValue) {
                f2 = this.maxValue;
            }
            if (f2 < this.minValue) {
                f2 = this.minValue;
            }
            this.stream.setQuality(f2);
            return super.setQuality(this.stream.getQuality());
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return false;
        }
    }

    class RateControl
    extends FrameRateAdapter
    implements Owned {
        SunVideoSourceStream stream;

        public RateControl(SunVideoSourceStream sunVideoSourceStream2, float f2, float f3, float f4) {
            super(f2, f3, f4, true);
            this.stream = sunVideoSourceStream2;
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public float getFrameRate() {
            return this.stream.getRate();
        }

        public float setFrameRate(float f2) {
            if (f2 < this.min) {
                f2 = this.min;
            }
            if (f2 > this.max) {
                f2 = this.max;
            }
            this.stream.setRate(f2);
            return super.setFrameRate(this.stream.getRate());
        }
    }

    class LocalPortControl
    extends AtomicControlAdapter
    implements Owned,
    PortControl,
    ControlChangeListener,
    ItemListener {
        SunVideoSourceStream stream;
        String[] validPorts = null;
        int currentPort = 0;
        Panel panel = null;
        Label labelPort = null;
        Choice comboPort = null;
        int[] PC_PORTS = new int[]{64, 128, 512};

        public LocalPortControl(SunVideoSourceStream sunVideoSourceStream2, String[] stringArray, int n2) {
            super(new Choice(), false, null);
            this.stream = sunVideoSourceStream2;
            this.validPorts = stringArray;
            this.currentPort = n2;
            this.addControlChangeListener(this);
        }

        public synchronized CaptureDeviceInfo getCaptureDeviceInfo() {
            return this.stream.getCaptureDeviceInfo();
        }

        public String getPort() {
            return this.validPorts[this.currentPort];
        }

        public void setPort(String string) {
            int n2 = 0;
            while (n2 < this.validPorts.length) {
                if (this.validPorts[n2].equalsIgnoreCase(string)) {
                    this.currentPort = n2;
                    this.stream.setPort(this.currentPort);
                    this.informListeners();
                    return;
                }
                ++n2;
            }
            System.err.println("SunVideoSourceStream.setPort() invalid port: " + string);
        }

        public Component getControlComponent() {
            if (this.panel == null) {
                this.panel = new Panel(new BorderLayout(6, 6));
                this.labelPort = new Label("Port:", 2);
                this.panel.add((Component)this.labelPort, "West");
                this.comboPort = (Choice)super.getControlComponent();
                this.comboPort.addItemListener(this);
                this.panel.add((Component)this.comboPort, "Center");
                int n2 = 0;
                while (n2 < this.validPorts.length) {
                    this.comboPort.add(this.validPorts[n2]);
                    ++n2;
                }
                this.comboPort.select(this.validPorts[this.currentPort]);
                this.comboPort.addItemListener(this);
            }
            return this.panel;
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public int getPorts() {
            return this.PC_PORTS[this.currentPort];
        }

        public int getSupportedPorts() {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.PC_PORTS.length) {
                n2 |= this.PC_PORTS[n3];
                ++n3;
            }
            return n2;
        }

        public int setPorts(int n2) {
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.PC_PORTS.length) {
                if (n2 == this.PC_PORTS[n4]) {
                    this.currentPort = n4;
                    this.stream.setPort(this.currentPort);
                    this.informListeners();
                    break;
                }
                ++n4;
            }
            return this.PC_PORTS[this.currentPort];
        }

        public void controlChanged(ControlChangeEvent controlChangeEvent) {
            if (this.comboPort != null) {
                this.comboPort.select(this.validPorts[this.currentPort]);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = this.comboPort.getSelectedItem();
                this.setPort(string);
            }
        }
    }
}

