/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.sunvideoplus;

import com.sun.media.JMFSecurityManager;
import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.sunvideoplus.OPISourceStream;
import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.Duration;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;
import javax.media.protocol.SourceStream;

public class DataSource
extends BasicPushBufferDataSource
implements CaptureDevice,
RateConfigureable {
    PushBufferStream[] streams = new PushBufferStream[0];
    OPISourceStream sourceStream = null;
    String contentType;
    Time duration;
    boolean connected = false;
    boolean started = false;
    static String ContentType = "raw";

    public DataSource() {
        JMFSecurityManager.checkCapture();
        this.contentType = ContentType;
        this.duration = Duration.DURATION_UNBOUNDED;
    }

    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            System.err.println("DataSource needs to be connected before calling getStreams");
            return null;
        }
        return this.streams;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.sourceStream == null) {
            this.sourceStream = new OPISourceStream(this);
            this.streams = new PushBufferStream[1];
            this.streams[0] = this.sourceStream;
        }
        return this.sourceStream.getCaptureDeviceInfo();
    }

    public FormatControl[] getFormatControls() {
        if (this.sourceStream == null) {
            this.sourceStream = new OPISourceStream(this);
            this.streams = new PushBufferStream[1];
            this.streams[0] = this.sourceStream;
        }
        FormatControl[] formatControlArray = new FormatControl[]{(FormatControl)this.sourceStream.getControl("javax.media.control.FormatControl")};
        return formatControlArray;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.sourceStream == null) {
            this.sourceStream = new OPISourceStream(this);
            this.streams = new PushBufferStream[1];
            this.streams[0] = this.sourceStream;
        }
        this.sourceStream.connect();
        this.connected = true;
    }

    public void disconnect() {
        this.sourceStream.disconnect();
        this.connected = false;
    }

    public void start() throws IOException {
        if (this.started) {
            return;
        }
        this.sourceStream.start();
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.started) {
            return;
        }
        this.sourceStream.stop();
        this.started = false;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Time getDuration() {
        return this.duration;
    }

    boolean getStarted() {
        return this.started;
    }

    public Object[] getControls() {
        if (this.sourceStream != null) {
            return this.sourceStream.getControls();
        }
        return null;
    }

    public Object getControl(String string) {
        if (this.sourceStream != null) {
            return this.sourceStream.getControl(string);
        }
        return null;
    }

    public RateConfiguration[] getRateConfigurations() {
        RateConfiguration[] rateConfigurationArray = new RateConfiguration[]{new OneRateConfig()};
        return rateConfigurationArray;
    }

    public RateConfiguration setRateConfiguration(RateConfiguration rateConfiguration) {
        return rateConfiguration;
    }

    class OneRateConfig
    implements RateConfiguration {
        OneRateConfig() {
        }

        public RateRange getRate() {
            return new RateRange(1.0f, 1.0f, 1.0f, true);
        }

        public SourceStream[] getStreams() {
            SourceStream[] sourceStreamArray = new SourceStream[]{DataSource.this.sourceStream};
            return sourceStreamArray;
        }
    }
}

