/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.sunvideoplus;

import com.sun.media.JMFSecurityManager;
import java.io.IOException;
import javax.media.protocol.SourceStream;

public class OPICapture {
    private static boolean available = false;
    private static Integer OPILock = new Integer(1);
    private long peer;
    private SourceStream stream;

    public static boolean isAvailable() {
        return available;
    }

    public OPICapture(SourceStream sourceStream) {
        this.stream = sourceStream;
    }

    public boolean connect(int n2) {
        return this.connect(n2, 1);
    }

    public boolean connect(int n2, int n3) {
        if (available) {
            Integer n4 = OPILock;
            synchronized (n4) {
                boolean bl = this.opiConnect(n2, n3);
                return bl;
            }
        }
        return false;
    }

    public boolean setPort(int n2) {
        if (available) {
            Integer n3 = OPILock;
            synchronized (n3) {
                boolean bl = this.opiSetPort(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setSignal(String string) {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                boolean bl = this.opiSetSignal(string);
                return bl;
            }
        }
        return false;
    }

    public boolean setCompress(String string) {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                boolean bl = this.opiSetCompress(string);
                return bl;
            }
        }
        return false;
    }

    public boolean setScale(int n2) {
        if (available) {
            Integer n3 = OPILock;
            synchronized (n3) {
                boolean bl = this.opiSetScale(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setFrameRate(int n2) {
        if (available) {
            Integer n3 = OPILock;
            synchronized (n3) {
                boolean bl = this.opiSetFrameRate(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setQuality(int n2) {
        if (available) {
            Integer n3 = OPILock;
            synchronized (n3) {
                boolean bl = this.opiSetQuality(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setBitRate(int n2) {
        if (available) {
            Integer n3 = OPILock;
            synchronized (n3) {
                boolean bl = this.opiSetBitRate(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean start() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                boolean bl = this.opiStart();
                return bl;
            }
        }
        return false;
    }

    public int read(byte[] byArray, int n2) throws IOException {
        int n3 = 0;
        if (available) {
            Integer n4 = OPILock;
            synchronized (n4) {
                n3 = this.opiRead(byArray, n2);
            }
            if (n3 < 0) {
                throw new IOException("OPICapture read() failed");
            }
        } else {
            throw new IOException("OPICapture shared library not available");
        }
        return n3;
    }

    public int getWidth() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                int n3 = this.opiGetWidth();
                return n3;
            }
        }
        return 0;
    }

    public int getHeight() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                int n3 = this.opiGetHeight();
                return n3;
            }
        }
        return 0;
    }

    public int getLineStride() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                int n3 = this.opiGetLineStride();
                return n3;
            }
        }
        return 0;
    }

    public boolean stop() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                boolean bl = this.opiStop();
                return bl;
            }
        }
        return false;
    }

    public boolean disconnect() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                boolean bl = this.opiDisconnect();
                return bl;
            }
        }
        return false;
    }

    public void finalize() {
        if (available) {
            Integer n2 = OPILock;
            synchronized (n2) {
                this.opiDisconnect();
            }
        }
    }

    private static native boolean cacheFieldIDs();

    private static native boolean opiInitialize();

    private native boolean opiLittleEndian();

    private native boolean opiConnect(int var1, int var2);

    private native boolean opiSetPort(int var1);

    private native boolean opiSetSignal(String var1);

    private native boolean opiSetCompress(String var1);

    private native boolean opiSetScale(int var1);

    private native boolean opiSetFrameRate(int var1);

    private native boolean opiSetQuality(int var1);

    private native boolean opiSetBitRate(int var1);

    private native boolean opiStart();

    private native int opiRead(byte[] var1, int var2);

    private native int opiGetWidth();

    private native int opiGetHeight();

    private native int opiGetLineStride();

    private native boolean opiStop();

    private native boolean opiDisconnect();

    static {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmopi");
            if (OPICapture.opiInitialize() && OPICapture.cacheFieldIDs()) {
                available = true;
            } else {
                System.err.println("OPICapture initialize failed");
            }
        }
        catch (Exception exception) {
            System.err.println("OPICapture initialize failed: " + exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("OPICapture initialize failed: " + unsatisfiedLinkError);
        }
    }
}

