/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.ExtBuffer;
import com.sun.media.renderer.video.HeavyComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;

public abstract class BasicVideoRenderer
extends BasicPlugIn
implements VideoRenderer,
FrameGrabbingControl {
    protected String name;
    protected transient VideoFormat[] supportedFormats = null;
    protected VideoFormat inputFormat = null;
    protected int outWidth = -1;
    protected int outHeight = -1;
    protected int inWidth = -1;
    protected int inHeight = -1;
    protected Component component = null;
    protected ComponentListener compListener = null;
    protected boolean componentAvailable = false;
    protected Rectangle bounds = null;
    protected boolean started = false;
    protected Control[] controls = null;
    protected FrameGrabbingControl frameGrabber = null;
    protected ExtBuffer lastBuffer = new ExtBuffer();
    protected Object lastData = null;
    protected Object lastHdr = null;

    public BasicVideoRenderer(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void close() {
    }

    public void reset() {
    }

    public int process(Buffer buffer) {
        int n2;
        if (buffer.getLength() == 0) {
            return 0;
        }
        ExtBuffer extBuffer = this.lastBuffer;
        synchronized (extBuffer) {
            n2 = this.doProcess(buffer);
            if (n2 == 0) {
                this.lastBuffer.copy(buffer, true);
            }
        }
        return n2;
    }

    protected abstract int doProcess(Buffer var1);

    public Format setInputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.supportedFormats) != null) {
            this.inputFormat = (VideoFormat)format;
            Dimension dimension = this.inputFormat.getSize();
            if (dimension != null) {
                this.inWidth = dimension.width;
                this.inHeight = dimension.height;
            }
            return format;
        }
        return null;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Component getComponent() {
        if (this.component == null) {
            try {
                Class<?> clazz = Class.forName("com.sun.media.renderer.video.MSHeavyComponent");
                if (clazz != null) {
                    this.component = (Component)clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                this.component = new HeavyComponent();
            }
            ((HeavyComponent)this.component).setRenderer(this);
            this.component.setBackground(this.getPreferredBackground());
            if (this.compListener == null) {
                this.compListener = new CompListener();
            }
            this.component.addComponentListener(this.compListener);
        }
        return this.component;
    }

    public synchronized boolean setComponent(Component component) {
        this.reset();
        this.component = component;
        if (this.compListener == null) {
            this.compListener = new CompListener();
        }
        this.component.addComponentListener(this.compListener);
        return true;
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected Color getPreferredBackground() {
        return Color.black;
    }

    void resized(Component component) {
        if (component != null && component == this.component) {
            Dimension dimension = this.component.getSize();
            this.outWidth = dimension.width;
            this.outHeight = dimension.height;
        }
    }

    protected synchronized void setAvailable(boolean bl) {
        this.componentAvailable = bl;
        if (!this.componentAvailable) {
            this.removingComponent();
        }
    }

    protected void removingComponent() {
    }

    protected Dimension myPreferredSize() {
        return new Dimension(this.inWidth, this.inHeight);
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void repaint() {
        System.err.println("repaint call not implemented on this renderer");
    }

    public Object[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        this.frameGrabber = this;
        this.controls = new Control[1];
        this.controls[0] = this.frameGrabber;
        return this.controls;
    }

    public Component getControlComponent() {
        return null;
    }

    public Buffer grabFrame() {
        ExtBuffer extBuffer = this.lastBuffer;
        synchronized (extBuffer) {
            Object[] objectArray;
            Buffer buffer = new Buffer();
            buffer.setFormat(this.lastBuffer.getFormat());
            buffer.setFlags(this.lastBuffer.getFlags());
            buffer.setLength(this.lastBuffer.getLength());
            buffer.setOffset(0);
            buffer.setHeader(this.lastBuffer.getHeader());
            buffer.setData(this.lastBuffer.getData());
            Object object = this.lastBuffer.getData();
            int n2 = this.lastBuffer.getLength();
            if (object instanceof byte[]) {
                objectArray = new byte[n2];
            } else if (object instanceof short[]) {
                objectArray = new short[n2];
            } else if (object instanceof int[]) {
                objectArray = new int[n2];
            } else {
                Buffer buffer2 = buffer;
                return buffer2;
            }
            System.arraycopy(object, this.lastBuffer.getOffset(), objectArray, 0, n2);
            buffer.setData(objectArray);
            Buffer buffer3 = buffer;
            return buffer3;
        }
    }

    public class CompListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            BasicVideoRenderer.this.resized(componentEvent.getComponent());
        }
    }
}

