/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.NumericControl;
import com.sun.media.ui.BasicComp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Slider
extends BasicComp
implements MouseListener,
MouseMotionListener {
    Image imageGrabber = BasicComp.fetchImage("grabber.gif");
    Image imageGrabberX;
    Image imageGrabberDown = BasicComp.fetchImage("grabber-pressed.gif");
    Graphics paintG = null;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 8;
    int rightBorder = 8;
    int sliderWidth;
    int width;
    int height;
    int displayPercent;
    float[] detents;
    Dimension dimension;
    float lower = 0.0f;
    float upper = 1.0f;
    float range = 1.0f;
    float value = 0.5f;
    boolean dragging = false;
    boolean grabberVisible = true;

    public Slider() {
        this(null, null);
    }

    public Slider(float[] fArray) {
        this(fArray, null);
    }

    public Slider(float[] fArray, Color color) {
        super("Slider");
        this.imageGrabberX = BasicComp.fetchImage("grabber-disabled.gif");
        this.detents = fArray;
        if (color != null) {
            this.setBackground(color);
        }
        this.width = 115;
        this.height = 18;
        this.displayPercent = 100;
        this.dimension = new Dimension(this.width, this.height);
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.grabbed = false;
        this.entered = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public Point getPosition() {
        return new Point(this.grabberPosition + this.leftBorder, 10);
    }

    public void setDisplayPercent(int n2) {
        if (n2 != this.displayPercent) {
            this.displayPercent = n2;
            if (this.displayPercent > 100) {
                this.displayPercent = 100;
            } else if (this.displayPercent < 0) {
                this.displayPercent = 0;
            }
            this.repaint();
        }
    }

    public boolean isGrabberVisible() {
        return this.grabberVisible;
    }

    public void setGrabberVisible(boolean bl) {
        if (this.grabberVisible != bl) {
            this.grabberVisible = bl;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n2 = dimension.height / 2 - 2;
        this.paintG = graphics;
        int n3 = this.grabberPosition + this.leftBorder - 5;
        graphics.setColor(this.getBackground().darker());
        graphics.drawRect(this.leftBorder, n2, this.sliderWidth, 3);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(this.leftBorder, n2, this.sliderWidth * this.displayPercent / 100, 3, false);
        if (this.detents != null && this.detents.length != 0) {
            this.paintG.setColor(Color.black);
            int n4 = 0;
            while (n4 < this.detents.length) {
                int n5 = this.leftBorder + (int)(this.detents[n4] * (float)this.sliderWidth / this.range);
                this.paintG.drawLine(n5, 12, n5, 15);
                ++n4;
            }
        }
        if (this.grabberVisible) {
            Image image = this.isEnabled() ? (this.grabbed || this.entered ? this.imageGrabberDown : this.imageGrabber) : this.imageGrabberX;
            this.paintG.drawImage(image, n3, 4, this);
        }
    }

    private int limitGrabber(int n2) {
        int n3 = n2 - this.leftBorder;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.sliderWidth) {
            n3 = this.sliderWidth;
        }
        return n3;
    }

    private void setSliderPosition(float f2, float f3) {
        this.grabberPosition = (int)(f2 / f3 * (float)this.sliderWidth);
    }

    private void seek() {
        if (this.control != null && this.control instanceof NumericControl) {
            float f2;
            NumericControl numericControl = (NumericControl)this.control;
            float f3 = numericControl.getLowerLimit();
            float f4 = numericControl.getUpperLimit();
            float f5 = (float)this.grabberPosition / (float)this.sliderWidth * (f4 - f3) + f3;
            if (this.detents != null && this.detents.length > 0 && this.dragging) {
                f2 = (f4 - f3) * 0.05f;
                int n2 = 0;
                while (n2 < this.detents.length) {
                    if (Math.abs(this.detents[n2] - f5) <= f2) {
                        f5 = this.detents[n2];
                    }
                    ++n2;
                }
            }
            if (f5 != (f2 = numericControl.setValue(f5))) {
                this.setSliderPosition(f2 - f3, f4 - f3);
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) == 0 && (n2 & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = true;
            this.grabberPosition = this.limitGrabber(mouseEvent.getX());
            this.seek();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) == 0 && (n2 & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) == 0 && (n2 & 4) == 0 && this.isEnabled()) {
            this.dragging = true;
            this.grabberPosition = this.limitGrabber(mouseEvent.getX());
            this.seek();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.entered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.entered = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
        this.paintG = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }
}

