/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.rtp.util.Signed;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import javax.media.rtp.SessionManager;
import javax.media.rtp.rtcp.SenderReport;
import jmapps.rtp.ViewSourceDescription;
import jmapps.ui.JMPanel;

public class ViewSenderReport
extends JMPanel {
    private SessionManager mngrSession;
    private SenderReport reportSender;
    private ViewSourceDescription panelSrcDescr = null;
    private JMPanel panelLabels = null;
    private JMPanel panelData = null;
    private Label fieldSSRC;
    private Label fieldNtpTimestampLsw;
    private Label fieldNtpTimestampMsw;
    private Label fieldRtpTimestamp;
    private Label fieldBytes;
    private Label fieldPackets;
    private static final String LABEL_SSRC = JMFI18N.getResource("jmstudio.rtpsessionctrl.report.ssrc");
    private static final String LABEL_NTP_TIMESTAMP_LSW = JMFI18N.getResource("jmstudio.rtpsessionctrl.report.ntptimestamplsw");
    private static final String LABEL_NTP_TIMESTAMP_MSW = JMFI18N.getResource("jmstudio.rtpsessionctrl.report.ntptimestampmsw");
    private static final String LABEL_RTP_TIMESTAMP = JMFI18N.getResource("jmstudio.rtpsessionctrl.report.rtptimestamp");
    private static final String LABEL_BYTES = JMFI18N.getResource("jmstudio.rtpsessionctrl.report.bytecount");
    private static final String LABEL_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.report.packetcount");

    public ViewSenderReport(SessionManager sessionManager, SenderReport senderReport) {
        this.mngrSession = sessionManager;
        this.reportSender = senderReport;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        this.add((Component)jMPanel, "North");
        this.panelLabels = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel.add((Component)this.panelLabels, "West");
        this.panelData = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel.add((Component)this.panelData, "Center");
        Label label = new Label(LABEL_SSRC);
        this.panelLabels.add(label);
        this.fieldSSRC = new Label();
        this.panelData.add(this.fieldSSRC);
        label = new Label(LABEL_NTP_TIMESTAMP_LSW);
        this.panelLabels.add(label);
        this.fieldNtpTimestampLsw = new Label();
        this.panelData.add(this.fieldNtpTimestampLsw);
        label = new Label(LABEL_NTP_TIMESTAMP_MSW);
        this.panelLabels.add(label);
        this.fieldNtpTimestampMsw = new Label();
        this.panelData.add(this.fieldNtpTimestampMsw);
        label = new Label(LABEL_RTP_TIMESTAMP);
        this.panelLabels.add(label);
        this.fieldRtpTimestamp = new Label();
        this.panelData.add(this.fieldRtpTimestamp);
        label = new Label(LABEL_BYTES);
        this.panelLabels.add(label);
        this.fieldBytes = new Label();
        this.panelData.add(this.fieldBytes);
        label = new Label(LABEL_PACKETS);
        this.panelLabels.add(label);
        this.fieldPackets = new Label();
        this.panelData.add(this.fieldPackets);
        jMPanel = new JMPanel(new BorderLayout(6, 6));
        this.add((Component)jMPanel, "Center");
        this.panelSrcDescr = new ViewSourceDescription(this.reportSender.getSourceDescription());
        jMPanel.add((Component)this.panelSrcDescr, "North");
        this.updateFields(this.reportSender);
    }

    public void updateFields(SenderReport senderReport) {
        if (senderReport == null) {
            return;
        }
        this.reportSender = senderReport;
        long l2 = senderReport.getSSRC();
        this.fieldSSRC.setText(this.longToString(l2));
        l2 = senderReport.getNTPTimeStampLSW();
        this.fieldNtpTimestampLsw.setText(this.longToString(l2));
        l2 = senderReport.getNTPTimeStampMSW();
        this.fieldNtpTimestampMsw.setText(this.longToString(l2));
        l2 = senderReport.getRTPTimeStamp();
        this.fieldRtpTimestamp.setText(this.longToString(l2));
        l2 = senderReport.getSenderByteCount();
        this.fieldBytes.setText(this.longToString(l2));
        l2 = senderReport.getSenderPacketCount();
        this.fieldPackets.setText(this.longToString(l2));
    }

    private String longToString(long l2) {
        if (l2 < 0L) {
            l2 = Signed.UnsignedInt((int)l2);
        }
        return "" + l2;
    }
}

