/*
 * Decompiled with CFR 0.152.
 */
package jmapps.util;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.util.JMFI18N;
import java.awt.Frame;
import java.io.IOException;
import java.net.InetAddress;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.Effect;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import jmapps.ui.MessageDialog;
import jmapps.util.StateHelper;

public class JMFUtils {
    public static MediaPlayer createMediaPlayer(String string, Frame frame, String string2, String string3) {
        Processor processor;
        MediaPlayer mediaPlayer;
        MediaLocator mediaLocator;
        block13: {
            mediaLocator = null;
            mediaPlayer = null;
            processor = null;
            mediaLocator = new MediaLocator(string);
            if (mediaLocator == null || string.equals("")) {
                MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.buildurlfor") + " " + string);
                return null;
            }
            if (string2 != null || string3 != null) {
                try {
                    Processor processor2 = Manager.createProcessor(mediaLocator);
                    StateHelper stateHelper = new StateHelper(processor2);
                    if (stateHelper.configure()) {
                        TrackControl[] trackControlArray = processor2.getTrackControls();
                        int n2 = 0;
                        while (n2 < trackControlArray.length) {
                            if (string2 != null && trackControlArray[n2].isEnabled() && trackControlArray[n2].getFormat() instanceof AudioFormat) {
                                JMFUtils.assignEffect(trackControlArray[n2], string2);
                            } else if (string3 != null && trackControlArray[n2].isEnabled() && trackControlArray[n2].getFormat() instanceof VideoFormat) {
                                JMFUtils.assignEffect(trackControlArray[n2], string3);
                            }
                            ++n2;
                        }
                        processor2.setContentDescriptor(null);
                        if (stateHelper.realize()) {
                            processor = processor2;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block13;
                    throw (ThreadDeath)throwable;
                }
            }
        }
        mediaPlayer = new MediaPlayer();
        if (processor == null) {
            mediaPlayer.setMediaLocator(mediaLocator);
        } else {
            mediaPlayer.setControlPanelVisible(false);
            mediaPlayer.setPlayer(processor);
        }
        if (mediaPlayer.getPlayer() == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + string);
            return null;
        }
        return mediaPlayer;
    }

    public static MediaPlayer createMediaPlayer(DataSource dataSource, Frame frame) {
        MediaPlayer mediaPlayer = null;
        if (dataSource == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + dataSource);
            return null;
        }
        mediaPlayer = new MediaPlayer();
        mediaPlayer.setDataSource(dataSource);
        if (mediaPlayer.getPlayer() == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + dataSource);
            return null;
        }
        return mediaPlayer;
    }

    public static MediaPlayer createMediaPlayer(Player player, Frame frame) {
        MediaPlayer mediaPlayer = null;
        if (player == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + player);
            return null;
        }
        mediaPlayer = new MediaPlayer();
        mediaPlayer.setPlayer(player);
        if (mediaPlayer.getPlayer() == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + player);
            return null;
        }
        return mediaPlayer;
    }

    private static void assignEffect(TrackControl trackControl, String string) {
        block2: {
            try {
                Class<?> clazz = Class.forName(string);
                Effect effect = (Effect)clazz.newInstance();
                Codec[] codecArray = new Codec[]{effect};
                trackControl.setCodecChain(codecArray);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)throwable;
            }
        }
    }

    public static DataSource createCaptureDataSource(String string, Format format, String string2, Format format2) {
        DataSource dataSource = null;
        DataSource dataSource2 = null;
        DataSource dataSource3 = null;
        if (string == null && string2 == null) {
            return null;
        }
        if (string == null || string2 == null) {
            dataSource = string != null ? JMFUtils.initializeCaptureDataSource(null, string, format) : JMFUtils.initializeCaptureDataSource(null, string2, format2);
        } else if (!string.equals(string2)) {
            dataSource = JMFUtils.initializeCaptureDataSource(null, string, format);
            if (dataSource == null) {
                return null;
            }
            dataSource2 = JMFUtils.initializeCaptureDataSource(null, string2, format2);
            if (dataSource2 == null) {
                return null;
            }
            DataSource[] dataSourceArray = new DataSource[]{dataSource, dataSource2};
            try {
                dataSource3 = Manager.createMergingDataSource(dataSourceArray);
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                // empty catch block
            }
            dataSource = dataSource3;
        } else {
            dataSource = JMFUtils.initializeCaptureDataSource(null, string, format);
            if (dataSource == null) {
                return null;
            }
            dataSource = JMFUtils.initializeCaptureDataSource(dataSource, string2, format2);
        }
        if (dataSource == null) {
            return null;
        }
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        return dataSource;
    }

    public static DataSource initializeCaptureDataSource(DataSource dataSource, String string, Format format) {
        DataSource dataSource2 = dataSource;
        if (dataSource == null) {
            CaptureDeviceInfo captureDeviceInfo = CaptureDeviceManager.getDevice(string);
            if (captureDeviceInfo == null) {
                return null;
            }
            MediaLocator mediaLocator = captureDeviceInfo.getLocator();
            try {
                dataSource2 = Manager.createDataSource(mediaLocator);
                if (dataSource2 == null) {
                    return null;
                }
            }
            catch (NoDataSourceException noDataSourceException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (format == null) {
            return dataSource2;
        }
        if (format != null && !(dataSource2 instanceof CaptureDevice)) {
            return null;
        }
        FormatControl[] formatControlArray = ((CaptureDevice)((Object)dataSource2)).getFormatControls();
        if (formatControlArray == null || formatControlArray.length == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < formatControlArray.length) {
            if (formatControlArray[n2] != null) {
                Format[] formatArray = formatControlArray[n2].getSupportedFormats();
                if (formatArray == null) {
                    return null;
                }
                if (JMFUtils.matches(format, formatArray) != null) {
                    formatControlArray[n2].setFormat(format);
                    return dataSource2;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Format matches(Format format, Format[] formatArray) {
        if (formatArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < formatArray.length) {
            if (formatArray[n2].matches(format)) {
                return formatArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public static RTPSessionMgr createSessionManager(String string, String string2, String string3, ReceiveStreamListener receiveStreamListener) {
        int n2 = Integer.valueOf(string2);
        int n3 = Integer.valueOf(string3);
        RTPSessionMgr rTPSessionMgr = JMFUtils.createSessionManager(string, n2, n3, receiveStreamListener);
        return rTPSessionMgr;
    }

    public static RTPSessionMgr createSessionManager(String string, int n2, int n3, ReceiveStreamListener receiveStreamListener) {
        String string2 = null;
        RTPSessionMgr rTPSessionMgr = (RTPSessionMgr)RTPManager.newInstance();
        if (rTPSessionMgr == null) {
            return null;
        }
        if (receiveStreamListener != null) {
            rTPSessionMgr.addReceiveStreamListener(receiveStreamListener);
        }
        String string3 = rTPSessionMgr.generateCNAME();
        try {
            string2 = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            string2 = "jmf-user";
        }
        SessionAddress sessionAddress = new SessionAddress();
        try {
            SessionAddress sessionAddress2;
            SessionAddress sessionAddress3;
            InetAddress inetAddress = InetAddress.getByName(string);
            SessionAddress sessionAddress4 = new SessionAddress(inetAddress, n2, inetAddress, n2 + 1);
            if (inetAddress.isMulticastAddress()) {
                sessionAddress3 = new SessionAddress(inetAddress, n2, n3);
                sessionAddress2 = new SessionAddress(inetAddress, n2, n3);
            } else {
                sessionAddress3 = new SessionAddress(InetAddress.getLocalHost(), n2);
                sessionAddress2 = new SessionAddress(inetAddress, n2);
            }
            rTPSessionMgr.initialize(sessionAddress3);
            rTPSessionMgr.addTarget(sessionAddress2);
        }
        catch (Exception exception) {
            return null;
        }
        return rTPSessionMgr;
    }
}

