/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.Struct;

public abstract class ByteArrayStruct
extends Struct {
    protected byte[] bytes;

    protected ByteArrayStruct(int sizeInBytes) {
        this.bytes = new byte[sizeInBytes];
    }

    protected final byte getByteAt(int offset) {
        return this.bytes[offset];
    }

    protected short getShortAt(int offset) {
        return (short)(this.bytes[offset + Struct.SHORT_HIGH_BYTE_OFFSET] << 8 | this.bytes[offset + Struct.SHORT_LOW_BYTE_OFFSET] & 0xFF);
    }

    protected int getIntAt(int offset) {
        return this.bytes[offset + Struct.INT_HIGH_BYTE_OFFSET] << 24 | (this.bytes[offset + Struct.INT_THREE_BYTE_OFFSET] & 0xFF) << 16 | (this.bytes[offset + Struct.INT_TWO_BYTE_OFFSET] & 0xFF) << 8 | this.bytes[offset + Struct.INT_LOW_BYTE_OFFSET] & 0xFF;
    }

    protected final void setByteAt(int offset, byte value) {
        this.bytes[offset] = value;
    }

    protected final void setShortAt(int offset, short value) {
        this.bytes[offset + Struct.SHORT_HIGH_BYTE_OFFSET] = (byte)(value >>> 8 & 0xFF);
        this.bytes[offset + Struct.SHORT_LOW_BYTE_OFFSET] = (byte)(value & 0xFF);
    }

    protected final void setIntAt(int offset, int value) {
        this.bytes[offset + Struct.INT_HIGH_BYTE_OFFSET] = (byte)(value >>> 24 & 0xFF);
        this.bytes[offset + Struct.INT_THREE_BYTE_OFFSET] = (byte)(value >>> 16 & 0xFF);
        this.bytes[offset + Struct.INT_TWO_BYTE_OFFSET] = (byte)(value >>> 8 & 0xFF);
        this.bytes[offset + Struct.INT_LOW_BYTE_OFFSET] = (byte)(value & 0xFF);
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        int byteCount = source.length;
        int i = 0;
        while (i < byteCount) {
            this.bytes[byteOffset + i] = source[i];
            ++i;
        }
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int byteCount = src.getSize();
        byte[] srcBytes = src.getBytesAt(0, byteCount);
        int i = 0;
        while (i < byteCount) {
            this.bytes[byteOffset + i] = srcBytes[i];
            ++i;
        }
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        int i = 0;
        while (i < byteCount) {
            result[i] = this.bytes[byteOffset + i];
            ++i;
        }
        return result;
    }

    public byte[] getBytes() {
        byte[] newBytes = new byte[this.bytes.length];
        int i = 0;
        while (i < this.bytes.length) {
            newBytes[i] = this.bytes[i];
            ++i;
        }
        return newBytes;
    }

    public final byte[] getByteArray() {
        return this.getArray();
    }

    public final byte[] getArray() {
        return this.bytes;
    }

    public final int getSize() {
        return this.bytes.length;
    }
}

