/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public class CharArrayStruct
extends Struct {
    protected char[] chars;
    private int logicalSize;

    protected CharArrayStruct(int sizeInBytes) {
        this.logicalSize = sizeInBytes;
        this.chars = new char[(sizeInBytes + 1) / 2];
    }

    protected final byte getByteAt(int byteOffset) {
        char temp = this.chars[byteOffset / 2];
        if (byteOffset % 2 == 0 == Struct.IS_BIG_ENDIAN) {
            return (byte)(temp >>> 8);
        }
        return (byte)(temp & 0xFF);
    }

    protected final char getCharAt(int byteOffset) {
        if (byteOffset % 2 == 0) {
            return this.chars[byteOffset / 2];
        }
        return super.getCharAt(byteOffset);
    }

    protected short getShortAt(int byteOffset) {
        return (short)this.getCharAt(byteOffset);
    }

    protected void setByteAt(int byteOffset, byte value) {
        char temp = this.chars[byteOffset / 2];
        this.chars[byteOffset / 2] = byteOffset % 2 == 0 == Struct.IS_BIG_ENDIAN ? (char)(this.chars[byteOffset / 2] & 0xFF | value << 8) : (char)(this.chars[byteOffset / 2] & 0xFF00 | value);
    }

    protected final void setCharAt(int byteOffset, char value) {
        if (byteOffset % 2 == 0) {
            this.chars[byteOffset / 2] = value;
        } else {
            super.setCharAt(byteOffset, value);
        }
    }

    protected void setShortAt(int byteOffset, short value) {
        this.setCharAt(byteOffset, (char)value);
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToArray(source, 0, this.chars, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int srcByteCount = src.getSize();
        ArrayCopy.copyArrayToArray(src.getBytesAt(0, srcByteCount), 0, this.chars, byteOffset, srcByteCount);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        ArrayCopy.copyArrayToArray(this.chars, byteOffset, result, 0, byteCount);
        return result;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public final char[] getArray() {
        return this.chars;
    }

    public final int getSize() {
        return this.logicalSize;
    }
}

