/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.lang.reflect.Field;
import java.util.Vector;
import quicktime.internal.jdirect.JDAccessController;
import quicktime.internal.jdirect.JDPrivilegedAction;
import quicktime.internal.jdirect.LinkerAbstract;

class FieldScanner {
    private static final Class kClosureClass = class$quicktime$internal$jdirect$MethodClosure == null ? (class$quicktime$internal$jdirect$MethodClosure = FieldScanner.class$("quicktime.internal.jdirect.MethodClosure")) : class$quicktime$internal$jdirect$MethodClosure;
    private static final Class kLinkerClass = class$quicktime$internal$jdirect$Linker == null ? (class$quicktime$internal$jdirect$Linker = FieldScanner.class$("quicktime.internal.jdirect.Linker")) : class$quicktime$internal$jdirect$Linker;
    private static final Class kObjectClass = class$java$lang$Object == null ? (class$java$lang$Object = FieldScanner.class$("java.lang.Object")) : class$java$lang$Object;
    private Vector libraries = new Vector();
    private Object lock;
    private Vector classes = new Vector();
    static /* synthetic */ Class class$quicktime$internal$jdirect$MethodClosure;
    static /* synthetic */ Class class$quicktime$internal$jdirect$Linker;
    static /* synthetic */ Class class$java$lang$Object;

    public FieldScanner(final Class targetClass, final String libraryStringName, final String lockStringName, final boolean verbose) {
        if (targetClass != null) {
            JDAccessController.doPrivileged(new JDPrivilegedAction(){

                public Object run() {
                    FieldScanner.this.walkInheritanceChain(targetClass, libraryStringName, lockStringName, verbose);
                    return null;
                }
            });
        }
    }

    public Vector getLibraries() {
        return this.libraries;
    }

    public Object getLock() {
        return this.lock;
    }

    private void walkInheritanceChain(Class targetClass, String libraryStringName, String lockStringName, boolean verbose) {
        Class classWalker = targetClass;
        while (classWalker != kLinkerClass && classWalker != kClosureClass && classWalker != kObjectClass) {
            this.accumulateFieldValues(classWalker, libraryStringName, lockStringName, verbose);
            this.accumulateFieldValues(classWalker.getInterfaces(), libraryStringName, lockStringName, verbose);
            classWalker = classWalker.getSuperclass();
        }
    }

    protected static String getStaticFieldStringValue(Class cls, Field field) {
        Object value = null;
        try {
            value = field.get(cls);
        }
        catch (IllegalAccessException x) {
            value = FieldScanner.getStringFromField(cls, field, field.getName());
        }
        if (value == null) {
            System.err.println("JDIRECT WARNING: " + cls + "." + field.getName() + " is null");
            throw new IllegalArgumentException("field is null");
        }
        if (value instanceof String) {
            return (String)value;
        }
        System.err.println("JDIRECT ERROR: " + cls + "." + field.getName() + " does not contain a String");
        throw new IllegalArgumentException("field is not of type String");
    }

    protected static Object getStaticFieldObjectValue(Class cls, Field field) {
        Object value = null;
        if (field.getType().isPrimitive()) {
            System.err.println("JDIRECT ERROR: " + cls + "." + field.getName() + " is not of type Object");
            throw new IllegalArgumentException("field is not an Object");
        }
        try {
            value = field.get(cls);
        }
        catch (IllegalAccessException x) {
            value = FieldScanner.getObjectFromField(cls, field, field.getName());
        }
        if (value == null) {
            System.err.println("JDIRECT WARNING: " + cls + "." + field.getName() + " is null");
            throw new IllegalArgumentException("field is null");
        }
        return value;
    }

    private void accumulateFieldValues(Class cls, String libraryStringName, String lockStringName, boolean verbose) {
        block15: {
            Field f;
            block14: {
                if (libraryStringName != null) {
                    try {
                        f = cls.getDeclaredField(libraryStringName);
                        if ((f.getModifiers() & 8) == 0) {
                            System.err.println("JDIRECT ERROR: " + cls + "." + libraryStringName + " is not static");
                            throw new IllegalArgumentException("field is not static");
                        }
                        String value = FieldScanner.getStaticFieldStringValue(cls, f);
                        this.libraries.addElement(value);
                        if (verbose) {
                            System.err.println("           " + cls + ": found " + libraryStringName + " = \"" + value + "\"");
                        }
                    }
                    catch (NoSuchFieldException ex) {
                        if (verbose) {
                            System.err.println("           " + cls + ": does not have String field " + libraryStringName);
                        }
                    }
                    catch (Throwable t) {
                        if (!verbose) break block14;
                        System.err.println("           " + cls + ": exception accessing " + libraryStringName + ": " + t);
                    }
                }
            }
            if (lockStringName == null) break block15;
            try {
                f = cls.getDeclaredField(lockStringName);
                if ((f.getModifiers() & 8) == 0) {
                    System.err.println("JDIRECT ERROR: " + cls + "." + lockStringName + " is not static");
                    throw new IllegalArgumentException("field is not static");
                }
                Object obj = FieldScanner.getStaticFieldObjectValue(cls, f);
                if (this.lock == null) {
                    this.lock = obj;
                }
                if (verbose) {
                    System.err.println("           " + cls + ": found " + lockStringName + " = \"" + obj + "\"");
                }
            }
            catch (NoSuchFieldException ex) {
                if (verbose) {
                    System.err.println("           " + cls + ": does not have Object field " + lockStringName);
                }
            }
            catch (Throwable t) {
                if (!verbose) break block15;
                System.err.println("           " + cls + ": exception accessing " + lockStringName + ": " + t);
            }
        }
    }

    private void accumulateFieldValues(Class[] interfaces, String libraryStringName, String lockStringName, boolean verbose) {
        int i = 0;
        while (i < interfaces.length) {
            Class anInterface = interfaces[i];
            if (!this.classes.contains(anInterface)) {
                block16: {
                    Field f;
                    block15: {
                        this.classes.addElement(anInterface);
                        if (libraryStringName != null) {
                            try {
                                f = anInterface.getDeclaredField(libraryStringName);
                                String value = FieldScanner.getStaticFieldStringValue(anInterface, f);
                                this.libraries.addElement(value);
                                if (verbose) {
                                    System.err.println("           " + anInterface + ": found " + libraryStringName + " = \"" + value + "\"");
                                }
                            }
                            catch (NoSuchFieldException ex) {
                                if (verbose) {
                                    System.err.println("           " + anInterface + ": does not have String field " + libraryStringName);
                                }
                            }
                            catch (Throwable t) {
                                if (!verbose) break block15;
                                System.err.println("           " + anInterface + ": exception accessing " + libraryStringName + ": " + t);
                            }
                        }
                    }
                    if (lockStringName != null) {
                        try {
                            f = anInterface.getDeclaredField(lockStringName);
                            Object obj = FieldScanner.getStaticFieldObjectValue(anInterface, f);
                            if (this.lock == null) {
                                this.lock = obj;
                            }
                            if (verbose) {
                                System.err.println("           " + anInterface + ": found " + lockStringName + " = \"" + obj + "\"");
                            }
                        }
                        catch (NoSuchFieldException ex) {
                            if (verbose) {
                                System.err.println("           " + anInterface + ": does not have String field " + lockStringName);
                            }
                        }
                        catch (Throwable t) {
                            if (!verbose) break block16;
                            System.err.println("           " + anInterface + ": exception accessing " + lockStringName + ": " + t);
                        }
                    }
                }
                this.accumulateFieldValues(anInterface.getInterfaces(), libraryStringName, lockStringName, verbose);
            }
            ++i;
        }
    }

    private static native String getStringFromField(Class var0, Field var1, String var2) throws ExceptionInInitializerError;

    private static native Object getObjectFromField(Class var0, Field var1, String var2) throws ExceptionInInitializerError;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LinkerAbstract.loadJNILibrary();
    }
}

