/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.Accessor;
import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public abstract class HandleStruct
extends Struct {
    protected int handle;

    protected HandleStruct(int handle) {
        this.handle = handle;
    }

    protected final boolean getBooleanAt(int offset) {
        return Accessor.getBooleanFromHandle(this.handle, offset);
    }

    protected final byte getByteAt(int offset) {
        return Accessor.getByteFromHandle(this.handle, offset);
    }

    protected final char getCharAt(int offset) {
        return Accessor.getCharFromHandle(this.handle, offset);
    }

    protected final short getShortAt(int offset) {
        return Accessor.getShortFromHandle(this.handle, offset);
    }

    protected final int getIntAt(int offset) {
        return Accessor.getIntFromHandle(this.handle, offset);
    }

    protected final long getLongAt(int offset) {
        return Accessor.getLongFromHandle(this.handle, offset);
    }

    protected final float getFloatAt(int offset) {
        return Accessor.getFloatFromHandle(this.handle, offset);
    }

    protected final double getDoubleAt(int offset) {
        return Accessor.getDoubleFromHandle(this.handle, offset);
    }

    protected final void setBooleanAt(int offset, boolean value) {
        Accessor.setBooleanInHandle(this.handle, offset, value);
    }

    protected final void setByteAt(int offset, byte value) {
        Accessor.setByteInHandle(this.handle, offset, value);
    }

    protected final void setCharAt(int offset, char value) {
        Accessor.setCharInHandle(this.handle, offset, value);
    }

    protected final void setShortAt(int offset, short value) {
        Accessor.setShortInHandle(this.handle, offset, value);
    }

    protected final void setIntAt(int offset, int value) {
        Accessor.setIntInHandle(this.handle, offset, value);
    }

    protected final void setLongAt(int offset, long value) {
        Accessor.setLongInHandle(this.handle, offset, value);
    }

    protected final void setFloatAt(int offset, float value) {
        Accessor.setFloatInHandle(this.handle, offset, value);
    }

    protected final void setDoubleAt(int offset, double value) {
        Accessor.setDoubleInHandle(this.handle, offset, value);
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        if (byteOffset + source.length > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ArrayCopy.copyArrayToHandle(source, 0, this.handle, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        byte[] bytes = src.getBytesAt(0, src.getSize());
        this.setBytesAt(byteOffset, bytes);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        if (byteOffset + byteCount > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] bytes = new byte[byteCount];
        ArrayCopy.copyHandleToArray(this.handle, byteOffset, bytes, 0, byteCount);
        return bytes;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public abstract int getSize();

    public final int getHandle() {
        return this.handle;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof HandleStruct) {
            HandleStruct h = (HandleStruct)anObject;
            return this.handle == h.handle;
        }
        return false;
    }
}

