/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public class IntArrayStruct
extends Struct {
    protected int[] ints;
    private int logicalSize;

    protected IntArrayStruct(int sizeInBytes) {
        this.logicalSize = sizeInBytes;
        this.ints = new int[(sizeInBytes + 3) / 4];
    }

    protected byte getByteAt(int byteOffset) {
        int temp = this.ints[byteOffset / 4];
        int inset = byteOffset % 4;
        if (inset == Struct.INT_LOW_BYTE_OFFSET) {
            return (byte)temp;
        }
        if (inset == Struct.INT_HIGH_BYTE_OFFSET) {
            return (byte)(temp >>> 24);
        }
        if (inset == Struct.INT_THREE_BYTE_OFFSET) {
            return (byte)(temp >>> 16);
        }
        return (byte)(temp >>> 8);
    }

    protected int getIntAt(int offset) {
        if (offset % 4 == 0) {
            return this.ints[offset / 4];
        }
        return super.getIntAt(offset);
    }

    protected void setByteAt(int byteOffset, byte value) {
        int temp = this.ints[byteOffset / 4];
        int intValue = value & 0xFF;
        int inset = byteOffset % 4;
        temp = inset == Struct.INT_LOW_BYTE_OFFSET ? (temp |= intValue) : (inset == Struct.INT_HIGH_BYTE_OFFSET ? (temp |= intValue << 24) : (inset == Struct.INT_TWO_BYTE_OFFSET ? (temp |= intValue << 16) : (temp |= intValue << 8)));
        this.ints[byteOffset / 4] = temp;
    }

    protected void setIntAt(int offset, int value) {
        if (offset % 4 == 0) {
            this.ints[offset / 4] = value;
        } else {
            super.setIntAt(offset, value);
        }
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToArray(source, 0, this.ints, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int srcByteCount = src.getSize();
        ArrayCopy.copyArrayToArray(src.getBytesAt(0, srcByteCount), 0, this.ints, byteOffset, srcByteCount);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        ArrayCopy.copyArrayToArray(this.ints, byteOffset, result, 0, byteCount);
        return result;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public final int[] getArray() {
        return this.ints;
    }

    public final int getSize() {
        return this.logicalSize;
    }
}

