/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.util.Hashtable;
import java.util.Vector;
import quicktime.internal.jdirect.Linkage;
import quicktime.internal.jdirect.Linker;
import quicktime.internal.jdirect.LinkerAbstract;

class LinkerWindows
extends LinkerAbstract {
    private static String kJNILibraryName = "JDirect";

    LinkerWindows() {
    }

    String doGetJNILibraryName() {
        return kJNILibraryName;
    }

    String doGetLibraryFieldName() {
        return "JDirect_Windows";
    }

    String doGetLockObjectFieldName() {
        return "JDirect_Lock_Windows";
    }

    Object processLibraryStringsInfo(Vector libNames) {
        DLL[] libs = new DLL[libNames.size()];
        int i = 0;
        while (i < libNames.size()) {
            libs[i] = DLL.get((String)libNames.elementAt(i));
            ++i;
        }
        return libs;
    }

    private static String createAltName(String functionName, String signature) {
        int paramSize = 0;
        int i = 0;
        while (i < signature.length() && signature.charAt(i) != ')') {
            switch (signature.charAt(i)) {
                case 'B': 
                case 'Z': {
                    ++paramSize;
                    break;
                }
                case 'C': 
                case 'S': {
                    paramSize += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    paramSize += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    paramSize += 8;
                    break;
                }
                case '[': {
                    paramSize += 4;
                    ++i;
                }
            }
            ++i;
        }
        return functionName + "@" + paramSize;
    }

    long findFunction(Linkage linkage, String functionName) {
        DLL[] searchLibs = (DLL[])linkage.libInfo;
        int i = 0;
        while (i < searchLibs.length) {
            long func;
            if (searchLibs[i] != null && (func = searchLibs[i].findFunction(functionName)) != 0L) {
                return func;
            }
            ++i;
        }
        return 0L;
    }

    protected long patch(Linkage linkage, int linkageIndex, int methodIndex) {
        String methodName = linkage.methodNames[methodIndex];
        String methodSig = linkage.methodSignatures[methodIndex];
        String methodAltName = LinkerWindows.createAltName(methodName, methodSig);
        long func = this.findFunction(linkage, methodName);
        if (func != 0L) {
            return this.patch(linkage, linkageIndex, methodIndex, func);
        }
        func = this.findFunction(linkage, methodAltName);
        if (func != 0L) {
            return this.patch(linkage, linkageIndex, methodIndex, func, "@" + linkage.methodSignatures[methodIndex]);
        }
        throw new LinkageError(this.functionNotFoundMessage(linkage, methodName));
    }

    String functionNotFoundMessage(Linkage linkage, String methodName) {
        DLL[] libraries = (DLL[])linkage.libInfo;
        int libCount = libraries.length;
        int notLoadedCount = 0;
        int loadedCount = 0;
        if (Linker.verbose) {
            System.err.println("\t" + methodName + " could not be found to link via JDirect");
        }
        StringBuffer loadedLibraries = new StringBuffer();
        StringBuffer notLoadedLibraries = new StringBuffer();
        int i = 0;
        while (i < libCount) {
            if (libraries[i] != null) {
                if (libraries[i].loaded()) {
                    ++loadedCount;
                    if (loadedLibraries.length() > 0) {
                        loadedLibraries.append(", ");
                    }
                    loadedLibraries.append(libraries[i].name);
                } else {
                    ++notLoadedCount;
                    if (notLoadedLibraries.length() > 0) {
                        notLoadedLibraries.append(", ");
                    }
                    notLoadedLibraries.append(libraries[i].name);
                }
            }
            ++i;
        }
        if (libCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found . Unable to find \"JDirect_Windows\" String field";
        }
        if (loadedCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found because unable to load DLL(s) named: " + notLoadedLibraries;
        }
        if (notLoadedCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found in DLL(s) named: " + loadedLibraries;
        }
        return "JDirect native method \"" + methodName + "\" not found in DLL(s): " + loadedLibraries + ".  Unable to load DLL(s): " + notLoadedLibraries;
    }

    private static native long loadLibrary(String var0);

    private static native long getProcAddress(long var0, String var2);

    static {
        LinkerAbstract.loadJNILibrary(kJNILibraryName);
    }

    static class DLL {
        final String name;
        final long hmodule;
        static final Hashtable sLoadedLibs = new Hashtable();

        private DLL(String name, long hmodule) {
            this.name = name;
            this.hmodule = hmodule;
        }

        boolean loaded() {
            return this.hmodule != 0L;
        }

        long findFunction(String name) {
            return LinkerWindows.getProcAddress(this.hmodule, this.name);
        }

        static DLL get(String path) {
            DLL result = (DLL)sLoadedLibs.get(path);
            if (result == null) {
                result = new DLL(path, LinkerWindows.loadLibrary(path));
                sLoadedLibs.put(path, result);
            }
            return result;
        }
    }
}

