/*
 * Decompiled with CFR 0.152.
 */
package guk;

import guk.Editor_AboutBox;
import guk.LocaleSelectorMenuItem;
import guk.im.GateIM;
import guk.im.GateIMDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoManager;

public class Editor
extends JFrame {
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenu jMenuEdit = new JMenu();
    JMenu jMenuHelp = new JMenu();
    JMenu jMenuIM = null;
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JTextPane textPane = new JTextPane();
    JMenu jMenuOptions = new JMenu();
    JComboBox fontsComboBox;
    JComboBox sizeComboBox;
    JCheckBoxMenuItem jCheckBoxMenuItemKeyboardMap = new JCheckBoxMenuItem();
    Action openAction;
    Action saveAction;
    Action saveAsAction;
    Action closeAction;
    Action exitAction;
    Action undoAction;
    Action redoAction;
    Action cutAction;
    Action copyAction;
    Action pasteAction;
    Action attributesChangedAction;
    File file = null;
    JFileChooser filer = new JFileChooser();
    JFrame frame;
    UndoManager undoManager = new UndoManager();
    boolean docChanged = false;
    static /* synthetic */ Class class$guk$Editor;

    public Editor() {
        this.frame = this;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.frame.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this).setVisible(true);
    }

    private void jbInit() throws Exception {
        Locale locale = new Locale("en", "GB");
        Locale[] localeArray = new GateIMDescriptor().getAvailableLocales();
        if (localeArray != null && localeArray.length > 1) {
            this.jMenuIM = new JMenu("Input methods");
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            while (n < localeArray.length) {
                locale = localeArray[n];
                LocaleSelectorMenuItem localeSelectorMenuItem = new LocaleSelectorMenuItem(locale, this.frame);
                this.jMenuIM.add(localeSelectorMenuItem);
                buttonGroup.add(localeSelectorMenuItem);
                ++n;
            }
        }
        this.undoManager.setLimit(1000);
        this.openAction = new AbstractAction("Open", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/openFile.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (Editor.this.docChanged) {
                    n = JOptionPane.showConfirmDialog(Editor.this.frame, "Close unsaved file " + (Editor.this.file == null ? "Untitled" : Editor.this.file.getName()) + "?", "Gate", 2, 2);
                }
                if (n == 0) {
                    Editor.this.filer.setMultiSelectionEnabled(false);
                    Editor.this.filer.setDialogTitle("Select file to open...");
                    Editor.this.filer.setSelectedFile(null);
                    Editor.this.filer.setFileFilter(Editor.this.filer.getAcceptAllFileFilter());
                    int n2 = Editor.this.filer.showOpenDialog(Editor.this.frame);
                    if (n2 == 0) {
                        Object[] objectArray = new Object[]{"UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16", "ISO-8859-1", "US-ASCII"};
                        Object object = JOptionPane.showInputDialog(Editor.this.frame, "Please select the encoding for the chosen file", "Gate", 1, null, objectArray, objectArray[0]);
                        if (object == null) {
                            return;
                        }
                        Editor.this.file = Editor.this.filer.getSelectedFile();
                        try {
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(Editor.this.file)), (String)object);
                            Editor.this.textPane.selectAll();
                            Editor.this.textPane.replaceSelection("");
                            Editor.this.textPane.read(inputStreamReader, null);
                            inputStreamReader.close();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            JOptionPane.showMessageDialog(Editor.this.frame, "Cannot find the file specified!", "Gate", 0);
                            Editor.this.file = null;
                            Editor.this.docChanged = false;
                            Editor.this.updateTitle();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            JOptionPane.showMessageDialog(Editor.this.frame, "Unsupported encoding!\nPlease choose another.", "Gate", 0);
                            Editor.this.file = null;
                            Editor.this.docChanged = false;
                            Editor.this.updateTitle();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(Editor.this.frame, "Input/Output error! (wrong encoding?)\nPlease try again.", "Gate", 0);
                            Editor.this.file = null;
                            Editor.this.docChanged = false;
                            Editor.this.updateTitle();
                        }
                        Editor.this.docChanged = false;
                        Editor.this.updateTitle();
                    }
                }
            }
        };
        this.openAction.putValue("ShortDescription", "Open file...");
        this.saveAction = new AbstractAction("Save", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/saveFile.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.docChanged) {
                    if (Editor.this.file == null) {
                        Editor.this.saveAsAction.actionPerformed(null);
                    } else {
                        Object[] objectArray = new Object[]{"UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16", "ISO-8859-1", "US-ASCII"};
                        Object object = JOptionPane.showInputDialog(Editor.this.frame, "Please select the encoding for the chosen file", "Gate", 1, null, objectArray, objectArray[0]);
                        if (object == null) {
                            return;
                        }
                        try {
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(Editor.this.file), (String)object);
                            outputStreamWriter.write(Editor.this.textPane.getText());
                            outputStreamWriter.flush();
                            outputStreamWriter.close();
                            Editor.this.docChanged = false;
                            Editor.this.updateTitle();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            JOptionPane.showMessageDialog(Editor.this.frame, "Unsupported encoding!\nPlease choose another.", "Gate", 0);
                            Editor.this.docChanged = true;
                            Editor.this.updateTitle();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(Editor.this.frame, "Input/Output error!\nPlease try again.", "Gate", 0);
                            Editor.this.docChanged = true;
                            Editor.this.updateTitle();
                        }
                    }
                }
            }
        };
        this.saveAction.putValue("ShortDescription", "Save...");
        this.saveAsAction = new AbstractAction("Save as...", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/saveFile.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.filer.setMultiSelectionEnabled(false);
                Editor.this.filer.setDialogTitle("Select file to save to...");
                Editor.this.filer.setSelectedFile(null);
                Editor.this.filer.setFileFilter(Editor.this.filer.getAcceptAllFileFilter());
                int n = Editor.this.filer.showSaveDialog(Editor.this.frame);
                if (n == 0) {
                    File file = Editor.this.filer.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    int n2 = 0;
                    if (file.exists()) {
                        n2 = JOptionPane.showConfirmDialog(Editor.this.frame, "Overwrite existing file " + file.getName() + "?", "Gate", 2, 2);
                    }
                    if (n2 == 0) {
                        Editor.this.file = file;
                        Editor.this.docChanged = true;
                        Editor.this.saveAction.actionPerformed(null);
                    }
                }
            }
        };
        this.saveAsAction.putValue("ShortDescription", "Save as...");
        this.closeAction = new AbstractAction("Close", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/closeFile.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (Editor.this.docChanged) {
                    n = JOptionPane.showConfirmDialog(Editor.this.frame, "Close unsaved file " + (Editor.this.file == null ? "Untitled" : Editor.this.file.getName()) + "?", "Gate", 2, 2);
                }
                if (n == 0) {
                    Editor.this.textPane.selectAll();
                    Editor.this.textPane.replaceSelection("");
                    Editor.this.docChanged = false;
                    Editor.this.file = null;
                    Editor.this.updateTitle();
                }
            }
        };
        this.closeAction.putValue("ShortDescription", "Close...");
        this.exitAction = new AbstractAction("Exit", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/exit.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (Editor.this.docChanged) {
                    n = JOptionPane.showConfirmDialog(Editor.this.frame, "Close unsaved file " + (Editor.this.file == null ? "Untitled" : Editor.this.file.getName()) + "?", "Gate", 2, 2);
                }
                if (n == 0) {
                    ((Component)Editor.this.frame).setVisible(false);
                    Editor.this.frame.dispose();
                    System.exit(0);
                }
            }
        };
        this.exitAction.putValue("ShortDescription", "Exit...");
        this.undoAction = new AbstractAction("Undo", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/undo.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.undoManager.canUndo()) {
                    Editor.this.undoManager.undo();
                }
            }
        };
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.undoAction.putValue("ShortDescription", "Undo...");
        this.redoAction = new AbstractAction("Redo", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/redo.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.undoManager.canRedo()) {
                    Editor.this.undoManager.redo();
                }
            }
        };
        this.redoAction.setEnabled(this.undoManager.canRedo());
        this.redoAction.putValue("ShortDescription", "Redo...");
        this.copyAction = new AbstractAction("Copy", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/copy.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textPane.copy();
            }
        };
        this.copyAction.putValue("ShortDescription", "Copy...");
        this.cutAction = new AbstractAction("Cut", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/cut.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textPane.cut();
            }
        };
        this.cutAction.putValue("ShortDescription", "Cut...");
        this.pasteAction = new AbstractAction("Paste", new ImageIcon((class$guk$Editor == null ? (class$guk$Editor = Editor.class$("guk.Editor")) : class$guk$Editor).getResource("img/paste.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textPane.paste();
            }
        };
        this.pasteAction.putValue("ShortDescription", "Paste...");
        this.attributesChangedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Editor.this.textPane.getSelectionStart();
                int n2 = Editor.this.textPane.getSelectionEnd();
                MutableAttributeSet mutableAttributeSet = Editor.this.textPane.getInputAttributes();
                StyleConstants.setFontFamily(mutableAttributeSet, (String)Editor.this.fontsComboBox.getSelectedItem());
                StyleConstants.setFontSize(mutableAttributeSet, Integer.parseInt((String)Editor.this.sizeComboBox.getSelectedItem()));
                Editor.this.textPane.setCharacterAttributes(mutableAttributeSet, false);
                Editor.this.textPane.setCaretPosition(n);
                Editor.this.textPane.moveCaretPosition(n2);
            }
        };
        this.textPane.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Editor.this.undoAction.setEnabled(Editor.this.undoManager.canUndo());
                Editor.this.redoAction.setEnabled(Editor.this.undoManager.canRedo());
                Editor.this.textPane.getDocument().addDocumentListener(new DocumentListener(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    protected void changeOccured() {
                        12.access$000(this.this$1).undoAction.setEnabled(12.access$000(this.this$1).undoManager.canUndo());
                        12.access$000(this.this$1).undoAction.putValue("ShortDescription", 12.access$000(this.this$1).undoManager.getUndoPresentationName());
                        12.access$000(this.this$1).redoAction.setEnabled(12.access$000(this.this$1).undoManager.canRedo());
                        12.access$000(this.this$1).redoAction.putValue("ShortDescription", 12.access$000(this.this$1).undoManager.getRedoPresentationName());
                        if (12.access$000(this.this$1).docChanged) {
                            return;
                        }
                        12.access$000(this.this$1).docChanged = true;
                        12.access$000(this.this$1).updateTitle();
                    }
                });
                Editor.this.undoManager.discardAllEdits();
                Editor.this.textPane.getDocument().addUndoableEditListener(Editor.this.undoManager);
            }

            static /* synthetic */ Editor access$000(12 var0) {
                return var0.Editor.this;
            }
        });
        this.fontsComboBox = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.fontsComboBox.setEditable(false);
        this.fontsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.attributesChangedAction.actionPerformed(null);
            }
        });
        this.sizeComboBox = new JComboBox<Object>(new Object[]{"6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26"});
        this.sizeComboBox.setEditable(true);
        this.sizeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer.parseInt((String)Editor.this.sizeComboBox.getSelectedItem());
                    Editor.this.attributesChangedAction.actionPerformed(null);
                }
                catch (NumberFormatException numberFormatException) {
                    Editor.this.sizeComboBox.setSelectedIndex(3);
                }
            }
        });
        this.fontsComboBox.setSelectedItem(StyleConstants.getFontFamily(this.textPane.getInputAttributes()));
        this.sizeComboBox.setSelectedItem(String.valueOf(StyleConstants.getFontSize(this.textPane.getInputAttributes())));
        this.textPane.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (caretEvent.getDot() == caretEvent.getMark()) {
                    Editor.this.fontsComboBox.setSelectedItem(StyleConstants.getFontFamily(Editor.this.textPane.getCharacterAttributes()));
                    Editor.this.sizeComboBox.setSelectedItem(String.valueOf(StyleConstants.getFontSize(Editor.this.textPane.getCharacterAttributes())));
                }
            }
        });
        this.fontsComboBox.setMaximumSize(new Dimension(150, 25));
        this.fontsComboBox.setPreferredSize(new Dimension(150, 25));
        this.sizeComboBox.setMaximumSize(new Dimension(50, 25));
        this.sizeComboBox.setPreferredSize(new Dimension(50, 25));
        this.sizeComboBox.enableInputMethods(false);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        ((Component)this).setSize(new Dimension(800, 600));
        this.updateTitle();
        this.jMenuFile.setText("File");
        this.jMenuEdit.setText("Edit");
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.jMenuOptions.setText("Options");
        this.jCheckBoxMenuItemKeyboardMap.setText("Keyboard Map");
        this.jCheckBoxMenuItemKeyboardMap.setSelected(false);
        this.jCheckBoxMenuItemKeyboardMap.setMnemonic('0');
        this.jCheckBoxMenuItemKeyboardMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.jCheckBoxMenuItemKeyboardMap_stateChanged(actionEvent);
            }
        });
        this.jToolBar.add(this.openAction);
        this.jToolBar.add(this.saveAction);
        this.jToolBar.add(this.closeAction);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.undoAction);
        this.jToolBar.add(this.redoAction);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.cutAction);
        this.jToolBar.add(this.copyAction);
        this.jToolBar.add(this.pasteAction);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.fontsComboBox);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.sizeComboBox);
        this.jToolBar.add(Box.createHorizontalGlue());
        this.jMenuFile.add(this.openAction);
        this.jMenuFile.add(this.saveAction);
        this.jMenuFile.add(this.saveAsAction);
        this.jMenuFile.add(this.closeAction);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.exitAction);
        this.jMenuEdit.add(this.cutAction);
        this.jMenuEdit.add(this.copyAction);
        this.jMenuEdit.add(this.pasteAction);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.undoAction);
        this.jMenuEdit.add(this.redoAction);
        this.jMenuOptions.add(this.jCheckBoxMenuItemKeyboardMap);
        if (this.jMenuIM != null) {
            this.jMenuOptions.add(this.jMenuIM);
        }
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuOptions);
        this.jMenuBar1.add(this.jMenuHelp);
        this.textPane.setEditorKit(new StyledEditorKit());
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)new JScrollPane(this.textPane), "Center");
    }

    protected void updateTitle() {
        String string = "Gate Unicode Editor - ";
        string = this.file != null ? string + this.file.getName() : string + "Untitled";
        if (this.docChanged) {
            string = string + "*";
        }
        this.frame.setTitle(string);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new Editor();
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        Editor_AboutBox editor_AboutBox = new Editor_AboutBox(this);
        Dimension dimension = editor_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        ((Component)editor_AboutBox).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        editor_AboutBox.setModal(true);
        editor_AboutBox.show();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exitAction.actionPerformed(null);
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    void jCheckBoxMenuItemKeyboardMap_stateChanged(ActionEvent actionEvent) {
        Object object = this.getInputContext().getInputMethodControlObject();
        if (object != null && object instanceof GateIM) {
            ((GateIM)object).setMapVisible(this.jCheckBoxMenuItemKeyboardMap.getState());
        } else {
            this.jCheckBoxMenuItemKeyboardMap.setState(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

