/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    protected Vector tracks = new Vector();

    public Sequence(float divisionType, int resolution) throws InvalidMidiDataException {
        if (divisionType == 0.0f) {
            this.divisionType = 0.0f;
        } else if (divisionType == 24.0f) {
            this.divisionType = 24.0f;
        } else if (divisionType == 25.0f) {
            this.divisionType = 25.0f;
        } else if (divisionType == 29.97f) {
            this.divisionType = 29.97f;
        } else if (divisionType == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + divisionType);
        }
        this.resolution = resolution;
    }

    public Sequence(float divisionType, int resolution, int numTracks) throws InvalidMidiDataException {
        if (divisionType == 0.0f) {
            this.divisionType = 0.0f;
        } else if (divisionType == 24.0f) {
            this.divisionType = 24.0f;
        } else if (divisionType == 25.0f) {
            this.divisionType = 25.0f;
        } else if (divisionType == 29.97f) {
            this.divisionType = 29.97f;
        } else if (divisionType == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + divisionType);
        }
        this.resolution = resolution;
        int i = 0;
        while (i < numTracks) {
            this.tracks.addElement(new Track());
            ++i;
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.addElement(track);
        return track;
    }

    public boolean deleteTrack(Track track) {
        Vector vector = this.tracks;
        synchronized (vector) {
            boolean bl = this.tracks.removeElement(track);
            return bl;
        }
    }

    public Track[] getTracks() {
        Vector vector = this.tracks;
        synchronized (vector) {
            Track[] trackArray = new Track[this.tracks.size()];
            int i = 0;
            while (i < trackArray.length) {
                trackArray[i] = (Track)this.tracks.elementAt(i);
                ++i;
            }
            Track[] trackArray2 = trackArray;
            return trackArray2;
        }
    }

    public long getMicrosecondLength() {
        long ticks = this.getTickLength();
        if (this.divisionType != 0.0f) {
            double seconds = (double)this.getTickLength() / (double)(this.divisionType * (float)this.resolution);
            return (long)(1.0E9 * seconds);
        }
        Track tempos = new Track();
        Track tmpTrack = null;
        MidiEvent tmpEvent = null;
        MidiMessage tmpMessage = null;
        Object tmpMeta = null;
        Vector vector = this.tracks;
        synchronized (vector) {
            int i = 0;
            while (i < this.tracks.size()) {
                tmpTrack = (Track)this.tracks.elementAt(i);
                int j = 0;
                while (j < tmpTrack.size()) {
                    tmpEvent = tmpTrack.get(j);
                    tmpMessage = tmpEvent.getMessage();
                    if (tmpMessage instanceof MetaMessage && ((MetaMessage)tmpMessage).getType() == 81) {
                        tempos.add(tmpEvent);
                    }
                    ++j;
                }
                ++i;
            }
        }
        int tempo = 500000;
        long microseconds = 0L;
        long runningTick = 0L;
        long tmpTick = 0L;
        int i = 0;
        while (i < tempos.size() - 1) {
            tmpEvent = tempos.get(i);
            tmpTick = tmpEvent.getTick();
            if (tmpTick >= runningTick) {
                microseconds += (tmpTick - runningTick) * (long)tempo / (long)this.resolution;
                runningTick = tmpTick;
                byte[] data = ((MetaMessage)tmpEvent.getMessage()).getMessage();
                tempo = 0xFF & data[5];
                tempo |= (0xFF & data[4]) << 8;
                tempo |= (0xFF & data[3]) << 16;
            }
            ++i;
        }
        tmpTick = this.getTickLength();
        if (tmpTick > runningTick) {
            microseconds += (tmpTick - runningTick) * (long)tempo / (long)this.resolution;
        }
        return microseconds;
    }

    public long getTickLength() {
        long length = 0L;
        Vector vector = this.tracks;
        synchronized (vector) {
            int i = 0;
            while (i < this.tracks.size()) {
                long temp = ((Track)this.tracks.elementAt(i)).ticks();
                if (temp > length) {
                    length = temp;
                }
                ++i;
            }
            long l = length;
            return l;
        }
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

